/* 2004.06.05, 2004.09.20, 2004.10.22, 2004.11.20, 2004.12.12, 2004.12.28, 2005.01.04, 2005.01.12, 2005.01.26, 2005.03.01, 2005.07.29, 2005.12.28, 2006.08.02, 2007.08.16, 2011.08.02
****************************************
**  Copyright  (C)  W.ch  1999-2007   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Interface for CH375 **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* CH375 ļϵͳӿ */
/* ֧: FAT12/FAT16/FAT32 */
/* MCS51Ƭ, ѯʽжϷʽ, ֧С//ģʽ */
/* ֧3ݴȡʽ: ͨĵDPTRлʽ, ATMEL/PHILIPS/SSTȵƬ˫DPTRлʽ, P2+R0ָ˿ڶDPTRָⲿRAMķʽ */
/* CH375HF4CH375HF6.LIBŻ棬Ҫ֧CH375BоƬ֧ⲿӳƷʽ */

#ifndef __CH375HF_H__
#define __CH375HF_H__

#define CH375_LIB_VER		0x39

#ifdef __cplusplus
extern "C" {
#endif

/* FILE: CH375INC.H */

/* ********************************************************************************************************************* */
/* Ӳ */

#define	CH375_MAX_DATA_LEN	0x40			/* ݰĳ, ĳ */

/* ********************************************************************************************************************* */
/*  */

#define	CMD_GET_IC_VER		0x01			/* ȡоƬ̼汾 */
/* : 汾( λ7Ϊ1, λ6Ϊ0, λ5~λ0Ϊ汾 ) */
/*           CH375Bذ汾ŵֵΪ0B7H汾Ϊ37H */

#define	CMD_ENTER_SLEEP		0x03			/* ˯״̬ */

#define	CMD_SET_USB_SPEED	0x04			/* USBٶ, ÿCMD_SET_USB_MODEUSBģʽʱԶָ12Mbpsȫ */
/* : ٶȴ */
/*           00H=12MbpsȫFullSpeedĬֵ, 01H=1.5Mbps޸Ƶʣ, 02H=1.5MbpsLowSpeed */
#define	CMD_SET_SYS_FREQ	CMD_SET_USB_SPEED

#define	CMD_RESET_ALL		0x05			/* ִӲλ */

#define	CMD_CHECK_EXIST		0x06			/* Թ״̬ */
/* :  */
/* : ݵİλȡ */

#define	CMD_GET_TOGGLE		0x0A			/* ȡOUTͬ״̬ */
/* : 1AH */
/* : ͬ״̬ */
/*           λ4Ϊ1OUTͬ, OUTͬ */

#define	CMD_CHK_SUSPEND		0x0B			/* 豸ʽ: üUSB߹״̬ķʽ */
/* : 10H, 鷽ʽ */
/*                    00H=USB, 04H=50mSΪUSB, 05H=10mSΪUSB */

#define	CMD_DELAY_100US		0x0F			/* ڷʽ: ʱ100uS */
/* : ʱڼ0, ʱ0 */

#define	CMD_SET_USB_ID		0x12			/* 豸ʽ: USBVIDͲƷPID */
/* : IDֽ, IDֽ, ƷIDֽ, ƷIDֽ */

#define	CMD_SET_USB_ADDR	0x13			/* USBַ */
/* : ֵַ */

#define	CMD_SET_USB_MODE	0x15			/* USBģʽ */
/* : ģʽ */
/*       00H=δõ豸ʽ, 01H=õ豸ʽʹⲿ̼ģʽ, 02H=õ豸ʽʹù̼ģʽ */
/*       04H=δõʽ, 05H=õʽ, 06H=õʽԶSOF, 07H=õʽҸλUSB */
/* : ״̬( CMD_RET_SUCCESSCMD_RET_ABORT, ֵ˵δ ) */

#define	CMD_SET_ENDP2		0x18			/* 豸ʽ: USB˵0Ľ */
/* : ʽ */
/*           λ7Ϊ1λ6Ϊͬλ, ͬλ */
/*           λ3~λ0ΪӦʽ:  0000-ACK, 1110-æNAK, 1111-STALL */

#define	CMD_SET_ENDP3		0x19			/* 豸ʽ: USB˵0ķ */
/* : ʽ */
/*           λ7Ϊ1λ6Ϊͬλ, ͬλ */
/*           λ3~λ0ΪӦʽ:  0000~1000-ACK, 1110-æNAK, 1111-STALL */

#define	CMD_SET_ENDP4		0x1A			/* 豸ʽ: USB˵1Ľ */
/* : ʽ */
/*           λ7Ϊ1λ6Ϊͬλ, ͬλ */
/*           λ3~λ0ΪӦʽ:  0000-ACK, 1110-æNAK, 1111-STALL */

#define	CMD_SET_ENDP5		0x1B			/* 豸ʽ: USB˵1ķ */
/* : ʽ */
/*           λ7Ϊ1λ6Ϊͬλ, ͬλ */
/*           λ3~λ0ΪӦʽ:  0000~1000-ACK, 1110-æNAK, 1111-STALL */

#define	CMD_SET_ENDP6		0x1C			/* USB˵2/˵Ľ */
/* : ʽ */
/*           λ7Ϊ1λ6Ϊͬλ, ͬλ */
/*           λ3~λ0ΪӦʽ:  0000-ACK, 1101-ACK, 1110-æNAK, 1111-STALL */

#define	CMD_SET_ENDP7		0x1D			/* USB˵2/˵ķ */
/* : ʽ */
/*           λ7Ϊ1λ6Ϊͬλ, ͬλ */
/*           λ3~λ0ΪӦʽ:  0000-ACK, 1101-Ӧ, 1110-æNAK, 1111-STALL */

#define	CMD_GET_STATUS		0x22			/* ȡж״̬ȡж */
/* : ж״̬ */

#define	CMD_UNLOCK_USB		0x23			/* 豸ʽ: ͷŵǰUSB */

#define	CMD_RD_USB_DATA0	0x27			/* ӵǰUSBжϵĶ˵㻺ȡݿ */
/* : ,  */

#define	CMD_RD_USB_DATA		0x28			/* ӵǰUSBжϵĶ˵㻺ȡݿ, ͷŻ, ൱ CMD_RD_USB_DATA0 + CMD_UNLOCK_USB */
/* : ,  */

#define	CMD_WR_USB_DATA3	0x29			/* 豸ʽ: USB˵0ķͻдݿ */
/* : ,  */

#define	CMD_WR_USB_DATA5	0x2A			/* 豸ʽ: USB˵1ķͻдݿ */
/* : ,  */

#define	CMD_WR_USB_DATA7	0x2B			/* USB˵2˵ķͻдݿ */
/* : ,  */

/* ************************************************************************** */
/* USBʽ, ֻCH375֧ */

#define	CMD_SET_BAUDRATE	0x02			/* ʽ & ڷʽ: ôͨѶ */
/* : ʷƵϵ, ʷƵ */
/* : ״̬( CMD_RET_SUCCESSCMD_RET_ABORT, ֵ˵δ ) */

#define	CMD_SET_RETRY		0x0B			/* ʽ: USBԴ */
/* : 25H, Դ */
/*                    λ7Ϊ0յNAKʱ, λ7Ϊ1λ6Ϊ0յNAKʱ, λ7Ϊ1λ6Ϊ1յNAKʱ2, λ5~λ0ΪʱԴ */

#define	CMD_SET_DISK_LUN	0x0B			/* ʽ: USB洢ĵǰ߼Ԫ */
/* : 34H, µĵǰ߼Ԫ(00H-0FH) */

#define	CMD_SET_PKT_P_SEC	0x0B			/* ʽ: USB洢ÿݰ */
/* : 39H, µÿݰ(08H,10H,20H,40H) */

#define	CMD_TEST_CONNECT	0x16			/* ʽ: USB豸״̬ */
/* : ״̬( USB_INT_CONNECTUSB_INT_DISCONNECTUSB_INT_USB_READY, ֵ˵δ ) */

#define	CMD_ABORT_NAK		0x17			/* ʽ: ǰNAK */

#define	CMD_CLR_STALL		0x41			/* ʽ: ƴ-˵ */
/* : ˵ */
/* ж */

#define	CMD_SET_ADDRESS		0x45			/* ʽ: ƴ-USBַ */
/* : ֵַ */
/* ж */

#define	CMD_GET_DESCR		0x46			/* ʽ: ƴ-ȡ */
/* :  */
/* ж */

#define	CMD_SET_CONFIG		0x49			/* ʽ: ƴ-USB */
/* : ֵ */
/* ж */

#define	CMD_AUTO_SETUP		0x4D			/* ʽ: ԶUSB豸 */
/* ж */

#define	CMD_ISSUE_TKN_X		0x4E			/* ʽ: ͬ, ִ, ɴ CMD_SET_ENDP6/CMD_SET_ENDP7 + CMD_ISSUE_TOKEN */
/* : ͬ־,  */
/*           ͬ־λ7Ϊ˵INͬλ, λ6Ϊ˵OUTͬλ, λ5~λ0Ϊ0 */
/*           Եĵ4λ, 4λǶ˵ */
/* ж */

#define	CMD_ISSUE_TOKEN		0x4F			/* ʽ: , ִ */
/* :  */
/*           4λ, 4λǶ˵ */
/* ж */

#define	CMD_DISK_BOC_CMD	0x50			/* ʽ: USB洢ִBulkOnlyЭ */
/* ж */

#define	CMD_DISK_INIT		0x51			/* ʽ: ʼUSB洢 */
/* ж */

#define	CMD_DISK_RESET		0x52			/* ʽ: λUSB洢 */
/* ж */

#define	CMD_DISK_SIZE		0x53			/* ʽ: ȡUSB洢 */
/* ж */

#define	CMD_DISK_READ		0x54			/* ʽ: USB洢ݿ(Ϊλ) */
/* : LBAַ(ܳ32λ, ֽǰ), (01H~FFH) */
/* ж */

#define	CMD_DISK_RD_GO		0x55			/* ʽ: ִUSB洢Ķ */
/* ж */

#define	CMD_DISK_WRITE		0x56			/* ʽ: USB洢дݿ(Ϊλ) */
/* : LBAַ(ܳ32λ, ֽǰ), (01H~FFH) */
/* ж */

#define	CMD_DISK_WR_GO		0x57			/* ʽ: ִUSB洢д */
/* ж */

#define	CMD_DISK_INQUIRY	0x58			/* ʽ: ѯUSB洢 */
/* ж */

#define	CMD_DISK_READY		0x59			/* ʽ: USB洢 */
/* ж */

#define	CMD_DISK_R_SENSE	0x5A			/* ʽ: USB洢 */
/* ж */

#define	CMD_DISK_MAX_LUN	0x5D			/* ʽ: ȡUSB洢߼Ԫ */
/* ж */

/* ********************************************************************************************************************* */
/* ״̬ */

#define	CMD_RET_SUCCESS		0x51			/* ɹ */
#define	CMD_RET_ABORT		0x5F			/* ʧ */

/* ********************************************************************************************************************* */
/* USBж״̬ */

#ifndef	USB_INT_EP0_SETUP

/* ״̬Ϊ¼ж, ͨCMD_CHK_SUSPENDUSB߹, ô봦USB߹˯߻ѵж״̬ */
#define	USB_INT_USB_SUSPEND	0x05			/* USB߹¼ */
#define	USB_INT_WAKE_UP		0x06			/* ˯б¼ */

/* ״̬0XHUSB豸ʽ */
/*   ù̼ģʽֻҪ: USB_INT_EP1_OUT, USB_INT_EP1_IN, USB_INT_EP2_OUT, USB_INT_EP2_IN */
/*   λ7-λ4Ϊ0000 */
/*   λ3-λ2ָʾǰ, 00=OUT, 10=IN, 11=SETUP */
/*   λ1-λ0ָʾǰ˵, 00=˵0, 01=˵1, 10=˵2, 11=USB߸λ */
#define	USB_INT_EP0_SETUP	0x0C			/* USB˵0SETUP */
#define	USB_INT_EP0_OUT		0x00			/* USB˵0OUT */
#define	USB_INT_EP0_IN		0x08			/* USB˵0IN */
#define	USB_INT_EP1_OUT		0x01			/* USB˵1OUT */
#define	USB_INT_EP1_IN		0x09			/* USB˵1IN */
#define	USB_INT_EP2_OUT		0x02			/* USB˵2OUT */
#define	USB_INT_EP2_IN		0x0A			/* USB˵2IN */
/* USB_INT_BUS_RESET	0x0000XX11B */		/* USB߸λ */
#define	USB_INT_BUS_RESET1	0x03			/* USB߸λ */
#define	USB_INT_BUS_RESET2	0x07			/* USB߸λ */
#define	USB_INT_BUS_RESET3	0x0B			/* USB߸λ */
#define	USB_INT_BUS_RESET4	0x0F			/* USB߸λ */

#endif

/* ״̬2XH-3XHUSBʽͨѶʧܴ, CH375֧ */
/*   λ7-λ6Ϊ00 */
/*   λ5Ϊ1 */
/*   λ4ָʾǰյݰǷͬ */
/*   λ3-λ0ָʾͨѶʧʱUSB豸Ӧ: 0010=ACK, 1010=NAK, 1110=STALL, 0011=DATA0, 1011=DATA1, XX00=ʱ */
/* USB_INT_RET_ACK	0x001X0010B */			/* :IN񷵻ACK */
/* USB_INT_RET_NAK	0x001X1010B */			/* :NAK */
/* USB_INT_RET_STALL	0x001X1110B */		/* :STALL */
/* USB_INT_RET_DATA0	0x001X0011B */		/* :OUT/SETUP񷵻DATA0 */
/* USB_INT_RET_DATA1	0x001X1011B */		/* :OUT/SETUP񷵻DATA1 */
/* USB_INT_RET_TOUT	0x001XXX00B */			/* :سʱ */
/* USB_INT_RET_TOGX	0x0010X011B */			/* :IN񷵻ݲͬ */
/* USB_INT_RET_PID	0x001XXXXXB */			/* :δ */

/* ״̬1XHUSBʽĲ״̬, CH375֧ */
#ifndef	USB_INT_SUCCESS
#define	USB_INT_SUCCESS		0x14			/* USBߴɹ */
#define	USB_INT_CONNECT		0x15			/* ⵽USB豸¼ */
#define	USB_INT_DISCONNECT	0x16			/* ⵽USB豸Ͽ¼ */
#define	USB_INT_BUF_OVER	0x17			/* USBƴ̫,  */
#define	USB_INT_USB_READY	0x18			/* USB豸ѾʼѷUSBַ */
#define	USB_INT_DISK_READ	0x1D			/* USB洢ݿ, ݶ */
#define	USB_INT_DISK_WRITE	0x1E			/* USB洢дݿ, д */
#define	USB_INT_DISK_ERR	0x1F			/* USB洢ʧ */
#endif

/* ********************************************************************************************************************* */
/* USB */

/* USBİʶPID, ʽõ */
#ifndef	DEF_USB_PID_SETUP
#define	DEF_USB_PID_NULL	0x00			/* PID, δ */
#define	DEF_USB_PID_SOF		0x05
#define	DEF_USB_PID_SETUP	0x0D
#define	DEF_USB_PID_IN		0x09
#define	DEF_USB_PID_OUT		0x01
#define	DEF_USB_PID_ACK		0x02
#define	DEF_USB_PID_NAK		0x0A
#define	DEF_USB_PID_STALL	0x0E
#define	DEF_USB_PID_DATA0	0x03
#define	DEF_USB_PID_DATA1	0x0B
#define	DEF_USB_PID_PRE		0x0C
#endif

/* USB, ù̼ģʽõ */
#ifndef	DEF_USB_REQ_TYPE
#define	DEF_USB_REQ_READ	0x80			/* ƶ */
#define	DEF_USB_REQ_WRITE	0x00			/* д */
#define	DEF_USB_REQ_TYPE	0x60			/*  */
#define	DEF_USB_REQ_STAND	0x00			/* ׼ */
#define	DEF_USB_REQ_CLASS	0x20			/* 豸 */
#define	DEF_USB_REQ_VENDOR	0x40			/*  */
#define	DEF_USB_REQ_RESERVE	0x60			/*  */
#endif

/* USB׼豸, RequestTypeλ6λ5=00(Standard), ù̼ģʽõ */
#ifndef	DEF_USB_GET_DESCR
#define	DEF_USB_CLR_FEATURE	0x01
#define	DEF_USB_SET_FEATURE	0x03
#define	DEF_USB_GET_STATUS	0x00
#define	DEF_USB_SET_ADDRESS	0x05
#define	DEF_USB_GET_DESCR	0x06
#define	DEF_USB_SET_DESCR	0x07
#define	DEF_USB_GET_CONFIG	0x08
#define	DEF_USB_SET_CONFIG	0x09
#define	DEF_USB_GET_INTERF	0x0A
#define	DEF_USB_SET_INTERF	0x0B
#define	DEF_USB_SYNC_FRAME	0x0C
#endif

/* ********************************************************************************************************************* */

/* FILE: CH375HF.H */

#ifdef __CX51__
#ifndef __C51__
#define __C51__		1
#endif
#endif

#ifdef __C51__
typedef bit bdata                    BOOL1;
#else
#define data
#define idata
#define xdata
typedef unsigned char                BOOL1;
#endif

#ifndef UINT8
typedef unsigned char                UINT8;
#endif
#ifndef UINT16
typedef unsigned short               UINT16;
#endif
#ifndef UINT32
typedef unsigned long                UINT32;
#endif
#ifndef UINT8D
typedef unsigned char  data          UINT8D;
#endif
#ifndef UINT16D
typedef unsigned short data          UINT16D;
#endif
#ifndef UINT32D
typedef unsigned long  data          UINT32D;
#endif
#ifndef UINT8I
typedef unsigned char  idata         UINT8I;
#endif
#ifndef UINT16I
typedef unsigned short idata         UINT16I;
#endif
#ifndef UINT32I
typedef unsigned long  idata         UINT32I;
#endif
#ifndef UINT8X
typedef unsigned char  xdata         UINT8X;
#endif
#ifndef UINT16X
typedef unsigned short xdata         UINT16X;
#endif
#ifndef UINT32X
typedef unsigned long  xdata         UINT32X;
#endif
#ifndef PUINT8
typedef unsigned char               *PUINT8;
#endif
#ifndef PUINT16
typedef unsigned short              *PUINT16;
#endif
#ifndef PUINT32
typedef unsigned long               *PUINT32;
#endif
#ifndef PUINT8I
typedef unsigned char  idata        *PUINT8I;
#endif
#ifndef PUINT16I
typedef unsigned short idata        *PUINT16I;
#endif
#ifndef PUINT32I
typedef unsigned long  idata        *PUINT32I;
#endif
#ifndef PUINT8X
typedef unsigned char  xdata        *PUINT8X;
#endif
#ifndef PUINT16X
typedef unsigned short xdata        *PUINT16X;
#endif
#ifndef PUINT32X
typedef unsigned long  xdata        *PUINT32X;
#endif
#ifndef PUINT8C
typedef unsigned char  code         *PUINT8C;
#endif
#ifndef UINT8V
typedef unsigned char volatile       UINT8V;
#endif
#ifndef UINT8DV
typedef unsigned char volatile data  UINT8DV;
#endif
#ifndef UINT8XV
typedef unsigned char volatile xdata UINT8XV;
#endif

/*  */
#define ERR_SUCCESS				0x00	/* ɹ */
#define ERR_CH375_ERROR			0x81	/* CH375Ӳ,ҪλCH375 */
#define ERR_DISK_DISCON			0x82	/* δ,ܴѾϿ */
#define ERR_STATUS_ERR			0x83	/* ״̬,ӻ߶Ͽ */
#define ERR_MBR_ERROR			0x91	/* ̵¼Ч,ܴδδʽ */
#define ERR_TYPE_ERROR			0x92	/* ̷Ͳ֧,ֻ֧FAT12/FAT16/BigDOS/FAT32,Ҫɴ̹· */
#define ERR_BPB_ERROR			0xA1	/* δʽ,߲,ҪWINDOWSĬϲ¸ʽ */
#define ERR_TOO_LARGE			0xA2	/* ̷ʽ4GB,250GB,ҪWINDOWSĬϲ¸ʽ */
#define ERR_FAT_ERROR			0xA3	/* ̵ļϵͳ֧,ֻ֧FAT12/FAT16/FAT32,ҪWINDOWSĬϲ¸ʽ */
#define ERR_DISK_FULL			0xB1	/* ļ̫,ʣռ̫ٻѾû,Ҫ */
#define ERR_FDT_OVER			0xB2	/* Ŀ¼ļ̫,ûпеĿ¼,FAT12/FAT16Ŀ¼µļӦ500,Ҫ */
#define ERR_MISS_DIR			0xB3	/* ָ·ĳĿ¼ûҵ,Ŀ¼ƴ */
#define ERR_FILE_CLOSE			0xB4	/* ļѾر,Ҫʹ,Ӧ´ļ */
#define ERR_OPEN_DIR			0x41	/* ָ·Ŀ¼ */
#define ERR_MISS_FILE			0x42	/* ָ·ļûҵ,ļƴ */
#define ERR_FOUND_NAME			0x43	/* ͨƥļ,ļ·,Ҫʹ,Ӧô򿪸ļ */
/* 2XH-3XHUSBʽͨѶʧܴ,CH375 */
/* 1XHUSBʽĲ״̬,CH375 */
#define	ERR_USB_CONNECT			0x15	/* ⵽USB豸¼,Ѿ */
#define	ERR_USB_DISCON			0x16	/* ⵽USB豸Ͽ¼,ѾϿ */
#define	ERR_USB_DISK_ERR		0x1F	/* USB洢ʧ,ڳʼʱUSB洢֧,ڶдпǴ𻵻ѾϿ */

/* ̼ļ״̬ */
#define DISK_UNKNOWN			0x00	/* δʼ,δ֪״̬ */
#define DISK_DISCONNECT			0x01	/* ûӻѾϿ */
#define DISK_CONNECT			0x02	/* Ѿ,δʼ޷ʶô */
#define DISK_MOUNTED			0x03	/* Ѿʼɹ,δļϵͳļϵͳ֧ */
#define DISK_READY				0x10	/* Ѿ̵ļϵͳܹ֧ */
#define DISK_OPEN_ROOT			0x12	/* Ѿ򿪸Ŀ¼,ģʽ,ֻΪλдĿ¼,ʹúر,עFAT12/FAT16Ŀ¼ǹ̶ */
#define DISK_OPEN_DIR			0x13	/* ѾĿ¼,ģʽ,ֻΪλдĿ¼ */
#define DISK_OPEN_FILE			0x14	/* Ѿļ,ģʽ,Ϊλݶд */
#define DISK_OPEN_FILE_B		0x15	/* Ѿļ,ֽģʽ,ֽΪλݶд */

/* FATͱ־ */
#define DISK_FS_UNKNOWN			0		/* δ֪ļϵͳ */
#define DISK_FAT12				1		/* FAT12ļϵͳ */
#define DISK_FAT16				2		/* FAT16ļϵͳ */
#define DISK_FAT32				3		/* FAT32ļϵͳ */

/* ļ */
#define ATTR_READ_ONLY			0x01	/* ļΪֻ */
#define ATTR_HIDDEN				0x02	/* ļΪ */
#define ATTR_SYSTEM				0x04	/* ļΪϵͳ */
#define ATTR_VOLUME_ID			0x08	/*  */
#define ATTR_DIRECTORY			0x10	/* Ŀ¼ */
#define ATTR_ARCHIVE			0x20	/* ļΪ浵 */
#define ATTR_LONG_NAME			( ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_VOLUME_ID )
/* ļ UINT8 */
/* bit0 bit1 bit2 bit3 bit4 bit5 bit6 bit7 */
/*  ֻ      ϵ      Ŀ      δ   */
/*        ͳ      ¼               */
/* ļʱ UINT16 */
/* Time = (Hour<<11) + (Minute<<5) + (Second>>1) */
#define MAKE_FILE_TIME( h, m, s )	( (h<<11) + (m<<5) + (s>>1) )	/* ָʱļʱ */
/* ļ UINT16 */
/* Date = ((Year-1980)<<9) + (Month<<5) + Day */
#define MAKE_FILE_DATE( y, m, d )	( ((y-1980)<<9) + (m<<5) + d )	/* ָյļ */

/* ļ */
#define PATH_WILDCARD_CHAR		0x2A	/* ·ͨ '*' */
#define PATH_SEPAR_CHAR1		0x5C	/* ·ķָ '\' */
#define PATH_SEPAR_CHAR2		0x2F	/* ·ķָ '/' */
#ifndef MAX_PATH_LEN
#define MAX_PATH_LEN			30		/* ·,бָܷСԼ·00H */
#endif
#ifndef MAX_BYTE_IO
#define MAX_BYTE_IO		( MAX_PATH_LEN - 1 )	/* ֽΪλζдļʱ󳤶,óȿԷֶζд */
#endif

/* ⲿ */
typedef union _CMD_PARAM {
	struct {
		UINT8	mBuffer[ MAX_PATH_LEN ];
	} Other;
	struct {
		UINT32	mReserved;
		UINT32	mTotalSector;			/* : ǰ߼̵ */
		UINT32	mFreeSector;			/* : ǰ߼̵ʣ */
		UINT8	mDiskFat;				/* : ǰ߼̵FAT */
	} Query;							/* CMD_DiskQuery, ѯϢ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Open;								/* CMD_FileOpen, ļ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ(ͨ*)...,ö], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILE*",00H */
	} Enumer;							/* CMD_FileEnumer, öļ,ļ */
	struct {
		UINT8	mUpdateLen;				/* : Ƿ³: 0ֹ,1 */
	} Close;							/* CMD_FileClose, رյǰļ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Create;							/* CMD_FileCreate, ½ļ,ļѾɾ½ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Erase;							/* CMD_FileErase, ɾļر */
	struct {
		UINT32	mFileSize;				/* : µļ,Ϊ0FFFFFFFFH޸, : ԭ */
		UINT16	mFileDate;				/* : µļ,Ϊ0FFFFH޸, : ԭ */
		UINT16	mFileTime;				/* : µļʱ,Ϊ0FFFFH޸, : ԭʱ */
		UINT8	mFileAttr;				/* : µļ,Ϊ0FFH޸, : ԭ */
	} Modify;							/* CMD_FileQuery, ѯǰļϢ; CMD_FileModify, ѯ޸ĵǰļϢ */
	struct {
		UINT32	mSectorOffset;			/* : ƫ,0ƶļͷ,0FFFFFFFFHƶļβ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
	} Locate;							/* CMD_FileLocate, ƶǰļָ */
	struct {
		UINT8	mSectorCount;			/* : ȡ, : ʵʶȡ */
	} Read;								/* CMD_FileRead, ӵǰļȡ */
	struct {
		UINT8	mSectorCount;			/* : д, : ʵд */
	} Write;							/* CMD_FileWrite, ǰļд */
	struct {
		UINT8	mSectorCount;			/* : ȡ, : ʵʶȡ */
		UINT8	mReserved[7];
		PUINT8X	mDataBuffer;			/* : ʼַ, : ǰַ */
	} ReadX;							/* CMD_FileReadX, ӵǰļȡݵָ */
	struct {
		UINT8	mSectorCount;			/* : д, : ʵд */
		UINT8	mReserved[7];
		PUINT8X	mDataBuffer;			/* : ʼַ, : ǰַ */
	} WriteX;							/* CMD_FileWriteX, ǰļдָ */
	struct {
		UINT32	mDiskSizeSec;			/* : ̵ */
	} DiskSize;							/* CMD_DiskSize, ѯ */
	struct {
		UINT32	mByteOffset;			/* : ֽΪλƫ, ֽΪλļָ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
	} ByteLocate;						/* CMD_ByteLocate, ֽΪλƶǰļָ */
	struct {
		UINT8	mByteCount;				/* : ׼ȡֽ,ôMAX_BYTE_IO, : ʵʶֽ */
		UINT8	mByteBuffer[ MAX_BYTE_IO ];	/* : ݿ */
	} ByteRead;							/* CMD_ByteRead, ֽΪλӵǰļȡݿ */
	struct {
		UINT8	mByteCount;				/* : ׼дֽ,ôMAX_BYTE_IO, : ʵдֽ */
		UINT8	mByteBuffer[ MAX_BYTE_IO ];	/* : ׼дݿ */
	} ByteWrite;						/* CMD_ByteWrite, ֽΪλǰļдݿ */
	struct {
		UINT8	mSaveVariable;			/* : Ϊ0ָU̵ı,Ϊ0x80ָU̵ı,ֵ򱸷/ */
		UINT8	mReserved[3];
		PUINT8X	mBuffer;				/* : ָӳııݻ,ȲС80ֽ */
	} SaveVariable;						/* CMD_SaveVariable, //ָӳı */
	union {
		struct {
			UINT32	mCBW_Sig;
			UINT32	mCBW_Tag;
			UINT8	mCBW_DataLen;		/* : ݴ䳤,Чֵ0255 */
			UINT8	mCBW_DataLen1;
			UINT8	mCBW_DataLen2;
			UINT8	mCBW_DataLen3;
			UINT8	mCBW_Flag;			/* : ䷽ȱ־ */
			UINT8	mCBW_LUN;
			UINT8	mCBW_CB_Len;		/* : ĳ,Чֵ116 */
			UINT8	mCBW_CB_Buf[6];		/* : ,ûΪ16ֽ */
		} mCBW;							/* BulkOnlyЭ, CBWṹ */
		struct {
			UINT32	mCSW_Sig;
			UINT32	mCSW_Tag;
			UINT32	mCSW_Residue;		/* : ʣݳ */
			UINT8	mCSW_Status;		/* : ִн״̬ */
			UINT8	mReserved;
		} mCSW;							/* BulkOnlyЭ״̬, CSWṹ */
	} BOC;								/* CMD_BulkOnlyCmd, ִлBulkOnlyЭ, ݴôpDISK_BASE_BUF */
} CMD_PARAM;

typedef CMD_PARAM idata CMD_PARAM_I;
typedef CMD_PARAM data *P_CMD_PARAM;

/* FILE: CH375HF?.C */

#define EN_DISK_WRITE			1
#define EN_DISK_FAT12			1
#define EN_DISK_FAT32			1
#define EN_BYTE_ACCESS			1
//#define EN_SAVE_VARIABLE		1
//#define EXT_BLK_INTERFACE		1
#define EN_SEC_SIZE_AUTO		1

#ifndef LIB_CFG_DISK_IO
#define LIB_CFG_DISK_IO			1		/* Ĭ,̶дݵĸƷʽΪ"DPTR" */
#endif
#ifndef LIB_CFG_FILE_IO
#define LIB_CFG_FILE_IO			1		/* Ĭ,ļдݵĸƷʽΪ"DPTR" */
#endif
#ifndef LIB_CFG_UPD_SIZE
#define LIB_CFG_UPD_SIZE		0		/* Ĭ,ݺļȵĸ·ʽΪ"" */
#endif
#ifndef LIB_CFG_NO_DLY
#define LIB_CFG_NO_DLY			0		/* Ĭ,дʱʽΪ"дʱ" */
#endif
#ifndef LIB_CFG_INT_EN
#define LIB_CFG_INT_EN			0		/* Ĭ,CH375INT#ӷʽΪ"ѯʽ" */
#endif
#ifndef DISK_BASE_BUF_LEN
#define DISK_BASE_BUF_LEN		512		/* ĬϵĴݻСΪ512ֽ,ѡΪ20484096֧ĳЩU,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */
#endif

#define LIB_CFG_VALUE		( ( LIB_CFG_INT_EN << 7 ) | ( LIB_CFG_NO_DLY << 5 ) | ( LIB_CFG_UPD_SIZE << 4 ) | ( LIB_CFG_FILE_IO << 2 ) | LIB_CFG_DISK_IO )	/* CH375ֵ */

#ifndef DISK_BASE_BUF_ADDR
/*#define DISK_BASE_BUF_ADDR		0*/		/* δ̶дĻַ,ôٶ̶дĻӵַ0ʼ */
#endif

/* ӳṩı */
extern UINT8DV	CH375IntStatus;			/* CH375ж״̬ */
extern UINT8DV	CH375DiskStatus;		/* ̼ļ״̬ */
extern UINT8D	CH375LibConfig;			/* CH375,˵ */
/* λ7: CH375INT#ӷʽ: 0ѯʽ,1жϷʽ */
/* λ6: λΪ1CH375Version2Ϊ1оƬΪCH375B */
/* λ5: дǷʱ: 0дʱ,1ʱ */
/* λ4: ݺǷԶļ: 0,1Զ */
/* λ3λ2: ļдĶݵĸƷʽ: 00DPTR, 01DPTR, 10˫DPTR, 11DPTRP2+R0 */
/* λ1λ0: Դ̶дĵݵĸƷʽ: 00DPTR, 01DPTR, 10˫DPTR, 11DPTRP2+R0 */

/* CH375INT#ӵƬжŲ׼ʹжϷʽ,ôLIB_CFG_INT_ENΪ1,Ϊ0ɵƬѯINT# */
/* MCS51ƬⲿRAMеʱȽ,CH375ĳṩŻٶȵķʽ,LIB_CFG_FILE_IOLIB_CFG_DISK_IOж:
   ʽ0:
   ʽ1:"DPTR", ݸƷʽ, ʹһDPTRл, ÿһֽҪ16, ٶ, MCS51Ƭ,
   ʽ2:"˫DPTR", ضӲݸƷʽ, ʹDPTR, ÿһֽҪ8.5, ٶȽϿ, ATMEL/PHILIPS/SSTȾ˫DPTRĵƬ,
   ʽ3:"DPTRP2+R0", P2+R0ָCH375I/O˿ڲDPTRָⲿRAMݸ, ÿһֽҪ6.25, ٶ,
                       б׼MCS51Ƭ, ĳЩƬõⲿRAMʱرP2+R0Ĺ, Կܲ,
   ļݶд,ҲӦóCH375FileReadXCH375FileWriteXӳʱ:
     ڷʽ1,2,3,ӦóÿεCH375FileReadXCH375FileWriteXʱ,CH375ĳⶼָʼַʼд,
     : ĳļΪ1K(ռ2), CH375FileReadXʱ1K(ָmCmdParam.Read.mSectorCountΪ2), ô1Kȫָ,
           Сֻ0.5K, ôζȡ, һεCH375FileReadXʱ0.5K, 0.5KݺٵCH375FileReadXһ0.5K
*/
extern UINT8D	CH375vDiskFat;			/* ߼̵FAT־:1=FAT12,2=FAT16,3=FAT32 */
extern UINT8D	CH375vSecPerClus;		/* ߼̵ÿ */
extern UINT32D	CH375vStartCluster;		/* ǰļĿ¼ʼغ */
extern UINT32D	CH375vFileSize;			/* ǰļĳ */
extern UINT32D	CH375vCurrentOffset;	/* ǰļָ,ǰдλõֽƫ */

/* FATļĿ¼Ϣ */
typedef struct _FAT_DIR_INFO {
	UINT8	DIR_Name[11];				/* 00H,ļ,11ֽ,㴦ո */
	UINT8	DIR_Attr;					/* 0BH,ļ,οǰ˵ */
	UINT8	DIR_NTRes;					/* 0CH */
	UINT8	DIR_CrtTimeTenth;			/* 0DH,ļʱ,0.1뵥λ */
	UINT16	DIR_CrtTime;				/* 0EH,ļʱ */
	UINT16	DIR_CrtDate;				/* 10H,ļ */
	UINT16	DIR_LstAccDate;				/* 12H,һδȡ */
	UINT16	DIR_FstClusHI;				/* 14H */
	UINT16	DIR_WrtTime;				/* 16H,ļ޸ʱ,οǰĺMAKE_FILE_TIME */
	UINT16	DIR_WrtDate;				/* 18H,ļ޸,οǰĺMAKE_FILE_DATA */
	UINT16	DIR_FstClusLO;				/* 1AH */
	UINT32	DIR_FileSize;				/* 1CH,ļ */
} FAT_DIR_INFO;							/* 20H */
typedef FAT_DIR_INFO xdata *P_FAT_DIR_INFO;

extern BOOL1	CH375Version2;			/* оƬ汾:0-CH375,1-CH375A/B */
extern UINT32X	CH375vDataStart;		/* ߼̵ʼLBA */
extern UINT32D	CH375vFdtLba;			/* ǰFDTڵLBAַ */
extern UINT16D	CH375vFdtOffset;		/* ǰFDTڵƫƵַ */
extern UINT32X	CH375vDiskRoot;			/* FAT16ΪĿ¼ռ,FAT32ΪĿ¼ʼغ */
#ifdef EN_SEC_SIZE_AUTO
extern UINT16X	CH375vSectorSize;		/* ̵С */
#else
#define	CH375vSectorSize	512			/* ̵С */
#endif
extern PUINT8X	data	pDISK_BASE_BUF;		/* ָⲿRAMĴݻ,ȲСCH375vSectorSize,Ӧóʼ */

extern UINT8	CH375ReadBlock( void );		/* Ӵ̶ȡݵⲿӿڽ */
#ifdef EN_DISK_WRITE
extern UINT8	CH375WriteBlock( void );	/* ⲿӿڽĶݿд */
#endif

/* ӳṩӳ */
/* ӳ, ļӳCH375File*ʹ̲ѯӳCH375DiskQueryܻõݻpDISK_BASE_BUF,
   пpDISK_BASE_BUFб˴Ϣ, Ա뱣֤pDISK_BASE_BUF;,
   RAM, ҪpDISK_BASE_BUFʱ;, ôʱCH375DirtyBuffer̻ */
extern UINT8	CH375GetVer( void );		/* ȡǰӳİ汾 */
extern void		CH375Reset( void );			/* λCH375 */
extern UINT8	CH375Init( void );			/* ʼCH375 */
extern UINT8	CH375DiskConnect( void );	/* Ƿ */
extern UINT8	CH375DiskReady( void );		/* ѯǷ׼ */
extern void		CH375DirtyBuffer( void );	/* ̻ */
extern UINT8	CH375FileOpen( void );		/* ļöļ */
extern UINT8	CH375FileClose( void );		/* رյǰļ */
#ifdef EN_DISK_WRITE
extern UINT8	CH375FileErase( void );		/* ɾļر */
extern UINT8	CH375FileCreate( void );	/* ½ļ,ļѾɾ½ */
#endif
extern UINT8	CH375FileModify( void );	/* ѯ޸ĵǰļϢ */
extern UINT8	CH375FileLocate( void );	/* ƶǰļָ */
extern UINT8	CH375FileReadX( void );		/* ӵǰļȡݵָ */
#ifdef EN_DISK_WRITE
extern UINT8	CH375FileWriteX( void );	/* ǰļдָ */
#endif
#ifdef EN_BYTE_ACCESS
extern UINT8	CH375ByteLocate( void );	/* ֽΪλƶǰļָ */
extern UINT8	CH375ByteRead( void );		/* ֽΪλӵǰλöȡݿ */
#ifdef EN_DISK_WRITE
extern UINT8	CH375ByteWrite( void );		/* ֽΪλǰλдݿ */
#endif
#endif
extern UINT8	CH375DiskSize( void );		/* ѯ */
extern UINT8	CH375DiskQuery( void );		/* ѯϢ */
#ifdef EN_SAVE_VARIABLE
extern void		CH375SaveVariable( void );	/* //ָӳı,ӳڶCH375оƬ֮л */
#endif
extern UINT8	CH375BulkOnlyCmd( void );	/* ִлBulkOnlyЭ */
extern UINT8	CH375sDiskReady( void );	/* ѯǷ׼,֧CH375S */

/* ͷļΪCH375ӳҪI/OڴԴ,ҪӲйصĿ,
   ļǱĿĶԴΪͷļ,ôӦֻһͷļԴͲ,
   ֮ͷļӦñȶCH375HF_NO_CODE,ӶֹͷļظĿ,:
#define		CH375HF_NO_CODE		1
#include	CH375HF?.H
*/
#ifdef CH375HF_NO_CODE

extern CMD_PARAM_I mCmdParam;				/*  */
extern UINT8XV CH375_CMD_PORT;				/* CH375˿ڵI/Oַ */
extern UINT8XV CH375_DAT_PORT;				/* CH375ݶ˿ڵI/Oַ */
#if DISK_BASE_BUF_LEN
extern UINT8X  DISK_BASE_BUF[ DISK_BASE_BUF_LEN ];	/* ⲿRAMĴݻ,Ϊһĳ */
#endif
#ifdef FILE_DATA_BUF_LEN
extern UINT8X  FILE_DATA_BUF[ FILE_DATA_BUF_LEN ];	/* ⲿRAMļݻ,ȲСһζдݳ */
extern UINT8	CH375FileRead( void );		/* ӵǰļȡ */
#ifdef EN_DISK_WRITE
extern UINT8	CH375FileWrite( void );		/* ǰļд */
#endif
#endif
#ifndef NO_DEFAULT_CH375_F_ENUM
extern UINT8	CH375FileEnumer( void );	/* öļ */
#endif
#ifndef NO_DEFAULT_CH375_F_QUERY
extern UINT8	CH375FileQuery( void );		/* ѯǰļϢ */
#endif
extern void xQueryInterrupt( void );		/* ⲿıCH375õӳ,ѯCH375жϲж״̬ */
extern void xDelay100uS( void );			/* ⲿıCH375õӳ,ʱ100uS */
#ifdef EN_DISK_WRITE
extern void xDelayAfterWrite( void );		/* ⲿıCH375õӳ,дʱ */
#endif
extern void xFileNameEnumer( void );		/* ⲿıCH375õӳ,ļöٻصӳ */
extern UINT8 CH375LibInit( void );			/* ʼCH375CH375оƬ,ɹ0 */

#else

CMD_PARAM_I mCmdParam;					/*  */

UINT8XV CH375_CMD_PORT _at_ CH375_CMD_PORT_ADDR;	/* CH375˿ڵI/Oַ */
UINT8XV CH375_DAT_PORT _at_ CH375_DAT_PORT_ADDR;	/* CH375ݶ˿ڵI/Oַ */
#if DISK_BASE_BUF_LEN
#ifdef DISK_BASE_BUF_ADDR
UINT8X  DISK_BASE_BUF[ DISK_BASE_BUF_LEN ] _at_ DISK_BASE_BUF_ADDR;	/* ⲿRAMĴݻ,Ϊһĳ */
#else
UINT8X  DISK_BASE_BUF[ DISK_BASE_BUF_LEN ];	/* ⲿRAMĴݻ,Ϊһĳ */
#endif
#endif
#ifdef FILE_DATA_BUF_LEN
#ifdef FILE_DATA_BUF_ADDR
UINT8X  FILE_DATA_BUF[ FILE_DATA_BUF_LEN ] _at_ FILE_DATA_BUF_ADDR;	/* ⲿRAMļݻ,ȲСһζдݳ */
#else
UINT8X  FILE_DATA_BUF[ FILE_DATA_BUF_LEN ];	/* ⲿRAMļݻ,ȲСһζдݳ */
#endif
UINT8	CH375FileRead( void )		/* ӵǰļȡ */
{
	mCmdParam.ReadX.mDataBuffer = &FILE_DATA_BUF[0];  /* ָļݻ */
	return( CH375FileReadX( ) );
}
#ifdef EN_DISK_WRITE
UINT8	CH375FileWrite( void )		/* ǰļд */
{
	mCmdParam.WriteX.mDataBuffer = &FILE_DATA_BUF[0];  /* ָļݻ */
	return( CH375FileWriteX( ) );
}
#endif
#endif

/* ³ԸҪ޸ */

#ifndef NO_DEFAULT_CH375_F_ENUM			/* ӦóжNO_DEFAULT_CH375_F_ENUMԽֹĬϵöļ,Ȼбдĳ */
UINT8	CH375FileEnumer( void )			/* öļ */
{
	UINT8	status;
	status = CH375FileOpen( );
	if ( status == ERR_FOUND_NAME ) status = ERR_SUCCESS;  /* ɹ */
	return( status );
}
#endif

#ifndef NO_DEFAULT_CH375_F_QUERY		/* ӦóжNO_DEFAULT_CH375_F_QUERYԽֹĬϵĲѯǰļϢ,Ȼбдĳ */
UINT8	CH375FileQuery( void )			/* ѯǰļϢ */
{
	PUINT8I	buf;
	UINT8	count;
	buf = (PUINT8I)( & mCmdParam.Modify.mFileSize );
	for ( count = sizeof( mCmdParam.Modify ); count != 0; count -- ) {
		*buf = 0xFF;  /* ȫЧ,ѯ޸ */
		buf ++;
	}
	return( CH375FileModify( ) );
}
#endif

#ifndef NO_DEFAULT_CH375_INT			/* ӦóжNO_DEFAULT_CH375_INTԽֹĬϵжϴ,Ȼбдĳ */
#if LIB_CFG_INT_EN == 0					/* CH375INT#ӷʽΪ"ѯʽ" */
void xQueryInterrupt( void )			/* ѯCH375жϲж״̬ */
{
#ifdef CH375_INT_WIRE  /* ѯж */
	while ( CH375_INT_WIRE );  /* CH375жߵƽȴ */
#else  /* CH375BоƬԲѯ˿ڵλ7 */
	while ( CH375_CMD_PORT & 0x80 );  /* ѯCH375B˿ڵλ7Ϊ1˵жߵƽȴ */
#endif
	CH375_CMD_PORT = CMD_GET_STATUS;  /* ȡǰж״̬ */
	CH375IntStatus &= 0x80; if ( CH375IntStatus ) CH375IntStatus = 0;  /* ,ʱ2uS */
	CH375IntStatus = CH375_DAT_PORT;  /* ȡж״̬ */
	if ( CH375IntStatus == USB_INT_DISCONNECT ) CH375DiskStatus = DISK_DISCONNECT;  /* ⵽USB豸Ͽ¼ */
	else if ( CH375IntStatus == USB_INT_CONNECT ) CH375DiskStatus = DISK_CONNECT;  /* ⵽USB豸¼ */
}
#else									/* LIB_CFG_INT_EN != 0, CH375INT#ӷʽΪ"жϷʽ" */
void xQueryInterrupt( void )			/* ѯж״̬,ȴӲж */
{
	while ( CH375IntStatus == 0 );		/* ӳøӳ֮ǰCH375IntStatus=0,ӲжϺ,жϷΪ0ʵж״̬󷵻 */
}
void	CH375Interrupt( void ) interrupt CH375_INT_NO using 1	/* CH375жϷ,ʹüĴ1,CH375INT#ĵ͵ƽ½شƬж */
{
	CH375_CMD_PORT = CMD_GET_STATUS;  /* ȡж״̬ȡж */
	CH375IntStatus &= 0x80; if ( CH375IntStatus ) CH375IntStatus = 0;  /* ,ʱ2uS */
	CH375IntStatus = CH375_DAT_PORT;  /* ȡж״̬ */
	if ( CH375IntStatus == USB_INT_DISCONNECT ) CH375DiskStatus = DISK_DISCONNECT;  /* ⵽USB豸Ͽ¼ */
	else if ( CH375IntStatus == USB_INT_CONNECT ) CH375DiskStatus = DISK_CONNECT;  /* ⵽USB豸¼ */
#ifdef CLEAR_INT_MARK
	CLEAR_INT_MARK( );  /* ĳЩƬҪжϱ־ */
#endif
}
#endif
#endif

#ifndef NO_DEFAULT_DELAY_100US			/* ӦóжNO_DEFAULT_DELAY_100USԽֹĬϵʱ100uSӳ,Ȼбдĳ */
void xDelay100uS( void )				/* ʱ100uS */
{
	UINT8	count;
	for ( count = 150; count != 0; count -- );  /* ʱ100uS,2x333nS@36MHz&12T */
}
#endif

#ifdef EN_DISK_WRITE
#ifndef NO_DEFAULT_DELAY_WRITE			/* ӦóжNO_DEFAULT_DELAY_WRITEԽֹĬϵдʱ,Ȼбдĳ */
void xDelayAfterWrite( void )			/* дʱ */
{
	UINT8	count;
	for ( count = 250; count != 0; count -- );  /* ʱ200uS */
}
#endif
#endif

#ifndef NO_DEFAULT_FILE_ENUMER			/* ӦóжNO_DEFAULT_FILE_ENUMERԽֹĬϵļöٻص,Ȼбдĳ */
void xFileNameEnumer( void )			/* ļöٻصӳ */
{
/* ָöCH375vFileSizeΪ0xFFFFFFFFFileOpenôÿһļFileOpenñص
   صxFileNameEnumerغFileOpenݼCH375vFileSizeöֱļĿ¼ǣ
   ڵFileOpen֮ǰһȫֱΪ0FileOpenص󣬱CH375vFdtOffsetõṹFAT_DIR_INFO
   ṹеDIR_AttrԼDIR_NameжǷΪļĿ¼¼Ϣȫֱ
   FileOpenغжϷֵERR_MISS_FILEERR_FOUND_NAMEΪɹȫֱΪЧļ
   ڱصxFileNameEnumerнCH375vFileSizeΪ1ô֪ͨFileOpenǰǻص */
#if 0
#ifdef FILE_DATA_BUF_LEN
	UINT8			i;
	UINT16			FileCount;
	P_FAT_DIR_INFO	pFileDir;
	PUINT8X			NameBuf;
	pFileDir = (P_FAT_DIR_INFO)( pDISK_BASE_BUF + CH375vFdtOffset );  /* ǰFDTʼַ */
	FileCount = (UINT16)( 0xFFFFFFFF - CH375vFileSize );  /* ǰļö,CH375vFileSizeֵ0xFFFFFFFF,ҵļݼ */
	if ( FileCount < FILE_DATA_BUF_LEN / 12 ) {  /* 黺Ƿ㹻,ٶÿļռ12ֽڴ */
		NameBuf = & FILE_DATA_BUF[ FileCount * 12 ];  /* 㱣浱ǰļĻַ */
		for ( i = 0; i < 11; i ++ ) NameBuf[ i ] = pFileDir -> DIR_Name[ i ];  /* ļ,Ϊ11ַ,δո */
		if ( pFileDir -> DIR_Attr & ATTR_DIRECTORY ) NameBuf[ i ] = 1;  /* жĿ¼ */
		NameBuf[ i ] = 0;  /* ļ */
	}
#endif
#endif
}
#endif

#ifdef EXT_BLK_INTERFACE
#if LIB_CFG_FILE_IO == 0				/* ļдݵĸƷʽΪ"ⲿӳ" */
#ifdef LIB_CFG_FILE_IO_DEFAULT			/* ӦóжֵʹĬ"ⲿӳ",Ӧбд */
unsigned char xdata *current_buffer;	/* ļݶдʱĻĵǰָ,ӦóڵCH375FileReadXCH375FileWriteXӳǰóֵ */
void xWriteToExtBuf( UINT8 mLength )	/* ӳCH375ӳ,ڴCH375ȡļݵⲿ,CH375FileReadX */
{
/*	if ( (UINT16)current_buffer + mLength >= (UINT16)&FILE_DATA_BUF + sizeof( FILE_DATA_BUF ) ) return;*/  /* ֹ */
	if ( mLength ) {
		do {  /* ݳȶȡ,ʵϳCH375_MAX_DATA_LEN,Ҳ64 */
			*current_buffer = CH375_DAT_PORT;  /* ݲ,ַʽļݱ浽Ƭĸִд洢 */
			current_buffer ++;
		} while ( -- mLength );
	}  /* ݵʱ䲻ó2mS */
	else {  /* ,ַָ,ļݶдĻĵǰָmCmdParam.ReadX.mDataBufferᱻԶָ,г */
		current_buffer += (UINT16)mCmdParam.ReadX.mDataBuffer;  /* mDataBufferΪֵ */
		mCmdParam.ReadX.mDataBuffer = 0;  /* Ϊ֧,ڵCH375FileReadX֮ǰҲӦ0 */
	}
}
#ifdef EN_DISK_WRITE
void xReadFromExtBuf( UINT8 mLength )	/* ӳCH375ӳ,ڴⲿȡļݵCH375,CH375FileWriteX */
{
	if ( mLength ) {
		do {  /* ݳд,ʵϳCH375_MAX_DATA_LEN,Ҳ64 */
			CH375_DAT_PORT = *current_buffer;  /* д,ַʽӵƬĸִд洢ȡļ */
			current_buffer ++;
		} while ( -- mLength );
	}  /* ݵʱ䲻ó2mS */
	else {  /* ,ַָ,ļݶдĻĵǰָmCmdParam.WriteX.mDataBufferᱻԶָ,г */
		current_buffer += (UINT16)mCmdParam.WriteX.mDataBuffer;  /* mDataBufferΪֵ */
		mCmdParam.WriteX.mDataBuffer = 0;  /* Ϊ֧,ڵCH375FileWriteX֮ǰҲӦ0 */
	}
}
#endif
#endif
#else									/* LIB_CFG_FILE_IO != 0,ļдݵĸƷʽ"ⲿӳ" */
#ifdef FILE_DATA_BUF_LEN
void xWriteToExtBuf( UINT8 mLength )	/* øӳ */
{
	mLength --;  /* ò,ֻǱ־Ϣ */
}
#ifdef EN_DISK_WRITE
void xReadFromExtBuf( UINT8 mLength )	/* øӳ */
{
	mLength --;  /* ò,ֻǱ־Ϣ */
}
#endif
#endif
#endif
#endif

UINT8	CH375LibInit( void )  /* ʼCH375CH375оƬ,ɹ0 */
{
	if ( SP > 0xF0 ) return( 0xFC );  /* ƬĶջռ䲻,CH375ӳ7ӳ,ѯʽҪ14ֽڵĶջռ,ṩ */
	CH375LibConfig = LIB_CFG_VALUE;  /* CH375ֵ */
	if ( CH375GetVer( ) < CH375_LIB_VER ) return( 0xFF );  /* ȡǰӳİ汾,汾̫򷵻ش */
#if DISK_BASE_BUF_LEN
	pDISK_BASE_BUF = & DISK_BASE_BUF[0];  /* ָⲿRAMĴݻ */
#endif
	return( CH375Init( ) );  /* ʼCH375 */
}

#endif

#ifdef __cplusplus
}
#endif

#endif
