/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2007   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* Uļдģ, ӷʽ: +ж */
/* MCS-51ƬCʾ, V3.0Aϰ汾ģ */
/* ΪʹUļдģʹUļӳ,ռýٵĵƬԴ,ʹ89C51Ƭ */

#include <reg51.h>
#include <absacc.h>
#include <string.h>
#include <stdio.h>

#define MAX_PATH_LEN			32		/* ·,бָܷСԼ·00H,CH375ģֵֵ֧64,Сֵ13 */
#include "..\CH375HM.H"

/* ·ӷʽ
   Ƭ    ģ
    P0    =  D0-D7
    RD    =  RD#
    WR    =  WR#
    ?     =  CS#   ûⲿRAM,ôCS#=P26,г16KBⲿRAM,ôCS#=P27 & ! P26 & ...,CS#ƬѡַΪBXXXH
    P20   =  A0
    INT0  =  INT#
*/
#define CH375HM_INDEX	XBYTE[0xBCF0]	/* CH375ģ˿ڵI/Oַ */
#define CH375HM_DATA	XBYTE[0xBDF1]	/* CH375ģݶ˿ڵI/Oַ */
#define CH375HM_INT_NO			0		/* CH375жϺ */
#define CH375HM_INT_WIRE		INT0	/* ٶCH375ģINT#ӵƬINT0 */
#define CH375HM_INT_EN			EX0		/* ƬINT0ŵжʹ */
#define CH375HM_INT_FLAG		IE0		/* ƬINT0ŵжϱ־ */

/* ٶļݻ: ExtRAM: 0000H-7FFFH */
unsigned char xdata DATA_BUF[ 512 * 64 ] _at_ 0x0000;	/* ⲿRAMļݻ,ӸõԪʼĻȲСһζдݳ,Ϊ512ֽ */

unsigned char xdata *buffer;			/* ݻָ,ڶдݿ */

CMD_PARAM		mCmdParam;				/* Ĭ¸ýṹռ64ֽڵRAM,޸MAX_PATH_LEN,޸Ϊ32ʱ,ֻռ32ֽڵRAM */
unsigned char	mIntStatus;				/* CH375ģж״̬߲״̬ */

sbit	LED_OUT		=	P1^4;			/* P1.4 ͵ƽLEDʾ,ڼʾĽ */

/* ģĲڶдʱڶдʽ,޸3ӳ */
#define CH375HM_INDEX_WR( Index )	{ CH375HM_INDEX = (Index); }	/* дַ */
#define CH375HM_DATA_WR( Data )		{ CH375HM_DATA = (Data); }		/* д */
#define CH375HM_DATA_RD( )			( CH375HM_DATA )				/*  */


/* CH375ģжϷ,ʹüĴ1 */
void	CH375HMInterrupt( ) interrupt CH375HM_INT_NO using 1
{
	unsigned char	status, i;
	CH375HM_INDEX_WR( PARA_STATUS_ADDR );  /* дַ */
	status = CH375HM_DATA_RD( );  /* ַPARA_STATUS_ADDRȡж״̬ */
	CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
	CH375HM_DATA_WR( PARA_CMD_BIT_INACT );  /* жӦ,ȡģж */
	if ( status == USB_INT_DISK_READ ) {  /* ڴU̶ݿ,ݶ */
		CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
		i = 64;  /*  */
		do {  /* Ҫļݶдٶ,γûЧʸ,C51,do+whileforwhileṹЧʸ */
			*buffer = CH375HM_DATA_RD( );  /* ַ063ζ64ֽڵ */
			buffer ++;  /* ȡݱ浽ⲿ */
		} while ( -- i );  /* һСCûЧҪ߽һ */
		CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
		CH375HM_DATA_WR( PARA_CMD_BIT_ACT );  /* ֪ͨģ,˵64ֽѾȡ */
	}
	else if ( status == USB_INT_DISK_WRITE ) {  /* Uдݿ,д */
		CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
		i = 64;  /*  */
		do {
			CH375HM_DATA_WR( *buffer );  /* ַ063д64ֽڵ */
			buffer ++;  /* дⲿ */
		} while ( -- i );
		CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
		CH375HM_DATA_WR( PARA_CMD_BIT_ACT );  /* ֪ͨģ,˵64ֽѾд */
	}
	else if ( status == USB_INT_DISK_RETRY ) {  /* дݿʧ,Ӧ޸Ļָ */
		CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
		i = CH375HM_DATA_RD( );  /* ģʽΪظָֽĸ8λ,Сģʽôյǻظָֽĵ8λ */
		status = CH375HM_DATA_RD( );  /* ģʽΪظָֽĵ8λ,Сģʽôյǻظָֽĸ8λ */
		buffer -= ( (unsigned short)i << 8 ) + status;  /* ǴģʽµĻظָ,Сģʽ,Ӧ( (unsigned short)status << 8 ) + i */
		CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
		CH375HM_DATA_WR( PARA_CMD_BIT_ACT );  /* ֪ͨģ,˵״̬Ѿ */
	}
	else {
		mIntStatus = status;  /* ¼֪ͨ״̬߲״̬,ж״̬ */
/*		while( CH375HM_INT_WIRE == 0 );  ǵƽʽж,ôӦõȴжЧ,ģӦյжӦ3uSж */
	}
/*	CH375HM_INT_FLAG = 0;  жϱ־ */
}

/* ʱ100,ȷ */
void	mDelay100mS( )
{
	unsigned char	i, j, c;
	for ( i = 200; i != 0; i -- ) for ( j = 200; j != 0; j -- ) c+=3;
}

/* ִ */
unsigned char	ExecCommand( unsigned char cmd, unsigned char len )
/* ,ز״̬,ͷزCMD_PARAMṹ */
{
	unsigned char		i, status;
	unsigned char data	*buf;
	CH375HM_INT_EN = 0;  /* رж,ֹжӦ޸ģַ,ǲѯж򲻱عرж */
	CH375HM_INDEX_WR( PARA_COMMAND_ADDR );
	CH375HM_DATA_WR( cmd );  /* ַPARA_COMMAND_ADDRд */
	if ( len ) {  /* в */
		i = len;
		CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
		buf = (unsigned char *)&mCmdParam;  /* ָʼַ */
		do {
			CH375HM_DATA_WR( *buf );  /* ַPARA_BUFFER_ADDRʼ,д */
			buf ++;
		} while ( -- i );
	}
	mIntStatus = 0xFF;  /* ж״̬ */
	CH375HM_INT_EN = 1;
	CH375HM_INDEX_WR( PARA_CMD_LEN_ADDR );
	CH375HM_DATA_WR( len | PARA_CMD_BIT_ACT );  /* ַPARA_CMD_LEN_ADDRдĳ,λ֪ͨģ,˵Ѿд,ʼִ */
	while ( mIntStatus == 0xFF );  /* ȴģɲز״̬ */
ExecCommandStatus:
	status = mIntStatus;
	if ( status == ERR_SUCCESS ) {  /* ɹ */
		CH375HM_INT_EN = 0;  /* رж,ֹжӦ޸ģַ,ǲѯж򲻱عرж */
		CH375HM_INDEX_WR( PARA_STS_LEN_ADDR );
		i = CH375HM_DATA_RD( );  /* ַPARA_STS_LEN_ADDRȡؽݵĳ */
		if ( i ) {  /* н */
			CH375HM_INDEX_WR( PARA_BUFFER_ADDR );  /* ָ򻺳 */
			buf = (unsigned char *)&mCmdParam;  /* ָʼַ */
			do {
				*buf = CH375HM_DATA_RD( );  /* ַPARA_BUFFER_ADDRʼ,ȡ */
				buf ++;
			} while ( -- i );
		}
//		status = ERR_SUCCESS;
		CH375HM_INT_EN = 1;
	}
	else {  /* ʧ */
		if ( status == ERR_DISK_DISCON || status == ERR_USB_CONNECT ) {  /* U̸ոӻ߶Ͽ,Ӧʱʮٲ */
			mDelay100mS( );
			if ( mIntStatus != status ) goto ExecCommandStatus;  /* Ȼж˵֮ǰжU̲֪ͨж */
		}
	}
	return( status );
}

/* ״̬,ʾ벢ͣ,Ӧ滻ΪʵʵĴʩ */
void	mStopIfError( unsigned char iError )
{
	unsigned char	led;
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (unsigned short)iError );  /* ʾ */
	led=0;
	while ( 1 ) {
		LED_OUT = led&1;  /* LED˸ */
		mDelay100mS( );
		led^=1;
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	unsigned char	i, c, SecCount;
	unsigned long	OldSize;
	unsigned short	NewSize, count;
	LED_OUT = 0;  /* LEDһʾ */
	mDelay100mS( );  /* ʱ100,CH375ģϵҪ100ҵĸλʱ */
	mDelay100mS( );
	mDelay100mS( );
	mDelay100mS( );
	LED_OUT = 1;
	mInitSTDIO( );
	printf( "Start\n" );

/* ٶCH375ģINT#ӵƬINT0 */
	IT0 = 1;  /* CH375ģжźΪ½ش,ʵ,ƽʽҲ */
	CH375HM_INT_FLAG = 0;  /* жϱ־ */
	CH375HM_INT_EN = 1;  /* CH375ģж */
/* ·ʼ */
	EA = 1;  /* ʼ,ж */
	mCmdParam.Setup.mSetup = 0x01;  /* : ģֵ,λ0Ϊ1ʱѯU״̬Զж֪ͨ */
	i = ExecCommand( CMD_SetupModule, 1 );  /* ģ */
	mStopIfError( i );
	while ( 1 ) {  /* ѭ */
		printf( "Wait Udisk\n" );
		while ( mIntStatus != ERR_USB_CONNECT );  /* ȴU,жϷ״̬ */
		mDelay100mS( );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
		mDelay100mS( );
		ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬,ʵڳģж */
		if ( mCmdParam.Status.mDiskStatus != DISK_CONNECT ) continue;  /* ʱ,USB˿ڽӴ߲βɴ,U̸ֶϿ */
		LED_OUT = 0;  /* LED */
/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 5; i ++ ) {
			mDelay100mS( );
			printf( "Ready ?\n" );
			if ( ExecCommand( CMD_DiskReady, 0 ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
/* ȡԭļ */
		printf( "Open\n" );
		memcpy( mCmdParam.Open.mPathName, "\\C51\\CH375HFT.C", MAX_PATH_LEN );  /* ļ,ļC51Ŀ¼ */
		i = ExecCommand( CMD_FileOpen, MAX_PATH_LEN );  /* ļ,Ϊֵ,ʡټ */
		if ( i == ERR_MISS_DIR || i == ERR_MISS_FILE ) {  /* ERR_MISS_DIR˵ûҵC51Ŀ¼,ERR_MISS_FILE˵ûҵļ */
/* гĿ¼µļ */
			printf( "List file \\*\n" );
			for ( c = 0; c < 255; c ++ ) {  /* ǰ255ļ */
/*				memcpy( mCmdParam.Enumer.mPathName, "\\C51\\CH375*", MAX_PATH_LEN );*/  /* C51Ŀ¼CH375ͷļ,*Ϊͨ */
				memcpy( mCmdParam.Enumer.mPathName, "\\*", MAX_PATH_LEN );  /* ļ,*Ϊͨ,ļĿ¼ */
/*				i = strlen( mCmdParam.Enumer.mPathName );*/  /* ļĳ */
				for ( i = 0; i < MAX_PATH_LEN - 1; i ++ ) if ( mCmdParam.Enumer.mPathName[ i ] == 0 ) break;  /* ָļĽ */
				mCmdParam.Enumer.mPathName[ i ] = c;  /* 滻Ϊ,0255 */
				i = ExecCommand( CMD_FileEnumer, i+1 );  /* öļ,ļкͨ*,Ϊļ,ĳȺܺü */
				if ( i == ERR_MISS_FILE ) break;  /* Ҳƥļ,Ѿûƥļ */
				if ( i == ERR_SUCCESS || i == ERR_FOUND_NAME ) {  /* ͨƥļ,ļ· */
					printf( "  match file %03d#: %s\n", (unsigned int)c, mCmdParam.Enumer.mPathName );  /* ʾźƥļĿ¼ */
					continue;  /* һƥļ,´ʱŻ1 */
				}
				else {  /*  */
					mStopIfError( i );
					break;
				}
			}
			strcpy( DATA_BUF, "Note: \nԭǴ㽫/C51/CH375HFT.CļеСдĸתɴддµļ,Ҳļ\n" );
			OldSize = 0;
			NewSize = strlen( DATA_BUF );  /* ļĳ */
			SecCount = ( NewSize + 511 ) >> 9;  /* (NewSize+511)/512, ļ,ΪдΪλ */
		}
		else {  /* ҵļ\C51\CH375HFT.C߳ */
			mStopIfError( i );
			printf( "Query\n" );
			i = ExecCommand( CMD_FileQuery, 0 );  /* ѯǰļϢ,û */
			mStopIfError( i );
			printf( "Read\n" );
			OldSize = mCmdParam.Modify.mFileSize;  /* ԭļĳ */
			if ( OldSize > (unsigned long)(64*512) ) {  /* ʾõ62256ֻ32Kֽ */
				SecCount = 64;  /* ʾõ62256ֻ32Kֽ,ֻȡ64,Ҳǲ32768ֽ */
				NewSize = 64*512;  /* RAMƳ */
			}
			else {  /* ԭļС,ôʹԭ */
				SecCount = ( OldSize + 511 ) >> 9;  /* (OldSize+511)/512, ļ,ΪдΪλ */
				NewSize = (unsigned short)OldSize;  /* ԭ */
			}
			printf( "Size=%ld, Len=%d, Sec=%d\n", OldSize, NewSize, (unsigned short)SecCount );
			mCmdParam.Read.mSectorCount = SecCount;  /* ȡȫ,60ֻȡ60 */
			buffer = & DATA_BUF;  /* ݵĻʼַ,CH375ģжϷ */
			i = ExecCommand( CMD_FileRead, 1 );  /* ļȡ */
			mStopIfError( i );
/*
			ļȽϴ,һζ,CMD_FileReadȡ,ļָԶƶ
			while ( ʣδ ) {
				mCmdParam.Read.mSectorCount = 32;
				ExecCommand( CMD_FileRead, 1 );   ļָԶ
				TotalLength += 32*512;  ۼļܳ
			}

		    ϣָλÿʼд,ƶļָ
			mCmdParam.Locate.mSectorOffset = 3;  ļǰ3ʼд
			i = ExecCommand( CMD_FileLocate, 4 );  ĳ4sizeof( mCmdParam.Locate.mSectorOffset )
			mCmdParam.Read.mSectorCount = 10;
			ExecCommand( CMD_FileRead, 1 );   ֱӶȡļĵ(512*3)ֽڿʼ,ǰ3

			ϣӵԭļβ,ƶļָ
			i = ExecCommand( CMD_FileOpen, (unsigned char)( strlen( mCmdParam.Open.mPathName ) + 1 ) );
			mCmdParam.Locate.mSectorOffset = 0xffffffff;  Ƶļβ,Ϊλ,ԭļ3ֽ,512ֽڿʼ
			i = ExecCommand( CMD_FileLocate, sizeof( mCmdParam.Locate.mSectorOffset ) );
			mCmdParam.Write.mSectorCount = 10;
			ExecCommand( CMD_FileWrite, 1 );   ԭļĺ
*/
			printf( "Close\n" );
			mCmdParam.Close.mUpdateLen = 0;
			i = ExecCommand( CMD_FileClose, 1 );  /* رļ */
			mStopIfError( i );

			i = DATA_BUF[200];
			DATA_BUF[200] = 0;  /* ַ־,ʾ200ַ */
			printf( "Line 1: %s\n", DATA_BUF );
			DATA_BUF[200] = i;  /* ָԭַ */
			for ( count=0; count < NewSize; count ++ ) {  /* ļеСдַתΪд */
				c = DATA_BUF[ count ];
				if ( c >= 'a' && c <= 'z' ) DATA_BUF[ count ] = c - ( 'a' - 'A' );
			}
		}
/* ļ */
		printf( "Create\n" );
/*		memcpy( mCmdParam.Create.mPathName, "\\NEWFILE.TXT", MAX_PATH_LEN );*/
		memcpy( mCmdParam.Create.mPathName, "\\˫Ұ.TXT", MAX_PATH_LEN );  /* ļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileCreate, MAX_PATH_LEN );  /* ½ļ,ļѾɾ½ */
		mStopIfError( i );
		printf( "Write\n" );
		mCmdParam.Write.mSectorCount = 0x1;  /* дһ512ֽ */
		buffer = & DATA_BUF;  /* ݵĻʼַ,CH375ģжϷд */
		i = ExecCommand( CMD_FileWrite, 1 );  /* ļд */
		mStopIfError( i );
		if ( SecCount > 1 ) {  /* Ϊݲ255,ܹһд,Ϊʾ,д */
			mCmdParam.Write.mSectorCount = SecCount - 1;
/*	buffer = & DATA_BUF + 512;  Ÿղŵд,ûʼַ */
			i = ExecCommand( CMD_FileWrite, 1 );  /* ļд */
			mStopIfError( i );
		}
		printf( "Modify\n" );
		mCmdParam.Modify.mFileAttr = 0xff;  /* : µļ,Ϊ0FFH޸ */
		mCmdParam.Modify.mFileTime = 0xffff;  /* : µļʱ,Ϊ0FFFFH޸,ʹ½ļĬʱ */
		mCmdParam.Modify.mFileDate = ( (2004-1980)<<9 ) + ( 5<<5 ) + 18;  /* : µļ: 2004.05.18 */
		mCmdParam.Modify.mFileSize = NewSize;  /* : ԭļС,ôµļԭļһ,RAM */
		i = ExecCommand( CMD_FileModify, 4+2+2+1 );  /* ޸ĵǰļϢ,޸ںͳ,Ϊsizeof(mCmdParam.Modify.mFileSize)+... */
		mStopIfError( i );
		printf( "Close\n" );
		mCmdParam.Close.mUpdateLen = 0;  /* ҪԶļ,Զ,ôó512ı */
		i = ExecCommand( CMD_FileClose, 1 );
		mStopIfError( i );

/* ɾĳļ */
		printf( "Erase\n" );
		memcpy( mCmdParam.Create.mPathName, "\\OLD", MAX_PATH_LEN );  /* ɾļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileErase, MAX_PATH_LEN );  /* ɾļر */
/*		mStopIfError( i );*/

/* ѯϢ */
		printf( "Disk\n" );
		i = ExecCommand( CMD_DiskQuery, 0 );
		mStopIfError( i );
		i = mCmdParam.Query.mDiskFat;
		if ( i == 1 ) i = 12;
		else if ( i == 2 ) i = 16;
		else if ( i == 3 ) i = 32;
		printf( "FatCode=FAT%d, TotalSector=%ld, FreeSector=%ld\n", (unsigned short)i, mCmdParam.Query.mTotalSector, mCmdParam.Query.mFreeSector );
/* ȴU̶Ͽ */
		printf( "Take_out\n" );
		while ( mIntStatus != ERR_DISK_DISCON );  /* ȴU̶Ͽ,жϷ״̬ */
		ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬,ʵڳģж */
		LED_OUT = 1;  /* LED */
	}
}
