/**********************************************************************************************

   File               parse.c
   Date               January 18, 1990
   Description        C Command line parser support functions.

   Programmer         Robert J. Nendel
   Last update        January 22, 1990

***********************************************************************************************
               Copyright(c) 1989, 1990 Covox, Inc.  All rights reserved.
**********************************************************************************************/

#include <string.h>
#include <ctype.h>
#include "parse.h"
#include "cvxdefs.h"


unsigned short parseCount;
BYTE parseToken;
PARSE_INFO *parseInfo;




/**********************************************************************************************
set local variables to parser table
**********************************************************************************************/
VOID SetParse(token, count, info)
BYTE token;
unsigned short count;
PARSE_INFO *info;
{
   parseInfo = info;
   parseToken = token;
   parseCount = count;
}




/**********************************************************************************************
parse command line arguments and vector to application functions

   note that if an argument does not start with a token the first function
   in the info array is called.

   return 0 = ok
          1 = error
**********************************************************************************************/
unsigned short Parse(argc, argv)
unsigned short argc;
PSTR * argv;
{
   PSTR  xyz;

   short i, j;

   BYTE  ch;
   WORD  returnValue = 0;

   /* for each argument */
   for(i = 1; i < argc; i++)
   {
      /* set pointer to current argument */
      xyz = argv[i];

      /* does a token exist */
      if(tolower(*xyz) != tolower(parseToken))
      {
         /* call first function in info array */
         returnValue =  (*parseInfo[0].func)(xyz);
      }
      else
      {
         /* for each parse structure defined */
         for(j = 1; j < parseCount; j++)
         {
            /* determine if a match exists */
            if(tolower(parseInfo[j].key) == tolower(*(xyz + 1)))
            {
               /* if the remainder of the parameter string is null and a parameter */
               /* is required */
               if((strlen(xyz+2) == 0) && parseInfo[j].required)
               {
                  /* if an additional argument is available */
                  if(i < (argc - 1))
                  {
                     i++;

                     /* if the next argument contains a token */
                     if(tolower(*argv[i]) == tolower(parseToken))
                     {
                        /* error */
                        returnValue = 1;
                        break;
                     }

                     /* use next argument as parameter */
                     returnValue = (*parseInfo[j].func)(argv[i]);

                     break;
                  }
                  else
                  {
                     /* error */
                     returnValue = 1;

                     break;
                  }
               }
               else
               {
                  /* execute the associated function */
                  returnValue = (*parseInfo[j].func)(xyz + 2);

                   /* no need to scan the remainder parse structures */
                  break;
               }
            }
         }

         /* determine error condition */
         if( (j >= parseCount) || returnValue )
         {
            return(1);
         }
      }
   }

   return( returnValue );
}
