;;***************************************************************************
;;**                                                                       **
;;**                   Copyright 1988, 1992 Covox Inc.                     **
;;**                         All rights reserved.                          **
;;**                                                                       **
;;***************************************************************************

;;**  C_CALL

IFNDEF	TRUE
	TRUE	EQU	-1
ENDIF
FALSE	EQU	0

;;**  Notes:
;;**
;;**  References to an OFFSET parameter mean that the parameter may be a
;;**  constant, string address, WORD value (DW), or an ARRAY.
;;**  References to a SEGMENT parameter mean that it can be a constant, a
;;**  register, or a memory address containing the SEGMENT address.

;;***********************
;;**  Internal macros  **
;;***********************
;;** Macro to call "C" callable functions from assembler
;;** Uses:	c_call	function_name,<p1,p2,p3,...>
;;**
;;** Example:	c_call	add_xy,<rate,2>
;;**

c_call		MACRO   procedure_name,parameters
                .ERRB   <procedure_name>
c_parameters	EQU	<>			;; parameter list in C order
		IRP	x,<parameters>		;; reverse parameter list
			IFNB	<x>
c_parameters			CATSTR	<x>,<,>,c_parameters
			ELSE
				EXITM
			ENDIF
		ENDM

c_stack_size	=	0
	%	IRP	x,<c_parameters>
			IFNB	<x>
				IF ((.TYPE x) and 04h)	;; if constant
					mov	ax, x
					push	ax
				ELSE
					push x
				ENDIF
				c_stack_size = c_stack_size + 2;
			ENDIF
		ENDM
		call	procedure_name
		IF c_stack_size NE 0
			add	sp,c_stack_size
		ENDIF
		ENDM

