/****************************************************************************

  File                  : fmnotoff.c	
  Date                  : 3-18-91	
  Description           : Turn a voice on the YM3812 off
				

  Progammer(s)          : Don Fowler, Lance Williams	
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

/****************************************************************************

	Function	 : BYTE fmNoteOff(  BYTE Voice )

	Parameters: Voice
					1.) Voice - The voice to turn off

	Actions	 :	 1.) Check for system initialized
					 2.) Check for voice turned on
					 4.) Turn off note relative to voice and mode

*****************************************************************************/

WORD fmNoteOff( BYTE Voice )
{
	// Check for system initialized
	if( !_fmGlobalParameters.systemInitialized )
		return( _ERROR_SYSTEM_NOT_INITIALIZED );

	// Check for voice out of range
	if( Voice > _TOT_VOICES )
		return( _ERROR_VOICE_OUT_OF_RANGE );

	// Check	for voice turned on
	if( !_fmNoteOn[ Voice ] )
		return( _ERROR_VOICE_NOT_ACTIVATED );

	// Check for melodic voice to turn off
	if( ( _fmGlobalParameters.mode == _MELODIC ) || ( _fmGlobalParameters.mode 
			== _PERCUSSIVE && Voice < 6 ) )
	{
		// And off the kon bit
		_fmKONBLOCKReg[ Voice ] &=	_RESET_KON; 

		// Write the fnum high, block, and kon bit( turn the note off )
		fmSetRegister( ( _KON_FNUM_H + Voice ), _fmKONBLOCKReg[ Voice ] );

		// Clear the note on flag
		_fmNoteOn[ Voice ] = _FALSE;

		return( _ERROR_NONE );
	}
	else
	{
		// Check for bass drum
		if( Voice == _BASS_DRUM )
		{
			// Or the bit value for te bass drum into the global register
			_fmPercussionRegister &= 0xef;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _BASS_DRUM ] = _FALSE;
		}

		// Check for snare drum
		else if( Voice == _SNARE_DRUM )
		{
			// Or the bit value for the snare drum into the global register
			_fmPercussionRegister &= 0xf7;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _SNARE_DRUM ] = _FALSE;
		}

		// Check for tom drum
		else if( Voice == _TOM )
		{
			// Or the bit value for the tom drum into the global register
			_fmPercussionRegister &= 0xfb;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _TOM ] = _FALSE;
		}

		// Check for cymbal
		else if( Voice == _CYMBAL )
		{
			// Or the bit value for the cymbal into the global register
			_fmPercussionRegister &= 0xfc;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _CYMBAL ] = _FALSE;
		}

		// Check for high hat
		else if( Voice == _HIGH_HAT )
		{
			// Or the bit value for the high hat into the global register
			_fmPercussionRegister &= 0xfe;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _HIGH_HAT ] = _FALSE;
		}
	}

   // Return the no error code
   return( _ERROR_NONE );
}


