;****************************************************************************
;
;  File              : set.asm
;  Date Created      : 3/20/89
;  Description       : For initializing the hardware timer on the PC.
;
;  Last Modification : February 8, 1992
;
;  Additional Notes  :
;
;****************************************************************************
;            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved
;****************************************************************************

IFNDEF NO_DOS_SEG
  DOSSEG
ENDIF


      INCLUDE   model.inc
      INCLUDE   timer.inc


      .DATA

portb_save   DB   0   ; IBM Hardware port b saved value while using timer

      .CODE

      PUBLIC   _sr_set_8253_timer
      PUBLIC   _sr_reset_8253_timer


_sr_set_8253_timer PROC   USES   DS

      mov   ax,@data        ; set up correct data segment     ;NS
      mov   ds,ax           ; ...              ;NS

      in    al,portb        ; Save contents of speaker port (61h) for later. 
      mov   portb_save,al

      in    al,pimsk        ; Kill timer 0 interrupt
      or    al,01           ; for better quality speech.
      out   pimsk,al

      mov   al,98h          ; Counter 2, r/w LSB, software triggered strobe mode (mode 4) 
      out   modectl,al      ; Set 8253 mode control ; modectl is port 43h

      in    al,portb        ; Enable internal speaker.
      or    al,01
      out   portb,al

      mov   al,00           ; Set timer for almost maximum count.
      out   timer2,al
      ret

_sr_set_8253_timer   ENDP


_sr_reset_8253_timer   PROC   USES DS

      mov   ax,@data        ; set up correct data segment     ;NS
      mov   ds,ax           ; ...              ;NS

      mov   al, portb_save
      out   portb, al       ; restore value of port b 

      in    al, pimsk       ; Enable timer 0
      and   al, 0feh
      out   pimsk, al

      mov   al, 0b6h        ;
      out   modectl, al

      mov   al, 0d0h
      out   timer2, al
      mov   al, 04
      out   timer2, al
      ret

_sr_reset_8253_timer   ENDP

   ifdef   VMKEY
      resident_code   ends
   endif
      END

