;****************************************************************************
;
;  File              : stopio.asm
;  Date Created      : 5/90
;  Description       : Checking condition to stop a record/playback routine.
;
;  Last Modification : February 15, 1992
;
;  Additional Notes  :
;
;****************************************************************************
;            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved
;****************************************************************************

IFNDEF NO_DOS_SEG
  DOSSEG
ENDIF

      INCLUDE   model.inc

      .DATA

      PUBLIC  _ioStopFlag

_ioStopFlag    db    0      ; Flag to indicate that IO is to be
                            ; terminated.  This has been added
                            ; so that a Windows application can
                            ; stop i/o when a key is struck.
      .CODE

      PUBLIC   _sr_stop_io



;**************************************************************************
;*
;*  Routine called by input/output routines to check condition to stop
;*  recording or playing back. 
;*
;*  Used by Covox library routines.
;*
;*  Presently checks for keyboard press
;*
;*  Return Zero flag clear if not to stop else if set stop procedure
;*
;*  Calling routines assume this routine effect only: FLAGS
;*
;**************************************************************************

; This procedure will check a global flag to see if it has been set.  If
; it has been set then the zero flag will be cleared which will indicate
; to the calling program that i/o is to be terminated.
;
_sr_stop_io     PROC

      push    ax

      xor     al, al
      cmp     al, BYTE PTR _ioStopFlag

      pop     ax

      ret

_sr_stop_io   ENDP


      END

