PAGE 118,121
TITLE ORGS ----- 06/10/85  COMPATIBILITY MODULE
.XLIST
INCLUDE DSEG.INC
INCLUDE POSTEQU.INC
.LIST
CODE	SEGMENT BYTE PUBLIC

	PUBLIC	A1
	PUBLIC	CONF_TBL
	PUBLIC	CRT_CHAR_GEN
	PUBLIC	D1
	PUBLIC	D2
	PUBLIC	D2A
	PUBLIC	DISK_BASE
	PUBLIC	DUMMY_RETURN
	PUBLIC	E101
	PUBLIC	E102
	PUBLIC	E103
	PUBLIC	E104
	PUBLIC	E105
	PUBLIC	E106
	PUBLIC	E107
	PUBLIC	E108
	PUBLIC	E109
	PUBLIC	E161
	PUBLIC	E162
	PUBLIC	E163
	PUBLIC	E164
	PUBLIC	E201
	PUBLIC	E202
	PUBLIC	E203
	PUBLIC	E301
	PUBLIC	E302
	PUBLIC	E303
	PUBLIC	E304
	PUBLIC	E401
	PUBLIC	E501
	PUBLIC	E601
	PUBLIC	E602
	PUBLIC	F1780
	PUBLIC	F1781
	PUBLIC	F1782
	PUBLIC	F1790
	PUBLIC	F1791
	PUBLIC	F3A
	PUBLIC	F3D
	PUBLIC	F3D1
	PUBLIC	FD_TBL
	PUBLIC	FLOPPY
	PUBLIC	HRD
	PUBLIC	K6
	PUBLIC	K6L
	PUBLIC	K7
	PUBLIC	K8
	PUBLIC	K10
	PUBLIC	K11
	PUBLIC	K12
	PUBLIC	K14
	PUBLIC	K15
	PUBLIC	M4
	PUBLIC	M5
	PUBLIC	M6
	PUBLIC	M7
	PUBLIC	NMI_INT
	PUBLIC	PRINT_SCREEN
	PUBLIC	P_O_R
	PUBLIC	SEEKS_1
	PUBLIC	SLAVE_VECTOR_TABLE
	PUBLIC	TUTOR
	PUBLIC	VECTOR_TABLE
	PUBLIC	VIDEO_PARMS

	EXTRN	BOOT_STRAP_1:NEAR
	EXTRN	CASSETTE_IO_1:NEAR
	EXTRN	D11:NEAR
	EXTRN	DISK_INT_1:NEAR
	EXTRN	DISK_SETUP:NEAR
	EXTRN	DISKETTE_IO_1:NEAR
	EXTRN	DSKETTE_SETUP:NEAR
	EXTRN	EQUIPMENT_1:NEAR
	EXTRN	INT_287:NEAR
	EXTRN	K16:NEAR
	EXTRN	KEYBOARD_IO_1:NEAR
	EXTRN	KB_INT_1:NEAR
	EXTRN	MEMORY_SIZE_DET_1:NEAR
	EXTRN	NMI_INT_1:NEAR
	EXTRN	PRINT_SCREEN_1:NEAR
	EXTRN	PRINTER_IO_1:NEAR
	EXTRN	RE_DIRECT:NEAR
	EXTRN	RS232_IO_1:NEAR
	EXTRN	RTC_INT:NEAR
	EXTRN	SEEK:NEAR
	EXTRN	START_1:NEAR
	EXTRN	TIME_OF_DAY_1:NEAR
	EXTRN	TIMER_INT_1:NEAR
	EXTRN	VIDEO_IO_1:NEAR

	ASSUME	CS:CODE,DS:DATA

;-------------------------------------------------------------------------------
;									       :
;  THIS MODULE HAS BEEN ADDED TO FACILITATE THE EXPANSION OF THIS PROGRAM.     :
;  IT ALLOWS FOR THE FIXED ORG STATEMENT ENTRY POINTS THAT HAVE TO REMAIN      :
;  AT THE SAME ADDRESSES.   THE USE OF ENTRY POINTS AND TABLES WITHIN THIS     :
;  MODULE SHOULD BE AVOIDED AND ARE INCLUDED ONLY TO SUPPORT EXISTING CODE     :
;  THAT VIOLATE THE STRUCTURE AND DESIGN OF BIOS.   ALL BIOS ACCESS SHOULD     :
;  USE THE DOCUMENTED INTERRUPT VECTOR INTERFACE FOR COMPATIBILITY.	       :
;									       :
;-------------------------------------------------------------------------------
PAGE
;--------------------------------
;	COPYRIGHT NOTICE	:
;--------------------------------
;;-	ORG	0E000H
	ORG	00000H

	DB	'78X7462 COPR. IBM 1981, 1986    '

;----------------------------------------
;	PARITY ERROR MESSAGES		:
;----------------------------------------

D1	DB	'PARITY CHECK 1',CR,LF  ; PLANAR BOARD PARITY CHECK LATCH SET
D2	DB	'PARITY CHECK 2',CR,LF  ; I/O CHANNEL CHECK LATCH SET
D2A	DB	'?????',CR,LF
IP	=	$
;;-	ORG	0E05BH
	ORG	0005BH
RESET:					;	RESET START
	JMP	START_1 		; VECTOR ON TO THE MOVED POST CODE

;--------------------------------
;	POST ERROR MESSAGES	:
;--------------------------------

E101	DB	' 101-System Board Error',CR,LF ; INTERRUPT FAILURE
E102	DB	' 102-System Board Error',CR,LF ; TIMER FAILURE
E103	DB	' 103-System Board Error',CR,LF ; TIMER INTERRUPT FAILURE
E104	DB	' 104-System Board Error',CR,LF ; PROTECTED MODE FAILURE
E105	DB	' 105-System Board Error',CR,LF ; LAST 8042 COMMAND NOT ACCEPTED
E106	DB	' 106-System Board Error',CR,LF ; CONVERTING LOGIC TEST
E107	DB	' 107-System Board Error',CR,LF ; HOT NMI TEST
E108	DB	' 108-System Board Error',CR,LF ; TIMER BUS TEST
E109	DB	' 109-System Board Error',CR,LF ; LOW MEG CHIP SELECT TEST
E161	DB	' 161-System Options Not Set-(Run SETUP)',CR,LF ; DEAD BATTERY
E162	DB	' 162-System Options Not Set-(Run SETUP)',CR,LF ;CHECKSUM/CONFIG
E163	DB	' 163-Time & Date Not Set-(Run SETUP)',CR,LF ;CLOCK NOT UPDATING
E164	DB	' 164-Memory Size Error-(Run SETUP)',CR,LF ; CMOS DOES NOT MATCH
E201	DB	' 201-Memory Error',CR,LF
E202	DB	' 202-Memory Address Error',CR,LF            ; LINE ERROR 00->15
E203	DB	' 203-Memory Address Error',CR,LF            ; LINE ERROR 16->23
E301	DB	' 301-Keyboard Error',CR,LF                  ; KEYBOARD ERROR
E302	DB	' 302-System Unit Keylock is Locked',CR,LF   ; KEYBOARD LOCK ON
F3D	DB	' (RESUME = "F1" KEY)',CR,LF

;-----	NMI ENTRY

IP	=	$
;;-	ORG	0E2C3H
	ORG	002C3H
NMI_INT EQU	$
	JMP	NMI_INT_1		; VECTOR ON TO MOVED NMI CODE

E303	DB	' 303-Keyboard Or System Unit Error',CR,LF
;-----	KEYBOARD/SYSTEM ERROR
E304	DB	' 304-Keyboard Or System Unit Error',CR,LF ; KEYBOARD CLOCK HIGH
E401	DB	' 401-CRT Error',CR,LF                          ; MONOCHROME
E501	DB	' 501-CRT Error',CR,LF                          ; COLOR
E601	DB	' 601-Diskette Error',CR,LF                     ; DISKETTE ERROR
;-----	DISKETTE BOOT RECORD IS NOT VALID
E602	DB	' 602-Diskette Boot Record Error',CR,LF
;-----	HARD FILE ERROR MESSAGE
F1780	DB	'1780-Disk 0 Failure',CR,LF
F1781	DB	'1781-Disk 1 Failure',CR,LF
F1782	DB	'1782-Disk Controller Failure',CR,LF
F1790	DB	'1790-Disk 0 Error',CR,LF
F1791	DB	'1791-Disk 1 Error',CR,LF

F3A	DB	'ROM  Error ',CR,LF                             ; ROM CHECKSUM
F3D1	DB	'    -Unlock System Unit Keylock ',CR,LF
PAGE
;--------------------------------------------------------
; INITIALIZE DRIVE CHARACTERISTICS			:
;							:
; FIXED DISK PARAMETER TABLE				:
;							:
;  -  THE TABLE IS COMPOSED OF A BLOCK DEFINED AS:	:
;							:
;  +0	(1 WORD) - MAXIMUM NUMBER OF CYLINDERS		:
;  +2	(1 BYTE) - MAXIMUM NUMBER OF HEADS		:
;  +3	(1 WORD) - NOT USED/SEE PC-XT			:
;  +5	(1 WORD) - STARTING WRITE PRECOMPENSATION CYL	:
;  +7	(1 BYTE) - NOT USED/SEE PC-XT			:
;  +8	(1 BYTE) - CONTROL BYTE 			:
;		   BIT	  7 DISABLE RETRIES -OR-	:
;		   BIT	  6 DISABLE RETRIES		:
;		   BIT	  3 MORE THAN 8 HEADS		:
;  +9	(3 BYTES)- NOT USED/SEE PC-XT			:
; +12	(1 WORD) - LANDING ZONE 			:
; +14	(1 BYTE) - NUMBER OF SECTORS/TRACK		:
; +15	(1 BYTE) - RESERVED FOR FUTURE USE		:
;							:
;	 - TO DYNAMICALLY DEFINE A SET OF PARAMETERS	:
;	   BUILD A TABLE FOR UP TO 15 TYPES AND PLACE	:
;	   THE CORRESPONDING VECTOR INTO INTERRUPT 41	:
;	   FOR DRIVE 0 AND INTERRUPT 46 FOR DRIVE 1.	:
;							:
;--------------------------------------------------------

FD_TBL:

;-----	DRIVE TYPE 01

	DW	0306D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0128D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0305D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 02

	DW	0615D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0615D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 03

	DW	0615D			; CYLINDERS
	DB	06D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0615D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 04

	DW	0940D			; CYLINDERS
	DB	08D			; HEADS
	DW	0
	DW	0512D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0940D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 05

	DW	0940D			; CYLINDERS
	DB	06D			; HEADS
	DW	0
	DW	0512D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0940D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 06

	DW	0615D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0615D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0
PAGE
;-----	DRIVE TYPE 07

	DW	0462D			; CYLINDERS
	DB	08D			; HEADS
	DW	0
	DW	0256D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0511D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 08

	DW	0733D			; CYLINDERS
	DB	05D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0733D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 09

	DW	0900D			; CYLINDERS
	DB	15D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	008H			; CONTROL BYTE
	DB	0,0,0
	DW	0901D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 10

	DW	0820D			; CYLINDERS
	DB	03D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0820D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 11

	DW	0855D			; CYLINDERS
	DB	05D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0855D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 12

	DW	0855D			; CYLINDERS
	DB	07D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0855D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 13

	DW	0306D			; CYLINDERS
	DB	08D			; HEADS
	DW	0
	DW	0128D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0319D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 14

	DW	0733D			; CYLINDERS
	DB	07D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0733D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0
PAGE
;-----	DRIVE TYPE 15			 RESERVED      ****  DO NOT USE  ****

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 16

	DW	0612D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION ALL CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0663D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 17

	DW	0977D			; CYLINDERS
	DB	05D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0977D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 18

	DW	0977D			; CYLINDERS
	DB	07D			; HEADS
	DW	0
	DW	0FFFFH			; NO WRITE PRE-COMPENSATION
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0977D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 19

	DW	1024D			; CYLINDERS
	DB	07D			; HEADS
	DW	0
	DW	0512D			; WRITE PRE-COMPENSATION CYLINDER
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	1023D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 20

	DW	0733D			; CYLINDERS
	DB	05D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0732D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 21

	DW	0733D			; CYLINDERS
	DB	07D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0732D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 22

	DW	0733D			; CYLINDERS
	DB	05D			; HEADS
	DW	0
	DW	0300D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0733D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0
PAGE
;-----	DRIVE TYPE 23

	DW	0306D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION ALL CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0336D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 24

	DW	0612D			; CYLINDERS
	DB	04D			; HEADS
	DW	0
	DW	0305D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0663D			; LANDING ZONE
	DB	17D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 25	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 26	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 27	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 28	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 29	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 30	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0
PAGE
;-----	DRIVE TYPE 31	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 32	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 33	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 34	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 35	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 36	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 37	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 38	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0
PAGE
;-----	DRIVE TYPE 39	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 40	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 41	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 42	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 43	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 44	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 45	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0

;-----	DRIVE TYPE 46	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0
PAGE
;-----	DRIVE TYPE 47	*** RESERVED ***

	DW	0000D			; CYLINDERS
	DB	00D			; HEADS
	DW	0
	DW	0000D			; WRITE PRE-COMPENSATION CYL
	DB	0
	DB	0			; CONTROL BYTE
	DB	0,0,0
	DW	0000D			; LANDING ZONE
	DB	00D			; SECTORS/TRACK
	DB	0


;-----	BOOT LOADER INTERRUPT

IP	=	$
;;-	ORG	0E6F2H
	ORG	006F2H
BOOT_STRAP	EQU	$
	JMP	BOOT_STRAP_1		; VECTOR ON TO MOVED BOOT CODE

					;	USE INT 15 H  AH= 0C0H
CONF_TBL:				; CONFIGURATION TABLE FOR THIS SYSTEM
	DW	CONF_E-CONF_TBL-2	; LENGTH OF FOLLOWING TABLE
	DB	MODEL_BYTE		; SYSTEM MODEL BYTE
	DB	SUB_MODEL_BYTE		; SYSTEM SUB MODEL TYPE BYTE
	DB	BIOS_LEVEL		; BIOS REVISION LEVEL
	DB	01110000B		; 10000000 = DMA CHANNEL 3 USE BY BIOS
					; 01000000 = CASCADED INTERRUPT LEVEL 2
					; 00100000 = REAL TIME CLOCK AVAILABLE
					; 00010000 = KEYBOARD SCAN CODE HOOK 1AH
	DB	0			; RESERVED
	DB	0			; RESERVED
	DB	0			; RESERVED
	DB	0			; RESERVED
CONF_E	EQU	$			; RESERVED FOR EXPANSION

;-----	BAUD RATE INITIALIZATION TABLE

IP	=	$
;;-	ORG	0E729H
	ORG	00729H
A1	DW	1047			; 110 BAUD	; TABLE OF VALUES
	DW	768			; 150		; FOR INITIALIZATION
	DW	384			; 300
	DW	192			; 600
	DW	96			; 1200
	DW	48			; 2400
	DW	24			; 4800
	DW	12			; 9600

;-----	RS232

;;-	ORG	0E739H
	ORG	00739H
RS232_IO	EQU	$
	JMP	RS232_IO_1		; VECTOR ON TO MOVED RS232 CODE

;-----	KEYBOARD

;;-	ORG	0E82EH
	ORG	0082EH
KEYBOARD_IO	EQU	$
	JMP	KEYBOARD_IO_1		; VECTOR ON TO MOVED KEYBOARD CODE

;---------------------------------------------------------------------
;	KEY IDENTIFICATION SCAN TABLES				     -
;---------------------------------------------------------------------
;;-	ORG	0E87EH
	ORG	0087EH
;--------------  TABLE OF SHIFT KEYS AND MASK VALUES
;------ KEY_TABLE
K6	LABEL	BYTE
	DB	INS_KEY 		; INSERT KEY
	DB	CAPS_KEY,NUM_KEY,SCROLL_KEY,ALT_KEY,CTL_KEY
	DB	LEFT_KEY,RIGHT_KEY
K6L	EQU	$-K6

;------ MASK_TABLE
K7	LABEL	BYTE
	DB	INS_SHIFT		; INSERT MODE SHIFT
	DB	CAPS_SHIFT,NUM_SHIFT,SCROLL_SHIFT,ALT_SHIFT,CTL_SHIFT
	DB	LEFT_SHIFT,RIGHT_SHIFT

;----------------------  TABLES FOR CTRL CASE  -----------------------

K8	LABEL	BYTE			;-------- CHARACTERS ---------
	DB	27,-1,00,-1,-1,-1	; Esc, 1, 2, 3, 4, 5
	DB	30,-1,-1,-1,-1,31	; 6, 7, 8, 9, 0, -
	DB	-1,127,148,17,23,5	; =, Bksp, Tab, Q, W, E
	DB	18,20,25,21,9,15	; R, T, Y, U, I, O
	DB	16,27,29,10,-1,01	; P, [,], Enter, Ctrl, A
	DB	19,04,06,07,08,10	; S, D, F, G, H, J
	DB	11,12,-1,-1,-1,-1	; K, L, ;, ', ', LShift
	DB	28,26,24,03,22,02	; Bkslash, Z, X, C, V, B
	DB	14,13,-1,-1,-1,-1	; N, M, ,, ., /, RShift
	DB	150,-1,' ',-1           ; *, Alt, Space, CL
					;--------- FUNCTIONS ---------
	DB	94,95,96,97,98,99	; F1 - F6
	DB	100,101,102,103,-1,-1	; F7 - F10, NL, SL
	DB	119,141,132,142,115,143 ; Home, Up, PgUp, -, Left, Pad5
	DB	116,144,117,145,118,146 ; Right, +, End, Down, PgDn, Ins
	DB	147,-1,-1,-1,137,138	; Del, SysReq, Undef, WT, F11, F12
PAGE
;----------------------  TABLES FOR LOWER CASE	----------------------

K10	LABEL	BYTE
	DB	27,'12345'
	DB	'67890-'
	DB	'=',08,09,'qwe'
	DB	'rtyuio'
	DB	'p[]',0DH,-1,'a'        ; LETTERS, Return, Ctrl
	DB	'sdfghj'
	DB	"kl;'`",-1              ; LETTERS, L Shift
	DB	92,'zxcvb'
	DB	'nm,./'
	DB	-1,'*',-1,' ',-1        ; R Shift,*, Alt, Space, CL

;------ LC TABLE SCAN
	DB	59,60,61,62,63		; BASE STATE OF F1 - F10
	DB	64,65,66,67,68
	DB	-1,-1			; NL, SL

;------ KEYPAD TABLE
K15	LABEL	BYTE
	DB	71,72,73,-1,75,-1	; BASE STATE OF KEYPAD KEYS
	DB	77,-1,79,80,81,82
	DB	83
	DB	-1,-1,92,133,134	; SysRq, Undef, WT, F11, F12

;-----	KEYBOARD INTERRUPT

;;-	ORG	0E987H
	ORG	00987H
KB_INT	EQU	$
	JMP	KB_INT_1		; VECTOR ON TO MOVED KEYBOARD HANDLER

;----------------------  TABLES FOR UPPER CASE	----------------------

K11	LABEL	BYTE
	DB	27,'!@#$%'
	DB	94,'&*()_'
	DB	'+',08,00,'QWE'
	DB	'RTYUIO'                ; LETTERS, Return, Ctrl
	DB	'P{}',0DH,-1,'A'
	DB	'SDFGHJ'
	DB	'KL:"',126,-1           ; LETTERS, L Shift
	DB	124,'ZXCVB'
	DB	'NM<>?'
	DB	-1,'*',-1,' ',-1        ; R Shift,*, Alt, Space, CL

;-----	UC TABLE SCAN
K12	LABEL	BYTE
	DB	84,85,86,87,88		; SHIFTED STATE OF F1 - F10
	DB	89,90,91,92,93
	DB	-1,-1			; NL, SL

;-----	NUM STATE TABLE
K14	LABEL	BYTE
	DB	'789-456+1230.'         ; NUMLOCK STATE OF KEYPAD KEYS
	DB	-1,-1,124,135,136
PAGE
;-----	DISKETTE I/O

;;-	ORG	0EC59H
	ORG	00C59H
DISKETTE_IO	EQU	$
	JMP	DISKETTE_IO_1		; VECTOR ON TO MOVED DISKETTE CODE

;-----	DISKETTE INTERRUPT

;;-	ORG	0EF57H
	ORG	00F57H
DISK_INT	EQU	$
	JMP	DISK_INT_1		; VECTOR ON TO MOVED DISKETTE HANDLER

;-----	DISKETTE PARAMETERS

;;-	ORG	0EFC7H
	ORG	00FC7H

;----------------------------------------------------------------
; DISK_BASE							:
;	THIS IS THE SET OF PARAMETERS REQUIRED FOR		:
;	DISKETTE OPERATION. THEY ARE POINTED AT BY THE		:
;	DATA VARIABLE @DISK_POINTER. TO MODIFY THE PARAMETERS,	:
;	BUILD ANOTHER PARAMETER BLOCK AND POINT AT IT		:
;----------------------------------------------------------------

DISK_BASE	LABEL	BYTE

	DB	11011111B	; SRT=D, HD UNLOAD=0F - 1ST SPECIFY BYTE
	DB	2		; HD LOAD=1, MODE=DMA - 2ND SPECIFY BYTE
	DB	MOTOR_WAIT	; WAIT TIME AFTER OPERATION TILL MOTOR OFF
	DB	2		; 512 BYTES/SECTOR
	DB	15		; EOT ( LAST SECTOR ON TRACK)
	DB	01BH		; GAP LENGTH
	DB	0FFH		; DTL
	DB	054H		; GAP LENGTH FOR FORMAT
	DB	0F6H		; FILL BYTE FOR FORMAT
	DB	15		; HEAD SETTLE TIME (MILLISECONDS)
	DB	8		; MOTOR START TIME (1/8 SECONDS)

;-----	PRINTER I/O

;;-	ORG	0EFD2H
	ORG	00FD2H
PRINTER_IO	EQU	$
	JMP	PRINTER_IO_1		; VECTOR ON TO MOVED PRINTER CODE

;-----	FOR POSSIBLE COMPATIBILITY ENTRY POINTS

;;-	ORG	0F045H
	ORG	01045H
	ASSUME	CS:CODE,DS:DATA

	EXTRN	SET_MODE:NEAR
	EXTRN	SET_CTYPE:NEAR
	EXTRN	SET_CPOS:NEAR
	EXTRN	READ_CURSOR:NEAR
	EXTRN	READ_LPEN:NEAR
	EXTRN	ACT_DISP_PAGE:NEAR
	EXTRN	SCROLL_UP:NEAR
	EXTRN	SCROLL_DOWN:NEAR
	EXTRN	READ_AC_CURRENT:NEAR
	EXTRN	WRITE_AC_CURRENT:NEAR
	EXTRN	WRITE_C_CURRENT:NEAR
	EXTRN	SET_COLOR:NEAR
	EXTRN	WRITE_DOT:NEAR
	EXTRN	READ_DOT:NEAR
	EXTRN	WRITE_TTY:NEAR
	EXTRN	VIDEO_STATE:NEAR

M1	DW	OFFSET SET_MODE 	;  TABLE OF ROUTINES WITHIN VIDEO I/O
	DW	OFFSET SET_CTYPE	;	EXIT STACK VALUES MAY BE
	DW	OFFSET SET_CPOS 	;	DIFFERENT DEPENDING ON THE
	DW	OFFSET READ_CURSOR	;	SYSTEM AND MODEL
	DW	OFFSET READ_LPEN
	DW	OFFSET ACT_DISP_PAGE
	DW	OFFSET SCROLL_UP
	DW	OFFSET SCROLL_DOWN
	DW	OFFSET READ_AC_CURRENT
	DW	OFFSET WRITE_AC_CURRENT
	DW	OFFSET WRITE_C_CURRENT
	DW	OFFSET SET_COLOR
	DW	OFFSET WRITE_DOT
	DW	OFFSET READ_DOT
	DW	OFFSET WRITE_TTY
	DW	OFFSET VIDEO_STATE
M1L	EQU	$-M1

;;-	ORG	0F065H
	ORG	01065H
VIDEO_IO	EQU	$
	JMP	VIDEO_IO_1		; VECTOR ON TO MOVED VIDEO CODE

;-----	VIDEO PARAMETERS --- INIT_TABLE

;;-	ORG	0F0A4H
	ORG	010A4H

VIDEO_PARMS	LABEL	BYTE
	DB	38H,28H,2DH,0AH,1FH,6,19H	; SET UP FOR 40X25
	DB	1CH,2,7,6,7
	DB	0,0,0,0
M4	EQU	$-VIDEO_PARMS

	DB	71H,50H,5AH,0AH,1FH,6,19H	; SET UP FOR 80X25
	DB	1CH,2,7,6,7
	DB	0,0,0,0

	DB	38H,28H,2DH,0AH,7FH,6,64H	; SETUP FOR GRAPHICS
	DB	70H,2,1,6,7
	DB	0,0,0,0

	DB	61H,50H,52H,0FH,19H,6,19H	; SETUP FOR 80X25 B&W CARD
	DB	19H,2,0DH,0BH,0CH
	DB	0,0,0,0
					; TABLE OF REGEN LENGTHS
M5	DW	2048			; 40X25
	DW	4096			; 80X25
	DW	16384			; GRAPHICS
	DW	16384

;-----	COLUMNS

M6	DB	40,40,80,80,40,40,80,80

;-----	C_REG_TAB

M7	DB	2CH,28H,2DH,29H,2AH,2EH,1EH,29H ; TABLE OF MODE SETS

;-----	MEMORY SIZE

;;-	ORG	0F841H
	ORG	01841H
MEMORY_SIZE_DET EQU  $
	JMP	MEMORY_SIZE_DET_1	; VECTOR ON TO MOVED BIOS CODE

;-----	EQUIPMENT DETERMINE

;;-	ORG	0F84DH
	ORG	0184DH
EQUIPMENT	EQU  $
	JMP	EQUIPMENT_1		; VECTOR ON TO MOVED BIOS CODE

;-----	CASSETTE (NO BIOS SUPPORT)

;;-	ORG	0F859H
	ORG	01859H
CASSETTE_IO	EQU  $
	JMP	CASSETTE_IO_1		; VECTOR ON TO MOVED BIOS CODE

;----------------------------------------------------------------------
; CHARACTER GENERATOR GRAPHICS FOR 320X200 AND 640X200 GRAPHICS       :
;----------------------------------------------------------------------
;;-	ORG	0FA6EH
	ORG	01A6EH
CRT_CHAR_GEN	LABEL	BYTE
	DB	000H,000H,000H,000H,000H,000H,000H,000H ; D_00	BLANK
	DB	07EH,081H,0A5H,081H,0BDH,099H,081H,07EH ; D_01	SMILING FACE
	DB	07EH,0FFH,0DBH,0FFH,0C3H,0E7H,0FFH,07EH ; D_02	SMILING FACE N
	DB	06CH,0FEH,0FEH,0FEH,07CH,038H,010H,000H ; D_03	HEART
	DB	010H,038H,07CH,0FEH,07CH,038H,010H,000H ; D_04	DIAMOND
	DB	038H,07CH,038H,0FEH,0FEH,07CH,038H,07CH ; D_05	CLUB
	DB	010H,010H,038H,07CH,0FEH,07CH,038H,07CH ; D_06	SPADE
	DB	000H,000H,018H,03CH,03CH,018H,000H,000H ; D_07	BULLET
	DB	0FFH,0FFH,0E7H,0C3H,0C3H,0E7H,0FFH,0FFH ; D_08	BULLET NEG
	DB	000H,03CH,066H,042H,042H,066H,03CH,000H ; D_09	CIRCLE
	DB	0FFH,0C3H,099H,0BDH,0BDH,099H,0C3H,0FFH ; D_0A	CIRCLE NEG
	DB	00FH,007H,00FH,07DH,0CCH,0CCH,0CCH,078H ; D_0B	MALE
	DB	03CH,066H,066H,066H,03CH,018H,07EH,018H ; D_0C	FEMALE
	DB	03FH,033H,03FH,030H,030H,070H,0F0H,0E0H ; D_0D	EIGHTH NOTE
	DB	07FH,063H,07FH,063H,063H,067H,0E6H,0C0H ; D_0E	TWO 1/16 NOTE
	DB	099H,05AH,03CH,0E7H,0E7H,03CH,05AH,099H ; D_0F	SUN

	DB	080H,0E0H,0F8H,0FEH,0F8H,0E0H,080H,000H ; D_10	R ARROWHEAD
	DB	002H,00EH,03EH,0FEH,03EH,00EH,002H,000H ; D_11	L ARROWHEAD
	DB	018H,03CH,07EH,018H,018H,07EH,03CH,018H ; D_12	ARROW 2 VERT
	DB	066H,066H,066H,066H,066H,000H,066H,000H ; D_13	2 EXCLAMATIONS
	DB	07FH,0DBH,0DBH,07BH,01BH,01BH,01BH,000H ; D_14	PARAGRAPH
	DB	03EH,063H,038H,06CH,06CH,038H,0CCH,078H ; D_15	SECTION
	DB	000H,000H,000H,000H,07EH,07EH,07EH,000H ; D_16	RECTANGLE
	DB	018H,03CH,07EH,018H,07EH,03CH,018H,0FFH ; D_17	ARROW 2 VRT UP
	DB	018H,03CH,07EH,018H,018H,018H,018H,000H ; D_18	ARROW VRT UP
	DB	018H,018H,018H,018H,07EH,03CH,018H,000H ; D_19	ARROW VRT DOWN
	DB	000H,018H,00CH,0FEH,00CH,018H,000H,000H ; D_1A	ARROW RIGHT
	DB	000H,030H,060H,0FEH,060H,030H,000H,000H ; D_1B	ARROW LEFT
	DB	000H,000H,0C0H,0C0H,0C0H,0FEH,000H,000H ; D_1C	NOT INVERTED
	DB	000H,024H,066H,0FFH,066H,024H,000H,000H ; D_1D	ARROW 2 HORZ
	DB	000H,018H,03CH,07EH,0FFH,0FFH,000H,000H ; D_1E	ARROWHEAD UP
	DB	000H,0FFH,0FFH,07EH,03CH,018H,000H,000H ; D_1F	ARROWHEAD DOWN

	DB	000H,000H,000H,000H,000H,000H,000H,000H ; D_20	SPACE
	DB	030H,078H,078H,030H,030H,000H,030H,000H ; D_21 ! EXCLAMATION
	DB	06CH,06CH,06CH,000H,000H,000H,000H,000H ; D_22 " QUOTATION
	DB	06CH,06CH,0FEH,06CH,0FEH,06CH,06CH,000H ; D_23 # LB.
	DB	030H,07CH,0C0H,078H,00CH,0F8H,030H,000H ; D_24 $ DOLLAR SIGN
	DB	000H,0C6H,0CCH,018H,030H,066H,0C6H,000H ; D_25 % PERCENT
	DB	038H,06CH,038H,076H,0DCH,0CCH,076H,000H ; D_26 & AMPERSAND
	DB	060H,060H,0C0H,000H,000H,000H,000H,000H ; D_27 ' APOSTROPHE
	DB	018H,030H,060H,060H,060H,030H,018H,000H ; D_28 ( L. PARENTHESIS
	DB	060H,030H,018H,018H,018H,030H,060H,000H ; D_29 ) R. PARENTHESIS
	DB	000H,066H,03CH,0FFH,03CH,066H,000H,000H ; D_2A * ASTERISK
	DB	000H,030H,030H,0FCH,030H,030H,000H,000H ; D_2B + PLUS
	DB	000H,000H,000H,000H,000H,030H,030H,060H ; D_2C , COMMA
	DB	000H,000H,000H,0FCH,000H,000H,000H,000H ; D_2D - DASH
	DB	000H,000H,000H,000H,000H,030H,030H,000H ; D_2E . PERIOD
	DB	006H,00CH,018H,030H,060H,0C0H,080H,000H ; D_2F / SLASH

	DB	07CH,0C6H,0CEH,0DEH,0F6H,0E6H,07CH,000H ; D_30 0
	DB	030H,070H,030H,030H,030H,030H,0FCH,000H ; D_31 1
	DB	078H,0CCH,00CH,038H,060H,0CCH,0FCH,000H ; D_32 2
	DB	078H,0CCH,00CH,038H,00CH,0CCH,078H,000H ; D_33 3
	DB	01CH,03CH,06CH,0CCH,0FEH,00CH,01EH,000H ; D_34 4
	DB	0FCH,0C0H,0F8H,00CH,00CH,0CCH,078H,000H ; D_35 5
	DB	038H,060H,0C0H,0F8H,0CCH,0CCH,078H,000H ; D_36 6
	DB	0FCH,0CCH,00CH,018H,030H,030H,030H,000H ; D_37 7
	DB	078H,0CCH,0CCH,078H,0CCH,0CCH,078H,000H ; D_38 8
	DB	078H,0CCH,0CCH,07CH,00CH,018H,070H,000H ; D_39 9
	DB	000H,030H,030H,000H,000H,030H,030H,000H ; D_3A : COLON
	DB	000H,030H,030H,000H,000H,030H,030H,060H ; D_3B ; SEMICOLON
	DB	018H,030H,060H,0C0H,060H,030H,018H,000H ; D_3C < LESS THAN
	DB	000H,000H,0FCH,000H,000H,0FCH,000H,000H ; D_3D = EQUAL
	DB	060H,030H,018H,00CH,018H,030H,060H,000H ; D_3E > GREATER THAN
	DB	078H,0CCH,00CH,018H,030H,000H,030H,000H ; D_3F ? QUESTION MARK

	DB	07CH,0C6H,0DEH,0DEH,0DEH,0C0H,078H,000H ; D_40 @ AT
	DB	030H,078H,0CCH,0CCH,0FCH,0CCH,0CCH,000H ; D_41 A
	DB	0FCH,066H,066H,07CH,066H,066H,0FCH,000H ; D_42 B
	DB	03CH,066H,0C0H,0C0H,0C0H,066H,03CH,000H ; D_43 C
	DB	0F8H,06CH,066H,066H,066H,06CH,0F8H,000H ; D_44 D
	DB	0FEH,062H,068H,078H,068H,062H,0FEH,000H ; D_45 E
	DB	0FEH,062H,068H,078H,068H,060H,0F0H,000H ; D_46 F
	DB	03CH,066H,0C0H,0C0H,0CEH,066H,03EH,000H ; D_47 G
	DB	0CCH,0CCH,0CCH,0FCH,0CCH,0CCH,0CCH,000H ; D_48 H
	DB	078H,030H,030H,030H,030H,030H,078H,000H ; D_49 I
	DB	01EH,00CH,00CH,00CH,0CCH,0CCH,078H,000H ; D_4A J
	DB	0E6H,066H,06CH,078H,06CH,066H,0E6H,000H ; D_4B K
	DB	0F0H,060H,060H,060H,062H,066H,0FEH,000H ; D_4C L
	DB	0C6H,0EEH,0FEH,0FEH,0D6H,0C6H,0C6H,000H ; D_4D M
	DB	0C6H,0E6H,0F6H,0DEH,0CEH,0C6H,0C6H,000H ; D_4E N
	DB	038H,06CH,0C6H,0C6H,0C6H,06CH,038H,000H ; D_4F O

	DB	0FCH,066H,066H,07CH,060H,060H,0F0H,000H ; D_50 P
	DB	078H,0CCH,0CCH,0CCH,0DCH,078H,01CH,000H ; D_51 Q
	DB	0FCH,066H,066H,07CH,06CH,066H,0E6H,000H ; D_52 R
	DB	078H,0CCH,0E0H,070H,01CH,0CCH,078H,000H ; D_53 S
	DB	0FCH,0B4H,030H,030H,030H,030H,078H,000H ; D_54 T
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,0FCH,000H ; D_55 U
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,078H,030H,000H ; D_56 V
	DB	0C6H,0C6H,0C6H,0D6H,0FEH,0EEH,0C6H,000H ; D_57 W
	DB	0C6H,0C6H,06CH,038H,038H,06CH,0C6H,000H ; D_58 X
	DB	0CCH,0CCH,0CCH,078H,030H,030H,078H,000H ; D_59 Y
	DB	0FEH,0C6H,08CH,018H,032H,066H,0FEH,000H ; D_5A Z
	DB	078H,060H,060H,060H,060H,060H,078H,000H ; D_5B [ LEFT BRACKET
	DB	0C0H,060H,030H,018H,00CH,006H,002H,000H ; D_5C \ BACKSLASH
	DB	078H,018H,018H,018H,018H,018H,078H,000H ; D_5D ] RIGHT BRACKET
	DB	010H,038H,06CH,0C6H,000H,000H,000H,000H ; D_5E ^ CIRCUMFLEX
	DB	000H,000H,000H,000H,000H,000H,000H,0FFH ; D_5F _ UNDERSCORE

	DB	030H,030H,018H,000H,000H,000H,000H,000H ; D_60 ` APOSTROPHE REV
	DB	000H,000H,078H,00CH,07CH,0CCH,076H,000H ; D_61 a
	DB	0E0H,060H,060H,07CH,066H,066H,0DCH,000H ; D_62 b
	DB	000H,000H,078H,0CCH,0C0H,0CCH,078H,000H ; D_63 c
	DB	01CH,00CH,00CH,07CH,0CCH,0CCH,076H,000H ; D_64 d
	DB	000H,000H,078H,0CCH,0FCH,0C0H,078H,000H ; D_65 e
	DB	038H,06CH,060H,0F0H,060H,060H,0F0H,000H ; D_66 f
	DB	000H,000H,076H,0CCH,0CCH,07CH,00CH,0F8H ; D_67 g
	DB	0E0H,060H,06CH,076H,066H,066H,0E6H,000H ; D_68 h
	DB	030H,000H,070H,030H,030H,030H,078H,000H ; D_69 i
	DB	00CH,000H,00CH,00CH,00CH,0CCH,0CCH,078H ; D_6A j
	DB	0E0H,060H,066H,06CH,078H,06CH,0E6H,000H ; D_6B k
	DB	070H,030H,030H,030H,030H,030H,078H,000H ; D_6C l
	DB	000H,000H,0CCH,0FEH,0FEH,0D6H,0C6H,000H ; D_6D m
	DB	000H,000H,0F8H,0CCH,0CCH,0CCH,0CCH,000H ; D_6E n
	DB	000H,000H,078H,0CCH,0CCH,0CCH,078H,000H ; D_6F o

	DB	000H,000H,0DCH,066H,066H,07CH,060H,0F0H ; D_70 p
	DB	000H,000H,076H,0CCH,0CCH,07CH,00CH,01EH ; D_71 q
	DB	000H,000H,0DCH,076H,066H,060H,0F0H,000H ; D_72 r
	DB	000H,000H,07CH,0C0H,078H,00CH,0F8H,000H ; D_73 s
	DB	010H,030H,07CH,030H,030H,034H,018H,000H ; D_74 t
	DB	000H,000H,0CCH,0CCH,0CCH,0CCH,076H,000H ; D_75 u
	DB	000H,000H,0CCH,0CCH,0CCH,078H,030H,000H ; D_76 v
	DB	000H,000H,0C6H,0D6H,0FEH,0FEH,06CH,000H ; D_77 w
	DB	000H,000H,0C6H,06CH,038H,06CH,0C6H,000H ; D_78 x
	DB	000H,000H,0CCH,0CCH,0CCH,07CH,00CH,0F8H ; D_79 y
	DB	000H,000H,0FCH,098H,030H,064H,0FCH,000H ; D_7A z
	DB	01CH,030H,030H,0E0H,030H,030H,01CH,000H ; D_7B { LEFT BRACE
	DB	018H,018H,018H,000H,018H,018H,018H,000H ; D_7C | BROKEN STROKE
	DB	0E0H,030H,030H,01CH,030H,030H,0E0H,000H ; D_7D } RIGHT BRACE
	DB	076H,0DCH,000H,000H,000H,000H,000H,000H ; D_7E ~ TILDE
	DB	000H,010H,038H,06CH,0C6H,0C6H,0FEH,000H ; D_7F  DELTA

;-----	TIME OF DAY

;;-	ORG	0FE6EH
	ORG	01E6EH
TIME_OF_DAY	EQU	$
	JMP	TIME_OF_DAY_1		; VECTOR ON TO MOVED BIOS CODE

;-----	TIMER INTERRUPT

;;-	ORG	0FEA5H
	ORG	01EA5H
TIMER_INT	EQU	$
	JMP	TIMER_INT_1		; VECTOR ON TO MOVED BIOS CODE
PAGE
;-----	VECTOR TABLE

;;-	ORG	0FEF3H
	ORG	01EF3H			;	AT LOCATION 0FEF3H
VECTOR_TABLE	LABEL	WORD		; VECTOR TABLE VALUES FOR POST TESTS
	DW	OFFSET TIMER_INT	; INT 08H - HARDWARE TIMER 0	  IRQ  0
	DW	OFFSET KB_INT		; INT 09H - KEYBOARD		  IRQ  1
	DW	OFFSET	D11		; INT 0AH - SLAVE INTERRUPT INPUT
	DW	OFFSET	D11		; INT 0BH -			  IRQ  3
	DW	OFFSET	D11		; INT 0CH -			  IRQ  4
	DW	OFFSET	D11		; INT 0DH -			  IRQ  5
	DW	OFFSET DISK_INT 	; INT 0EH - DISKETTE		  IRQ  6
	DW	OFFSET	D11		; INT 0FH -			  IRQ  7

;-----	SOFTWARE INTERRUPTS  ( BIOS CALLS AND POINTERS )

	DW	OFFSET VIDEO_IO 	; INT 10H -- VIDEO DISPLAY
	DW	OFFSET EQUIPMENT	; INT 11H -- GET EQUIPMENT FLAG WORD
	DW	OFFSET MEMORY_SIZE_DET	; INT 12H -- GET REAL MODE MEMORY SIZE
	DW	OFFSET DISKETTE_IO	; INT 13H -- DISKETTE
	DW	OFFSET RS232_IO 	; INT 14H -- COMMUNICATION ADAPTER
	DW	OFFSET CASSETTE_IO	; INT 15H -- EXPANDED BIOS FUNCTION CALL
	DW	OFFSET KEYBOARD_IO	; INT 16H -- KEYBOARD INPUT
	DW	OFFSET PRINTER_IO	; INT 17H -- PRINTER OUTPUT
	DW	00000H			; INT 18H -- 0F600H INSERTED FOR BASIC
	DW	OFFSET BOOT_STRAP	; INT 19H -- BOOT FROM SYSTEM MEDIA
	DW	OFFSET TIME_OF_DAY	; INT 1AH -- TIME OF DAY
	DW	OFFSET DUMMY_RETURN	; INT 1BH -- KEYBOARD BREAK ADDRESS
	DW	OFFSET DUMMY_RETURN	; INT 1CH -- TIMER BREAK ADDRESS
	DW	OFFSET VIDEO_PARMS	; INT 1DH -- VIDEO PARAMETERS
	DW	OFFSET DISK_BASE	; INT 1EH -- DISKETTE PARAMETERS
	DW	00000H			; INT 1FH -- POINTER TO VIDEO EXTENSION

SLAVE_VECTOR_TABLE	LABEL WORD	; ( INTERRUPT 70H THRU 7FH )

	DW	OFFSET RTC_INT		; INT 70H - REAL TIME CLOCK	  IRQ  8
	DW	OFFSET RE_DIRECT	; INT 71H - REDIRECT TO INT 0AH   IRQ  9
	DW	OFFSET	D11		; INT 72H -			  IRQ 10
	DW	OFFSET	D11		; INT 73H -			  IRQ 11
	DW	OFFSET	D11		; INT 74H -			  IRQ 12
	DW	OFFSET INT_287		; INT 75H -  -MATH COPROCESSOR	  IRQ 13
	DW	OFFSET	D11		; INT 76H -  -FIXED DISK	  IRQ 14
	DW	OFFSET	D11		; INT 77H -			  IRQ 15

;-----	DUMMY INTERRUPT HANDLER

;;-	ORG	0FF53H
	ORG	01F53H

DUMMY_RETURN	EQU	$		; BIOS DUMMY (NULL) INTERRUPT RETURN

	IRET

;-----	PRINT SCREEN

;;-	ORG	0FF54H
	ORG	01F54H
PRINT_SCREEN	EQU	$
	JMP	PRINT_SCREEN_1		; VECTOR ON TO MOVED BIOS CODE
.XLIST
;;-	ORG	0FF5AH
	ORG	01F5AH

HRD	PROC	FAR
	CALL	DISK_SETUP
	RET
HRD	ENDP

FLOPPY	PROC	FAR
	CALL	DSKETTE_SETUP
	RET
FLOPPY	ENDP

SEEKS_1 PROC	FAR
	CALL	SEEK
	RET
SEEKS_1 ENDP

TUTOR:
	JMP	K16
.LIST
;----------------------------------------
;					:
;	POWER ON RESET VECTOR		:
;					:
;----------------------------------------
;;-	ORG	0FFF0H
	ORG	01FF0H

;-----	POWER ON RESET

P_O_R	LABEL  FAR			; POWER ON RESTART EXECUTION LOCATION

	DB	0EAH			; HARD CODE FAR JUMP TO SET
	 DW	 OFFSET  RESET		;  OFFSET
	 DW	 0F000H 		;   SEGMENT

	DB	'04/21/86'              ; RELEASE MARKER

	ORG	01FFEH
	DB	MODEL_BYTE		; THIS PC'S ID ( MODEL BYTE )

CODE	ENDS				; CHECKSUM AT LAST LOCATION
	END
