TITLE 01/03/84 TEST6 POWER ON SELF TEST
.XLIST
INCLUDE DSEG.SRC
INCLUDE POSTEQU.SRC
INCLUDE SYSDATA.INC
.LIST
PUBLIC	STGTST_CNT
PUBLIC	ROM_ERR
PUBLIC	BOOT_STRAP_1
PUBLIC	XMIT_8042
PUBLIC	POST6
PUBLIC	H5

INCLUDE SEGMENT.SRC
;
EXTRN	E0:NEAR
EXTRN	E_MSG:NEAR
EXTRN	KBD_RESET:NEAR
EXTRN	XPC_BYTE:NEAR
EXTRN	F1:NEAR
EXTRN	VECTOR_TABLE:NEAR
EXTRN	NMI_INT:NEAR
EXTRN	PRINT_SCREEN:NEAR
EXTRN	BLINK_INT:NEAR
EXTRN	PRT_HEX:NEAR
EXTRN	F3B:NEAR
EXTRN	PRT_SEG:NEAR
EXTRN	XPC_BYTE:NEAR
EXTRN	E1:NEAR
EXTRN	ROM_CHECK:NEAR
EXTRN	ROS_CHECKSUM:NEAR
EXTRN	SEEK:NEAR
EXTRN	F3:NEAR
EXTRN	ERR_BEEP:NEAR
EXTRN	P_MSG:NEAR
EXTRN	START_1:NEAR
EXTRN	F4:NEAR
EXTRN	F4E:NEAR
EXTRN	DDS:NEAR
EXTRN	F3A:NEAR
EXTRN	DISK_BASE:NEAR
EXTRN	F3D:NEAR
EXTRN	PROC_SHUTDOWN:NEAR
EXTRN	SYSINIT1:NEAR
EXTRN	PROT_PRT_HEX:NEAR
EXTRN	DISK_IO:NEAR
EXTRN	HD_INT:NEAR
EXTRN	C8042:NEAR
EXTRN	BOOT_INVA:NEAR
PAGE
	ASSUME	CS:CODE
	ASSUME	DS:DATA

POST6	PROC	NEAR

;----------------------------------------------------------------
; THIS SUBROUTINE PERFORMS A READ/WRITE STORAGE TEST ON A BLOCK :
;	OF STORAGE.						:
; ENTRY REQUIREMENTS:						:
;	ES = ADDRESS OF STORAGE SEGMENT BEING TESTED		:
;	DS = ADDRESS OF STORAGE SEGMENT BEING TESTED		:
;	CX = WORD COUNT OF STORAGE BLOCK TO BE TESTED		:
; EXIT PARAMETERS:						:
;	ZERO FLAG = 0 IF STORAGE ERROR (DATA COMPARE OR PARITY	:
;	CHECK). AL=0 DENOTES A PARITY CHECK. ELSE AL=XOR'ED     :
;	BIT PATTERN OF THE EXPECTED DATA PATTERN VS THE ACTUAL	:
;	DATA READ.						:
; AX,BX,CX,DX,DI, AND SI ARE ALL DESTROYED.			:
;----------------------------------------------------------------

STGTST_CNT	PROC	NEAR
	MOV	BX,CX			; SAVE WORD COUNT OF BLOCK TO TEST
	IN	AL,PORT_B
	JMP	SHORT $+2		; IO DELAY
	OR	AL,RAM_PAR_OFF		; TOGGLE PARITY CHECK LATCHES
	OUT	PORT_B,AL
	JMP	SHORT $+2		; IO DELAY
	AND	AL,RAM_PAR_ON		;
	OUT	PORT_B,AL

;-------- ROLL A BIT THROUGH THE FIRST WORD

	MOV	DX,0001H		; WRITE THE INIT DATA PATTERN
	MOV	CX,16			; ROLL 16 BIT POSITIONS
C1:	SUB	DI,DI			; START AT BEGINING OF BLOCK
	SUB	SI,SI			; INITIALIZE DESTINATION POINTER
	MOV	AX,DX			; GET THE PATTERN
	STOSW				; STORE DATA PATTERN
	SUB	SI,SI			; START AT BEGINNING
	LODSW				; GET THE FIRST WRITTEN
	XOR	AX,DX			; INSURE DATA AS EXPECTED
	JZ	C1_A			;
	JMP	C13			; EXIT IF NOT
C1_A:	SHL	DX,1			; SHIFT BIT TO NEXT BIT POSITION
	LOOP	C1			; LOOP TILL DONE

;-------- CHECK CAS LINES FOR HIGH BYTE LOW BYTE

	SUB	DI,DI			; START AT BEGINNING OF BLOCK
	SUB	SI,SI			; INITIALIZE DESTINATION POINTER
	SUB	AX,AX			; WRITE 0
	MOV	DX,0FF00H		;
	STOSW				; STORE DATA PATTERN
	MOV	DI,1			; AT THE FIRST ODD LOCATION
	MOV	BYTE PTR [DI],0FFH	; WRITE A BYTE OF FFH
	SUB	DI,DI
	MOV	AX,WORD PTR [DI]	; GET THE DATA
	XOR	AX,DX			; CHECK THE FIRST WRITTEN
	JZ	C1_B
	JMP	C13			; EXIT IF NOT

C1_B:	SUB	DI,DI			; START AT BEGINNING OF BLOCK
	SUB	AX,AX			; WRITE 0
	MOV	DX,000FFH		;
	STOSW				; STORE DATA PATTERN
	SUB	DI,DI			; AT THE FIRST EVEN LOCATION
	MOV	BYTE PTR [DI],0FFH	; WRITE A BYTE OF FFH
	SUB	DI,DI			; BUS SETTLE
	MOV	AX,WORD PTR [DI]	; GET THE DATA
	XOR	AX,DX			; CHECK THE FIRST WRITTEN
	JNZ	C13			; EXIT IF NOT

;------- TEMP SAVE FOR AX (PUSH NOT ALLOWED)

	OUT	DMA_PAGE+8,AL		; SAVE AX
	XCHG	AL,AH			;
	JMP	SHORT $+2		;
	OUT	DMA_PAGE+9,AL		;

;-------- CHECK IO OR BASE RAM

	IN	AL,PORT_B		; CHECK FOR IO/PAR CHECK
	AND	AL,PARITY_ERR		; STRIP UNWANTED BITS
	XCHG	AL,AH			; SAVE ERROR
	IN	AL,DMA_PAGE+6		; CHECK FOR R/W OR IO ERR
	AND	AH,AL			;

;------- RESTORE AX

	IN	AL,DMA_PAGE+9		; GET AH
	XCHG	AL,AH			;
	IN	AL,DMA_PAGE+8		; GET AL

;-------- PARITY ERROR EXIT

	JNZ	C13			; GO IF YES
	MOV	DX,0AA55H		; WRITE THE INIT DATA PATTERN
C3:	SUB	DI,DI			; START AT BEGINING OF BLOCK
C4:	SUB	SI,SI			; INITIALIZE DESTINATION POINTER
	MOV	CX,BX			; SETUP BYTE COUNT FOR LOOP
	MOV	AX,DX			; GET THE PATTERN
C5:	REP	STOSW			; STORE 64K BYTES (32K WORDS)
	MOV	CX,BX			; SET COUNT
	SUB	SI,SI			; START AT BEGINNING
C6:	LODSW				; GET THE FIRST WRITTEN
	XOR	AX,DX			; INSURE DATA AS EXPECTED
	JNZ	C13			; EXIT IF NOT
	LOOP	C6			; LOOP TILL DONE

;------- TEMP SAVE FOR AX (PUSH NOT ALLOWED)

	OUT	DMA_PAGE+8,AL		; SAVE AX
	XCHG	AL,AH			;
	JMP	SHORT $+2		;
	OUT	DMA_PAGE+9,AL		;

;-------- CHECK IO OR BASE RAM

	IN	AL,PORT_B		; CHECK FOR IO/PAR CHECK
	AND	AL,PARITY_ERR		; STRIP UNWANTED BITS
	XCHG	AL,AH			; SAVE ERROR
	IN	AL,DMA_PAGE+6		; CHECK FOR R/W OR IO ERR
	AND	AH,AL			;

;------- RESTORE AX

	IN	AL,DMA_PAGE+9		; GET AH
	XCHG	AL,AH			;
	IN	AL,DMA_PAGE+8		; GET AL

;-------- PARITY ERROR EXIT

	JNZ	C13			; GO IF YES

;------- CHECK FOR END OF 64K BLOCK

	AND	DX,DX			; ENDING ZERO PATTERN WRITTEN TO STG?
	JZ	C14			; YES - RETURN TO CALLER WITH AL=0

;------- SETUP NEXT PATTERN
	CMP	DX,055AAH		; CHECK IF LAST PATTERN =55AA
	JZ	C9			; GO IF NOT
	CMP	DX,0101H		; LAST PATTERN 0101?
	JZ	C10			; GO IF YES
	MOV	DX,055AAH		; WRITE 55AA TO STORAGE
	JMP	C3

;-------- LAST PATTERN = 0000

C8:	SUB	DX,DX			; WRITE 0000 TO STORAGE
	JMP	C3			;

;-------- INSURE PARITY BITS ARE NOT STUCK ON

C9:	MOV	DX,0101H		; WRITE 0101 TO STORAGE
	JMP	C3

;-------- EXIT

C13:
C14:	RET

;------- CHECKER BOARD TEST

C10:	SUB	DI,DI			; POINT TO START OF BLOCK
	MOV	CX,BX			; GET THE BLOCK COUNT
	SHR	CX,1			; DIVIDE BY 2
C11:	MOV	AX,0101010101010101B	; FIRST CHECKER PATTERN
	STOSW				; WRITE IT
	MOV	AX,1010101010101010B	; SECOND CHECKER PATTERN
	STOSW				; WRITE IT
	LOOP	C11			; DO IT FOR CX COUNT
	SUB	SI,SI			; POINT TO START OF BLOCK
	MOV	CX,BX			; GET THE BLOCK COUNT
	SHR	CX,1			; DIVIDE BY 2
C12:	LODSW				; GET THE DATA
	XOR	AX,0101010101010101B	; CHECK CORRECT
	JNZ	C13			; EXIT IF NOT
	LODSW				; GET NEXT DATA
	XOR	AX,1010101010101010B	;
	JNZ	C13			; GO IF NOT CORRECT
	LOOP	C12			; CONTINUE TILL DONE

;------- TEMP SAVE FOR AX (PUSH NOT ALLOWED)

	OUT	DMA_PAGE+8,AL		; SAVE AX
	XCHG	AL,AH			;
	JMP	SHORT $+2		;
	OUT	DMA_PAGE+9,AL		;

;-------- CHECK IO OR BASE RAM

	IN	AL,PORT_B		; CHECK FOR IO/PAR CHECK
	AND	AL,PARITY_ERR		; STRIP UNWANTED BITS
	XCHG	AL,AH			; SAVE ERROR
	IN	AL,DMA_PAGE+6		; CHECK FOR R/W OR IO ERR
	AND	AH,AL			;

;------- CHECKPOINT 32 FOR ADDRESS LINE 0->15 FAILURE

	MOV	AL,32H			; <><><><><><><><><><><><><>
	OUT	MFG_PORT,AL		; <><><>CHECKPOINT 32 <><><>

;------- RESTORE AX

	IN	AL,DMA_PAGE+9		; GET AH
	XCHG	AL,AH			;
	IN	AL,DMA_PAGE+8		; GET AL

;-------- PARITY ERROR EXIT

	JNZ	C13			; GO IF YES

;------- 64K ADDRESS TEST AND FILL WITH ZERO

	SUB	DI,DI			; POINT TO START OF BLOCK
	MOV	CX,BX			; GET THE BLOCK COUNT
	SUB	CX,2			; DO ALL LOCATIONS BUT LAST
	MOV	AX,0FFFFH
	STOSW				; WRITE FIRST LOCATION AS FFFFH
	SUB	AX,AX			; WRITE ZERO
	REP	STOSW			; WRITE IT
	MOV	AX,0FFFFH		; LAST WORD IS FFFF
	STOSW
	SUB	SI,SI			; POINT TO START OF BLOCK
	MOV	CX,BX			; GET THE BLOCK COUNT
	SUB	CX,2
	LODSW				; GET THE DATA
	XOR	AX,0FFFFH		; CHECK CORRECT
	JNZ	C13A			; EXIT IF NOT
C12A:	LODSW				; GET NEXT DATA
	XOR	AX,00000H		; ANY BIT ON ?
	JNZ	C13A			; GO IF NOT CORRECT
	LOOP	C12A			; CONTINUE TILL LAST WORD
	LODSW				; GET LAST WORD
	XOR	AX,0FFFFH		; S/B FFFF
	JNZ	C13A			; EXIT IF NOT

;------- CLEAR WORD 0 AND FFFE

	SUB	DI,DI			; CLEAR FIRST WORD
	STOSW
	MOV	DI,0FFFEH		; CLEAR TOP WORD
	STOSW

;------- TEMP SAVE FOR AX (PUSH NOT ALLOWED)

	OUT	DMA_PAGE+8,AL		; SAVE AX
	XCHG	AL,AH			;
	JMP	SHORT $+2		;
	OUT	DMA_PAGE+9,AL		;

;-------- CHECK IO OR BASE RAM

	IN	AL,PORT_B		; CHECK FOR IO/PAR CHECK
	AND	AL,PARITY_ERR		; STRIP UNWANTED BITS
	XCHG	AL,AH			; SAVE ERROR
	IN	AL,DMA_PAGE+6		; CHECK FOR R/W OR IO ERR
	AND	AH,AL			;

;------- RESTORE AX

	IN	AL,DMA_PAGE+9		; GET AH
	XCHG	AL,AH			;
	IN	AL,DMA_PAGE+8		; GET AL

;-------- PARITY ERROR EXIT

	JNZ	C13A			; GO IF YES

	JMP	C13			; ERROR EXIT IF ZF NOT SET
C13A:
	JMP	C13			; ERROR EXIT IF ZF NOT SET
STGTST_CNT	ENDP
PAGE
;------------------------------------------------------------------------
;  PRINT ADDRESS AND ERROR MESSAGE FOR ROM CHECKSUM ERRORS		:
;------------------------------------------------------------------------
ROM_ERR PROC	NEAR
	PUSH	DX			; SAVE POINTER
	PUSH	ES
	PUSH	AX
	MOV	AX,DATA 		; SET ES TO DATA SEGMENT
	MOV	ES,AX
	POP	AX			; RESTORE AX
	PUSH	AX
	MOV	DX,DS			; GET ADDRESS POINTER
	MOV	ES:MFG_ERR_FLAG,DH	; <><><><><><><><><><><><><><><>
					; <><><>CHECKPOINTS C0->F4<><><>
	CMP	DX,0C800H		; DISPLAY CARD IN ERROR?
	JL	ROM_ERR_BEEP		; GIVE DISPLAY CARD FAIL BEEP
	CALL	PRT_SEG 		; PRINT SEGMENT IN ERROR
	MOV	SI,OFFSET F3A		; DISPLAY ERROR MESSAGE
	CALL	E_MSG
ROM_ERR_END:
	POP	AX
	POP	ES
	POP	DX
	RET
ROM_ERR_BEEP:
	MOV	DX,0102H		; BEEP 1 LONG, 2 SHORT
	CALL	ERR_BEEP
	JMP	SHORT ROM_ERR_END
ROM_ERR ENDP
;--------------------------------------------------------------------
; THIS SUBROUTINE SENDS AN OUTPUT COMMAND TO THE KEYBOARD AND	    :
;	RECEIVES THE KEYBOARD RESPONSE. 			    :
; ENTRY REQUIREMENTS:						    :
;	AL = COMMAND/DATA TO BE SENT				    :
; EXIT PARAMETERS:						    :
;	ZERO FLAG = 1 IF ACK RECEIVED FROM THE KEYBOARD 	    :
;	AL = RESPONSE						    :
;--------------------------------------------------------------------
XMIT_8042 PROC	NEAR

;------ CHECK INPUT BUFFER FULL

	XCHG	AH,AL			; SAVE COMMAND
	SUB	CX,CX			; SET LOOP TIME-OUT
XMITLOOP:
	IN	AL,STATUS_PORT
	TEST	AL,INPT_BUF_FULL	; CHECK INPUT BUFFER FULL
	LOOPNZ	XMITLOOP
	JCXZ	SHORT XMIT_EXIT
	XCHG	AH,AL			; RESTORE COMMAND

;------ ISSUE THE COMMAND

	OUT	PORT_A,AL		; SEND THE COMMAND
	SUB	CX,CX			; SET LOOP COUNT

;------ CHECK OUTPUT BUFFER FULL

XMIT_1: IN	AL,STATUS_PORT
	MOV	AH,AL			; SAVE STATUS
	TEST	AL,OUT_BUF_FULL 	; CHECK IF 8042 HAS DATA
	JZ	XMIT_2			; GO IF NOT
	IN	AL,PORT_A		; FLUSH DATA
XMIT_2: TEST	AH,INPT_BUF_FULL	; CHECK COMMAND ACCEPTED
	LOOPNZ	XMIT_1
	JNZ	SHORT XMIT_EXIT 	; NO FLUSH OR COMMAND NOT ACCEPTED

;------ CHECK OUTPUT BUFFER FULL

	MOV	BL,6			; SET COUNT
	SUB	CX,CX			; SET LOOP COUNT
XMIT_3: IN	AL,STATUS_PORT
	TEST	AL,OUT_BUF_FULL 	; CHECK IF HAS DATA
	LOOPZ	XMIT_3			; WAIT TILL DONE
	JNZ	XMIT_4
	DEC	BL			; DECREMENT OUTER LOOP
	JNZ	SHORT XMIT_3		; TRY AGAIN
	INC	BL			; SET ERROR FLAG
	JMP	SHORT XMIT_EXIT 	; 8042 STUCK BUSY

;------ GET THE DATA

XMIT_4: SUB	CX,CX			; ALLOW TIME FOR POSSIBLE
					; ERROR -> SYSTEM UNIT OR KEYBOARD
XMIT_5: LOOP	XMIT_5
	IN	AL,PORT_A
	SUB	CX,01H			; SET CX OTHER THAN ZERO
XMIT_EXIT:
	RET
XMIT_8042 ENDP

;--- BOOT_STRAP -- INT	19H ---------------------------
; BOOT STRAP LOADER				      :
;	TRACK 0, SECTOR 1 IS READ INTO THE	      :
;	BOOT LOCATION (SEGMENT 0 OFFSET 7C00)	      :
;	AND CONTROL IS TRANSFERRED THERE.	      :
;						      :
;	IF THERE IS A HARDWARE ERROR CONTROL IS       :
;	TRANSFERRED TO THE ROM BASIC ENTRY POINT      :
;------------------------------------------------------
	ASSUME CS:CODE,DS:ABS0

BOOT_STRAP_1	PROC	NEAR

	SUB	AX,AX			; ESTABLISH ADDRESSING
	MOV	DS,AX

;------ RESET THE DISK PARAMETER TABLE VECTOR

	MOV	WORD PTR DISK_POINTER, OFFSET DISK_BASE
	MOV	WORD PTR DISK_POINTER+2,CS

;------ CLEAR BOOT_LOCN

	MOV	CX,256			; CLEAR 256 WORDS
	MOV	BX,OFFSET BOOT_LOCN
H0:	MOV	[BX],AX
	ADD	BX,2
	LOOP	H0

;------ LOAD SYSTEM FROM DISKETTE -- CX HAS RETRY COUNT

	STI
	MOV	CX,4			; SET RETRY COUNT
H1:	PUSH	CX			; IPL SYSTEM
	MOV	AH,0			; RESET THE DISKETTE SYSTEM
	INT	13H			; DISKETTE_IO
	JC	H2			; IF ERROR, TRY AGAIN

	MOV	AX,201H 		; READ IN THE SINGLE SECTOR
	SUB	DX,DX			; TO THE BOOT LOCATION
	MOV	ES,DX
	MOV	BX,OFFSET BOOT_LOCN	; DRIVE 0, HEAD 0
	MOV	CX,1			; SECTOR 1, TRACK 0
	INT	13H			; DISKETTE_IO
H2:	POP	CX			; RECOVER RETRY COUNT
	JNC	H4			; CARRY FLAG SET BY UNSUCCESSFUL READ
	CMP	AH,80H			; IF TIME OUT, NO RETRY
	JZ	H5			; TRY FIXED DISK
	LOOP	H1			; DO IT FOR RETRY TIMES
	JMP	H5			; TRY FIXED DISK

;------ BOOT RECORD READ SUCCESSFUL
;------ INSURE FIRST BYTE OF LOADED BOOT RECORD IS VALID (NOT ZERO)

H4:	CMP	WORD PTR BOOT_LOCN,00H	; CHECK FOR FIRST INSTRUCTION INVALID
	JE	H10			; IF BOOT NOT VALID PRINT MESSAGE HALT

;------ INSURE DATA PATTERN FIRST 10 WORDS NOT ALL EQUAL

	MOV	DI,OFFSET BOOT_LOCN	; CHECK DATA PATTERN
	MOV	CX,10			; CHECK THE NEXT 10 WORDS
	MOV	AX,WORD PTR BOOT_LOCN

H4A:	ADD	DI,2			; POINT TO NEXT LOCATION
	CMP	AX,[DI] 		; CHECK DATA PATTERN FOR A FILL PATTERN
	LOOPZ	H4A
	JZ	H10			; BOOT NOT VALID PRINT MESSAGE HALT

H4_A:	JMP	BOOT_LOCN

;------ ATTEMPT BOOTSTRAP FROM FIXED DISK

H5:	MOV	AL,044H 		; <><><><><><><><><><><><><>
	OUT	MFG_PORT,AL		; <><><>CHECKPOINT 44 <><><>
	ASSUME	DS:DATA
	CALL	DDS
	TEST	HF_CNTRL,DUAL		; FLOPPY/FIXED DISK CARD INSTALLED
	ASSUME	DS:ABS0
	MOV	AX,ABS0 		; ESTABLISH ADDRESSING
	MOV	DS,AX
	JZ	H9			; GO IF NOT

;------ CHECK FOR FIXED DISK INITIALIZATION ERROR

	MOV	AL,DIAG_STATUS		; GET POST POWER ON STATUS (NMI ENABLED)
	AND	AL,07FH
	OUT	CADR_PRT,AL
	JMP	SHORT $+2
	IN	AL,CDATA_PRT
	TEST	AL,HF_FAIL		; DID WE HAVE A FIXED DISK FAILURE?
	JNZ	H9			; GO IF YES

	SUB	AX,AX			; RESET DISKETTE
	SUB	DX,DX
	INT	13H
	MOV	CX,3			; RETRY COUNT
H6:
	PUSH	CX			; SAVE RETRY COUNT
	MOV	DX,0080H		; FIXED DISK ZERO
	MOV	AX,0201H		; READ IN A SINGLE SECTOR
	SUB	BX,BX
	MOV	ES,BX
	MOV	BX,OFFSET BOOT_LOCN	; TO THE BOOT LOCATION
	MOV	CX,1			; SECTOR 1, TRACK 0
	INT	13H			; FILE I/O CALL
	POP	CX			; RECOVER RETRY COUNT
	JC	H8
	CMP	WORD PTR BOOT_LOCN+510D,0AA55H ; TEST FOR GENERIC BOOT BLOCK
	JZ	H4_A

H8:	PUSH	CX
	MOV	DX,0080H		; FIXED DISK ZERO
	SUB	AX,AX			; RESET THE FIXED DISK
	INT	13H			; FILE I/O CALL
	POP	CX			; RESTORE LOOP COUNT
	JC	H10A			; IF ERROR, TRY AGAIN
	LOOP	H6			; DO IT FOR RETRY TIMES

;------ UNABLE TO IPL FROM THE DISKETTE OR FIXED DISK

H9:	MOV	AL,045H 		; <><><><><><><><><><><><><>
	OUT	MFG_PORT,AL		; <><><>CHECKPOINT 45 <><><>

	INT	18H			; GO TO RESIDENT BASIC

;------ HARD FILE RESET FAILURE

H10A:	LOOP	H8			; TRY RESET AGAIN
	JMP	H9			; GO TO RESIDENT BASIC

;------ IF DISKETTE READ OK BUT BOOT RECORD IS NOT STOP SYSTEM ALLOW SOFT RESET

H10:	MOV	SI,OFFSET BOOT_INVA	; PRINT DISKETTE BOOT
	CALL	E_MSG			; PRINT MESSAGE
H11:	JMP	H11
BOOT_STRAP_1	ENDP
POST6	ENDP
CODE	ENDS
	END
