/*
    filename:  fexrt.h      (Feature EXtraction ReTrieve functions)

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_FEXRT_H__
#define __I_FEXRT_H__

typedef unsigned short OBJECT;
typedef unsigned short BUFFER_ID;


/****************************************************************************/
/* CONTROL FUNCTION DEFINES                                                 */
/****************************************************************************/


/****************************************************************************/
/* RETRIEVE FUNCTION DEFINES                                                */
/****************************************************************************/


#define  ZERO_MOMENTS          0 


       /* define the storage type */
#define  I_LOCAL               0
#define  I_HOST                1

       /* define the precision */
#define  I_SP_FORMAT           0  /* single precision format */
#define  I_DP_FORMAT           0  /* double precision format */
#define  I_NORM                0

#define  OK                    1
#define  I_TRUE                1
#define  I_FALSE               0

#define  I_TYPE_SHORT          0
#define  I_TYPE_LONG           1
#define  I_TYPE_FLOAT          2

  /* offsets from the begining of the object field in the list */
  /* Note that the offsets are given for single floating point precission */
  /* it is assumed that the area is allocated as long */
#define   I_LABEL          0  /*    0   unsigned short */
#define   I_AREA           1  /*   16   unsigned long  */
#define   I_PERIMETER      3  /*   48   unsigned long  */
#define   I_FERET_X        5  /*   80   float         */
#define   I_FIRST_POINT_X  7  /*  112   float         */
#define   I_BOX_MIN_X      9  /*  144   float         */
#define   I_BOX_MAX_X     11  /*  176   float         */
#define   I_FERET_Y       13  /*  208   float         */
#define   I_FIRST_POINT_Y 15  /*  240   float         */
#define   I_BOX_MIN_Y     17  /*  272   float         */
#define   I_BOX_MAX_Y     19  /*  304   float         */
#define   I_X_GRAVITY     21  /*  336   float         */
#define   I_Y_GRAVITY     23  /*  368   float         */
#define   I_INTERCEPT1    25  /*  400   unsigned long  */
#define   I_INTERCEPT2    27  /*  432   unsigned long  */
#define   I_INTERCEPT3    29  /*  464   unsigned long  */
#define   I_INTERCEPT4    31  /*  496   unsigned long  */
#define   I_AXIS_SYMMETRY 33  /*  528   float         */
#define   I_COMPACTNESS   35  /*  560   float         */

      /* offsets for moments */
#define   I_M10           37  /*  592   float         */
#define   I_M01           39  /*  624   float         */
#define   I_M11           41  /*  656   float         */
#define   I_MC20          43  /*  688   float         */
#define   I_MC02          45  /*  720   float         */
#define   I_MC11          47  /*  752   float         */


#define   I_USER_FIELDS   49  /*  784  unsigned long */

#define   I_MASS      I_AREA /* I_MASS replaces I_AREA */

#endif /* __I_FEXRT_H__ */
