#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstdmode
*/ 

extern unsigned long i_buff[];

#ifdef ANSI
void FTYPE lsdcstdmode(unsigned long p0)
#else
FTYPE lsdcstdmode(p0)
unsigned long p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTDMODE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstrgb555
*/ 


#ifdef ANSI
void FTYPE lsdcstrgb555(unsigned long p0)
#else
void FTYPE lsdcstrgb555(p0)
unsigned long p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTRGB555);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstrgb888
*/ 


#ifdef ANSI
void FTYPE lsdcstrgb888(unsigned long p0, unsigned long p1, unsigned long p2)
#else
FTYPE lsdcstrgb888(p0, p1, p2)
unsigned long p0;
unsigned long p1;
unsigned long p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTRGB888);
    *p++ = p0;
    *p++ = p1;
    *p++ = p2;

    ioputbuf((short *) i_buff, 8);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstopal
*/ 

#ifdef ANSI
void FTYPE lsdcstopal(unsigned short p0)
#else
FTYPE lsdcstopal(p0)
unsigned short p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTOPAL);
    *p++ = (unsigned long) p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstomask
*/ 
          

#ifdef ANSI
void FTYPE lsdcstomask(unsigned short p0, unsigned short p1,
                       unsigned short p2, unsigned short p3)
#else
FTYPE lsdcstomask(p0, p1, p2, p3)
unsigned short p0;
unsigned short p1;
unsigned short p2;
unsigned short p3;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTOMASK);
    *p++ = (unsigned long) p0;
    *p++ = (unsigned long) p1;
    *p++ = (unsigned long) p2;
    *p++ = (unsigned long) p3;

    ioputbuf((short *) i_buff, 10);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstfbmplane
*/ 


#ifdef ANSI
void FTYPE lsdcstfbmplane(unsigned short p0)
#else
FTYPE lsdcstfbmplane(p0)
unsigned short p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTFBMPLANE);
    *p++ = (unsigned long) p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstovrsource
*/ 


#ifdef ANSI
void FTYPE lsdcstovrsource(unsigned long p0)
#else
FTYPE lsdcstovrsource(p0)
unsigned long p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTOVRSOURCE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstmsbsource
*/ 


#ifdef ANSI
void FTYPE lsdcstmsbsource(unsigned long p0)
#else
FTYPE lsdcstmsbsource(p0)
unsigned long p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTMSBSOURCE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstpzscroll
*/ 


#ifdef ANSI
void FTYPE lsdcstpzscroll(unsigned short p0, unsigned long p1,
                          unsigned long p2, unsigned short p3,
                          unsigned short p4, unsigned short p5)
#else   
FTYPE lsdcstpzscroll(p0, p1, p2, p3, p4, p5)
unsigned short p0;
unsigned long p1;
unsigned long p2;
unsigned short p3;
unsigned short p4;
unsigned short p5;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTPZSCROLL);
    *p++ = (unsigned long) p0;
    *p++ = p1;
    *p++ = p2;
    *p++ = (unsigned long) p3;
    *p++ = (unsigned long) p4;
    *p++ = (unsigned long) p5;

    ioputbuf((short *) i_buff, 14);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstwactive
*/ 

#ifdef ANSI
void FTYPE lsdcstwactive(unsigned short p0, unsigned short p1,
                         unsigned short p2, unsigned short p3)
#else
FTYPE lsdcstwactive(p0, p1, p2, p3)
unsigned short p0;
unsigned short p1;
unsigned short p2;
unsigned short p3;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTWACTIVE);
    *p++ = (unsigned long) p0;
    *p++ = (unsigned long) p1;
    *p++ = (unsigned long) p2;
    *p++ = (unsigned long) p3;

    ioputbuf((short *) i_buff, 10);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstbgcolor
*/ 


#ifdef ANSI
void FTYPE lsdcstbgcolor(unsigned short p0, unsigned short p1,
                         unsigned short p2)
#else
FTYPE lsdcstbgcolor(p0, p1, p2)
unsigned short p0;
unsigned short p1;
unsigned short p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTBDCOLOR);
    *p++ = (unsigned long) p0;
    *p++ = (unsigned long) p1;
    *p++ = (unsigned long) p2;

    ioputbuf((short *) i_buff, 8);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstbdcolor
*/ 


#ifdef ANSI
void FTYPE lsdcstbdcolor(unsigned short p0, unsigned short p1,
                         unsigned short p2)
#else
FTYPE lsdcstbdcolor(p0, p1, p2)
unsigned short p0;
unsigned short p1;
unsigned short p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTBDCOLOR);
    *p++ = (unsigned long) p0;
    *p++ = (unsigned long) p1;
    *p++ = (unsigned long) p2;

    ioputbuf((short *) i_buff, 8);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcinitvdo
*/ 


#ifdef ANSI
void FTYPE lsdcinitvdo(void)
#else
FTYPE lsdcinitvdo()
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCINITVDO);

    ioputbuf((short *) i_buff, 2);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstbdmode
*/ 


#ifdef ANSI
void FTYPE lsdcstbdmode(long p0)
#else
FTYPE lsdcstbdmode(p0)
long    p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTBDMODE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstaosource
*/ 


#ifdef ANSI
void FTYPE lsdcstaosource(long p0)
#else
FTYPE lsdcstaosource(p0)
long    p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTAOSOURCE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstportrait
*/ 


#ifdef ANSI
void FTYPE lsdcstportrait(long p0)
#else
FTYPE lsdcstportrait(p0)
long    p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTPORTRAIT);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstvgamode
*/ 


#ifdef ANSI
void FTYPE lsdcstvgamode(unsigned short p0)
#else
FTYPE lsdcstvgamode(p0)
unsigned short p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTVGAMODE);
    *p++ = (unsigned long) p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstunderlay
*/ 


#ifdef ANSI
void FTYPE lsdcstunderlay(long p0)
#else
FTYPE lsdcstunderlay(p0)
long    p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTUNDERLAY);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* ----------------------------- to be removed ------------------------- */

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstcropping
*/ 


#ifdef ANSI
void FTYPE lsdcstcropping(long p0)
#else
FTYPE lsdcstcropping(p0)
long    p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTBDMODE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstcropsource
*/ 


#ifdef ANSI
void FTYPE lsdcstcropsource(long p0)
#else
FTYPE lsdcstcropsource(p0)
long    p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTAOSOURCE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstrdmask
*/ 


#ifdef ANSI
void FTYPE lsdcstrdmask(short p0, short p1, short p2, short p3, short p4, short p5)
#else
FTYPE lsdcstrdmask(p0, p1, p2, p3, p4, p5)
short   p0;
short   p1;
short   p2;
short   p3;
short   p4;
short   p5;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTRDMASK);
    *p++ = (long) p0;
    *p++ = (long) p1;
    *p++ = (long) p2;
    *p++ = (long) p3;
    *p++ = (long) p4;
    *p++ = (long) p5;

    ioputbuf((short *) i_buff, 14);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstrdmask
*/ 


#ifdef ANSI
void FTYPE lsdcstsyncgun ( short p0, short p1, short p2 )
#else
FTYPE lsdcstsyncgun ( p0, p1, p2 )
short   p0;
short   p1;
short   p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTSYNCGUN);
    *p++ = (long) p0;
    *p++ = (long) p1;
    *p++ = (long) p2;

    ioputbuf((short *) i_buff, 8);
} /* lsdcstsyncgun () */


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstviewprg
*/ 


#ifdef ANSI
void FTYPE lsdcstviewprg(unsigned long p0)
#else
FTYPE lsdcstviewprg(p0)
unsigned long p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTVIEWPRG);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstviewmode
*/ 


#ifdef ANSI
void FTYPE lsdcstviewmode(long p0)
#else
FTYPE lsdcstviewmode(p0)
long p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTVIEWMODE);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstviewcpy
*/ 


#ifdef ANSI
void FTYPE lsdcstviewcpy(unsigned long p0, unsigned long p1)
#else
FTYPE lsdcstviewcpy(p0, p1)
unsigned long p0;
unsigned long p1;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTVIEWCPY);
    *p++ = p0;
    *p++ = p1;

    ioputbuf((short *) i_buff, 6);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstviewseg
*/ 


#ifdef ANSI
void FTYPE lsdcstviewseq(long p0, long p1, long p2)
#else
FTYPE lsdcstviewseq(p0, p1, p2)
long p0;
long p1;
long p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTVIEWSEQ);
    *p++ = p0;
    *p++ = p1;
    *p++ = p2;

    ioputbuf((short *) i_buff, 8);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstinterlut
*/ 


#ifdef ANSI
void FTYPE lsdcstinterlut(unsigned long p0, unsigned long p1, unsigned long p2)
#else
FTYPE lsdcstinterlut(p0, p1, p2)
unsigned long p0;
unsigned long p1;
unsigned long p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTINTERLUT);
    *p++ = p0;
    *p++ = p1;
    *p++ = p2;

    ioputbuf((short *) i_buff, 8);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstalpha
*/ 


#ifdef ANSI
void FTYPE lsdcstalpha(unsigned long p0)
#else
FTYPE lsdcstalpha(p0)
unsigned long p0;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTALPHA);
    *p++ = p0;

    ioputbuf((short *) i_buff, 4);
}


/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstcolkey
*/ 

#ifdef ANSI
void FTYPE lsdcstcolkey(unsigned short p0, unsigned short p1,
                        unsigned short p2)
#else
FTYPE lsdcstcolkey(p0, p1, p2)
unsigned short p0, p1, p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTCOLKEY);
    *p++ = (unsigned long) p0;
    *p++ = (unsigned long) p1;
    *p++ = (unsigned long) p2;

    ioputbuf((short *) i_buff, 8);
}

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _lsdcstosync
*/ 

#ifdef ANSI
void FTYPE lsdcstosync(unsigned short p0, unsigned short p1,
                         unsigned short p2)
#else
FTYPE lsdcstosync(p0, p1, p2)
unsigned short p0;
unsigned short p1;
unsigned short p2;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | LSDCSTOSYNC);
    *p++ = (unsigned long) p0;
    *p++ = (unsigned long) p1;
    *p++ = (unsigned long) p2;

    ioputbuf((short *) i_buff, 8);
}


