/*
    filename :  ioflush.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

/* all conditionnal compilations switches in imseries.h */

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#if ( defined ( I_UNIX ) && !defined ( I_PHYSMAP ))
extern  I_IMGLOB    i_glob;
#endif

/*/     Function:   ioflush()
*       Synopsis:   This routine returns with both FIFOs empty.
*       Date:       January 23rd 1990
*       param:      --- none ---
*                                               
*       returns:    --- nothing ---
**/

#ifdef ANSI
void FTYPE ioflush(void)
#else
FTYPE ioflush()
#endif
{

#if ( defined ( I_UNIX ) && !defined ( I_PHYSMAP ))

    ioctl ( i_glob.board, I_FLUSH, NULL );

#else

   short dummy;

   /* Wait until write FIFO is empty */

   while ( !ioiqwrfifo() )
      ;


   /* Empty until read FIFO is empty */

   while ( !ioiqrdfifo() )
      iogetbuf(&dummy,1);

#endif

} /* ioflush() */




/*/     Function:   ioFlushIndexInADR()
*       Synopsis:   This routine ensure that index written will
*                   reach ADR before any new data is supplied to
*                   ADR (brokes the access).
*       Date:       November 1,1994
*       param:      short _I_PTYPE *adrAddr
*                                               
*       returns:    --- nothing ---
**/

#ifdef ANSI
short FTYPE ioFlushIndexInADR(short _I_HRDWTYPE *adrAddr)
#else
short FTYPE ioFlushIndexInADR(adrAddr)
short _I_HRDWTYPE *adrAddr;
#endif
{
   /* reading at that address will break the access */
   return (*adrAddr);
} /* ioFlushIndexInADR() */
