/*/  Function name:  lsdgc
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputmbuf:  send multiple buffers of words to the board.
*
*    Uses:  BITMAP data structure.
*
*    Return value:  None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 4    /* parameters buffer size in words */

#define STRUCT_SIZE 4    /* structure size in words */

#ifdef ANSI
void FTYPE lsdgc(unsigned short cursor_id, short xhot, short yhot,
				 BITMAP _I_PTYPE *gc_bmapptr)
#else
FTYPE lsdgc(cursor_id, xhot, yhot, gc_bmapptr)
unsigned short  cursor_id;
short  xhot, yhot;
BITMAP  _I_PTYPE *gc_bmapptr;
#endif

	{
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

    /* set buffer for parameters */
	ptrbuff = buff;

    *ptrbuff++ = 0x007F;
    *ptrbuff++ = cursor_id;
    *ptrbuff++ = xhot;
    *ptrbuff = yhot;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the structure values */
    *buffers++ = (unsigned short _I_PTYPE *) gc_bmapptr;

    /* other buffer in structure */
	*buffers = (unsigned short _I_PTYPE *)gc_bmapptr->tl;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* structure size ( in words ) */
    *ns++ = (unsigned short) STRUCT_SIZE;

	/* other buffer sizes */
    *ns = (unsigned short) ((gc_bmapptr->h * gc_bmapptr->pitch) << 1);

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 3 );

    }


