/*****************************************************************************/
/*                               MOUSE.C                                     */
/*****************************************************************************/
/*                                                                           */
/* Designed by: Michel Pelletier                                             */
/* Date: 	May 4th, 1993                                                */
/* Synopsis:    This file contains a few simple routines for interfacing     */
/*              with a Microsoft compatible mouse driver.                    */
/*                                                                           */
/*****************************************************************************/
/* Inclusions */

#include	<grabtest.h>

/*****************************************************************************/

extern	int		mouse_present, mouse_type, mouse_x_pos, mouse_y_pos;
extern	int		button_state, OVRLocation;
extern	unsigned long	last_pressed;
extern	unsigned char	last_overflow;
extern	short		screen_w, screen_h;

static	signed int	mouse_level = -1;
static	GCATTR 		cur_parms;

/*****************************************************************************/
/* This function initializes the mouse driver and updates the mouse related  */
/* global variables.                                                         */

void InitMouseDriver( void )
{
union	REGS		inregs, outregs;
unsigned char	far 	*data_ptr;
unsigned long	far	*clk_ptr;

data_ptr = (unsigned char far *)(MOUSE_INT * 4);

if( (data_ptr == NULL) ||		/* If mouse vector is a NULL or      */
    (*data_ptr == IRET_INSTR) )		/* points to an IRET instruction,    */
	{				/* then the mouse driver is not      */
	mouse_present = NO;		/* installed.                        */
	return;
	}
inregs.x.ax = RESET_MOUSE;		/* Reset the mouse driver            */
int86( MOUSE_INT, &inregs, &outregs );
if( outregs.x.ax == -1 )
	{				/* Mouse driver must return -1 in AX */
	mouse_present = YES;		/* to indicate a successful init     */
	mouse_type = outregs.x.bx;
	UpdateMouseInfo();
	clk_ptr = (unsigned long far *)0x46cL;
	data_ptr = (unsigned char far *)0x470L;
	last_pressed = *clk_ptr;
	last_overflow = *data_ptr;	/* Record the current timer count    */
	if( OVRLocation == IM_OVERLAY )
		{
		/* Initialise mouse settings */
		krgcdi();
		cur_parms.tdef1       = 0x0001;
		cur_parms.mask1       = 0xffff;
		cur_parms.fcol1       = 0x0000;
		cur_parms.bcol1       = 0x0000;
		cur_parms.bop1        = 0x0000;
		cur_parms.tdef2       = 0x0001;
		cur_parms.mask2       = 0xffff;
		cur_parms.fcol2       = 0x00ff;
		cur_parms.bcol2       = 0x0000;
		cur_parms.bop2        = 0x0000;
		cur_parms.full_screen = 0x0000;
		krgcsda( &cur_parms );
		}
	}
else
	{
	mouse_present = NO;
	}
}

/*****************************************************************************/

void ShowTheMouse( void )
{
union	REGS	inregs, outregs;

if( mouse_present == YES )
   {
   if( OVRLocation == IM_OVERLAY )
	{
	/******************************************************/
	/* Use Image-Shell graphics functions for drawing in  */
	/* the IM-1280 or IM-640 overlay frame buffer         */
	/******************************************************/
	mouse_level++;
	mouse_level = min( 0, mouse_level );
	if( mouse_level == 0 )
		{
		krgcen();
		}
	}
   else
	{
	/**********************************************/
	/* Use Mouse drawing functions for drawing in */
	/* the VGA's frame buffer.                    */
	/**********************************************/
	inregs.x.ax = SHOW_MOUSE;
	int86( MOUSE_INT, &inregs, &outregs );
	}
   }
}

/*****************************************************************************/

void HideTheMouse( void )
{
union	REGS	inregs, outregs;

if( mouse_present == YES )
   {
   if( OVRLocation == IM_OVERLAY )
	{
	/******************************************************/
	/* Use Image-Shell graphics functions for drawing in  */
	/* the IM-1280 or IM-640 overlay frame buffer         */
	/******************************************************/
	mouse_level--;
	mouse_level = max( -128, mouse_level );
	if( mouse_level == -1 )
		{
		krgcdi();
		}
	}
   else
	{
	/**********************************************/
	/* Use Mouse drawing functions for drawing in */
	/* the VGA's frame buffer.                    */
	/**********************************************/
	inregs.x.ax = HIDE_MOUSE;
	int86( MOUSE_INT, &inregs, &outregs );
	}
   }
}

/*****************************************************************************/
/* This function returns the mouse driver to it's original state             */

void DeinitMouse( void )
{
union	REGS		inregs, outregs;

if( mouse_present == YES )
	{
	inregs.x.ax = RESET_MOUSE;
	int86( MOUSE_INT, &inregs, &outregs );
	if( OVRLocation == IM_OVERLAY )
		{
		/******************************************************/
		/* Use Image-Shell graphics functions for drawing in  */
		/* the IM-1280 or IM-640 overlay frame buffer         */
		/******************************************************/
		krgcdi();
		}
	}
}

/*****************************************************************************/

void	UpdateMouseInfo( void )
{
union	REGS	inregs, outregs;
unsigned char	far *data_ptr;
unsigned long	far *clk_ptr;
int		old_xpos, old_ypos;

if( mouse_present == YES )
	{
	inregs.x.ax = MOUSE_INFO;
	int86( MOUSE_INT, &inregs, &outregs );
	old_xpos = mouse_x_pos;
	old_ypos = mouse_y_pos;
	mouse_x_pos = outregs.x.cx;
	mouse_y_pos = outregs.x.dx;
	switch( mouse_type )
		{
		default:
		case TWO_BUTTON:
		outregs.x.bx &= 3;
		break;

		case THREE_BUTTON:
		outregs.x.bx &= 7;
		break;
		}
	if( outregs.x.bx != 0 )
		{
		if( button_state == UP )	/* At least one button is    */
			{			/* down                      */
			clk_ptr = (unsigned long far *)0x46cL;
			data_ptr = (unsigned char far *)0x470L;
			last_pressed = *clk_ptr;
			last_overflow = *data_ptr;
			}			/* If down from previously   */
		button_state = DOWN;		/* up, then record the time  */
		}
	else					/* All buttons are up        */
		{
		button_state = UP;
		}
	if( (OVRLocation == IM_OVERLAY) &&
	   ((old_xpos != mouse_x_pos) || (old_ypos != mouse_y_pos)) )
		{
		/******************************************************/
		/* Use Image-Shell graphics functions for drawing in  */
		/* the IM-1280 or IM-640 overlay frame buffer         */
		/******************************************************/
		krgcmv( mouse_x_pos, mouse_y_pos );
		}
	}
}
