/************************************************************************
 *     MultiSound Proteus Preset Upload Example
 *
 *		 Uploads the preset file defined by PRESET_FILE_NAME to the
 *		 proteus
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <conio.h>
#include <msnd_dsp.h>
#include <pcontrol.h>

#define PRO_DATA_SIZE      69146l
#define PRESET_FILE_NAME   "GENMIDI.MPP"
#define PRO_HEADER_SIZE    256
#define LOAD_SIZE          0x8000

main()
{
	FILE *fPresetFileName;
	BYTE _huge *hpPresetData;
	BYTE _huge *hpCurrPosition;
	BYTE *lpTemp;
	BYTE *szDataString;
	BYTE bMidiOutData;
	DWORD dwPresetCount = 0;
	WORD wPD;
	DWORD dwReadsize;

	bIntFlag    = 0;
	bMem        = HPMEM_D000;
	bIrq        = HPIRQ_10;
	nIRQValue   = 10;
	pMEM.dw.h   = 0xD000;
	pMEM.dw.l   = 0x0000;
  wBASEIO     = 0x240;

  if( ( hpPresetData =
	( BYTE _huge * )halloc( (PRO_DATA_SIZE + 2) , sizeof( BYTE ) ) ) == NULL ) {
		printf("Unable to allocate huge buffer\n");
		exit( 0 );
	}

	if( ( fPresetFileName = fopen( PRESET_FILE_NAME, "rb" ) ) == NULL ) {
		printf("Unable to open file\n");
		exit(0);
	}

	hpCurrPosition = hpPresetData;
	while( !feof( fPresetFileName ) ) {
		fread( (BYTE _huge *)hpCurrPosition , sizeof( BYTE ) , LOAD_SIZE , fPresetFileName );
		(BYTE _huge *)hpCurrPosition += LOAD_SIZE;
	}

	fclose( fPresetFileName );

	*( hpPresetData + PRO_DATA_SIZE ) = 0xFF;

  outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
  outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );

	ResetProteus();
	InitializeSMA();
	ResetDSP();
	UploadDSPCode();

  while( !*( pMEM.p ) );

	SetupMsndIRQ();

	printf("Uploading Presets to the Proteus\n");

	SetMidiOutPort( MOP_PROTEUS );

	hpCurrPosition = hpPresetData + PRO_HEADER_SIZE;
	while ((bMidiOutData = *hpCurrPosition ) != 0xFF) {
		dwPresetCount++;
		MODPortWrite ( MAKEWORD( bMidiOutData , 0x00 ) );
		if( *hpCurrPosition == 0xF7 ) {
			wPD = dwPresetCount * 100 / ( PRO_DATA_SIZE - PRO_HEADER_SIZE );
			printf("Operation in progress : %d percent done\r", wPD );
			GetDelayTime( TIME_PRO_SYSEX );
		}
		( BYTE _huge * )hpCurrPosition += 1;
	}

	hfree( hpPresetData );
	ResetMsndIRQ();
  return(0);
}

