unit scrolly;
{tandy/CGA compatible scroller}

interface

uses
  cgalib,
  support,
  strings;

function scrollonce(var stext:string;sloc:pointer;scol:byte):word;
{takes stext as the scrolltext and returns where in the string we are}

implementation

type
  pbyte=^byte;

const
  scolor:byte=15;
  curtxtpos:byte=1;
  scrollcounter:word=0;
  mask:byte=$80;

procedure cgaromfont;external;
{$L cga_font.obj}

function scrollonce;
{Moves the scroll to the left;
puts down one pixel column of the scroll in the rightmost column}

var
  scrollLoc:pbyte;
  scanline:byte;
  fontdata:^byte;
begin
  scrollLoc:=sloc;
  {adjust start and end pointers for memory moves}

  fontdata:=@cgaromfont;
  inc(word(fontdata),8*byte(stext[curtxtpos])); {advance to char in rom font data}
  for scanline:=0 to 7 do begin
    {scroll line across}
    asm
      push ds
      cld       {otherwise we stomp on ourselves}
      les  di,scrollLoc
      mov  ax,es
      mov  ds,ax
      mov  si,di {copy to source reg}
      mov  cx,79
      sub  di,cx  {destination is col 0}
      sub  si,78  {source is col 1}
      rep  movsb
      pop  ds
    end;
    {draw a slice}
    if (fontdata^ AND mask)=0
      then scolor:=0
      else scolor:=(scol SHL 4) OR (scol OR 8);
    scrollLoc^:=scolor;
    inc(word(scrollLoc),80); {go to next scanline}
    inc(word(fontdata)); {go to next row of char font data}
  end;
  asm
    ror mask,1
  end;
  if mask=$80 then inc(curtxtpos);{back to start, time for new character}
  inc(scrollcounter); {general-purpose counter}
  if curtxtpos>=length(stext) then begin
    curtxtpos:=1;
    scrollcounter:=0;
  end;
  scrollonce:=scrollcounter; {return pixel col counter so we can switch to next text}
end;

end.