
;   /*\
;---|*|----====< TARGET.H >====----
;---|*|
;---|*| This file defines which product is being compiled. This is used
;---|*| for the PAS software libraries, etc.
;---|*|
;---|*| Copyright (c) 1992. Media Vision, Inc.	All Rights Reserved.
;---|*|
;---|*| To use this code, you must define one of the following variable names.
;---|*|
;---|*|    BUILD_NONE - General assembly of header. No target product defined
;---|*|    BUILD_PAS1 - Original Pro Audio Spectrum.
;---|*|    BUILD_PAS2 - Pro Audio Spectrum Plus.
;---|*|    BUILD_PAS3 - Pro Audio Spectrum 16.
;---|*|    BUILD_CDPC - CDPC.
;---|*|
;   \*/

//
// Each product will some/all of of these features
//

#define bMVA508      0x0001 // 0000000000000001b  MVA508(1) or National(0)
#define bMVPS2	     0x0002 // 0000000000000010b  PS2 bus stuff
#define bMVSLAVE     0x0004 // 0000000000000100b  CDPC Slave device is present
#define bMVSCSI      0x0008 // 0000000000001000b  SCSI interface
#define bMVENHSCSI   0x0010 // 0000000000010000b  Enhanced SCSI interface
#define bMVSONY      0x0020 // 0000000000100000b  Sony 535 interface
#define bMVDAC16     0x0040 // 0000000001000000b  16 bit DAC
#define bMVSBEMUL    0x0080 // 0000000010000000b  SB h/w emulation
#define bMVMPUEMUL   0x0100 // 0000000100000000b  MPU h/w emulation
#define bMVOPL3      0x0200 // 0000001000000000b  OPL3(1) or 3812(0)
#define bMV101	     0x0400 // 0000010000000000b  MV101 ASIC
#define bMV101_REV   0x3800 // 0111100000000000b  MV101 Revision
#define bMV101_MORE  0x8000 // 1000000000000000b  more bits in BX

//
// Define the ASIC versions
//

#define ASIC_VERSION_B 0x02 // revision B
#define ASIC_VERSION_C 0x03 // revision C
#define ASIC_VERSION_D 0x04 // revision D
#define ASIC_VERSION_E 0x05 // revision E
#define ASIC_VERSION_F 0x06 // revision F

//
// First Pro Audio Spectrum feature list
//
#define PRODUCT_PROAUDIO	bMVSCSI

//
// Pro Audio Plus feature list
//
#define PRODUCT_PROPLUS 	bMV101+      \
				bMVSCSI+     \
				bMVENHSCSI+  \
				bMVSBEMUL+   \
				bMVOPL3
//
// Pro Audio Spectrum 16 feature list
//
#define PRODUCT_PRO16		bMV101+      \
				bMVA508+     \
				bMVSCSI+     \
				bMVENHSCSI+  \
				bMVSBEMUL+   \
				bMVDAC16+    \
				bMVOPL3
//
// CDPC feature list
//
#define PRODUCT_CDPC		bMV101+      \
				bMVSLAVE+    \
				bMVSONY+     \
				bMVSBEMUL+   \
				bMVDAC16+    \
				bMVOPL3



//
//----====<  1st retail version of the Pro Audio Spectrum.
//
#ifdef BUILD_PAS1
#define PROAS100	1		// 1st board - Pro Audio Spectrum
#define PRODUCTDEFINED	PRODUCT_PROAUDIO// product has been identified
#endif

//
//----====<  8 bit Integrated PAS with rev 2 of the MV101
//

#ifdef BUILD_PAS2
#define PROAS200	1		// 1st board - Pro Audio Spectrum
#define PRODUCTDEFINED	PRODUCT_PROPLUS // product has been identified
#endif

//
//----====<  16 bit Integrated PAS with rev 2 of the MV101
//

#ifdef BUILD_PAS3
#define PROAS300	1		// 1st board - Pro Audio Spectrum
#define PRODUCTDEFINED	PRODUCT_PRO16	// product has been identified
#endif

//
//----====< 1st CDPC box >====----
//

#ifdef BUILD_CDPC
#define CDPC		1		// CDPC stand alone box
#define PRODUCTDEFINED	PRODUCT_CDPC	// product has been identified
#endif

//
//----====<  If no product defined we must generate an error! >====----
//


//
// Set all undefined equates to zero
//

#ifndef PROAS100
#define PROAS100        0
#endif

#ifndef PROAS200
#define PROAS200	0
#endif

#ifndef PROAS300
#define PROAS300	0
#endif

#ifndef CDPC
#define CDPC		0
#endif

//
//------------------====< Hardware Dependencies >====-------------------
//

#if PROAS100				// Media Vision Pro Audio Spectrum Orig
#define HWREVISION	0x00		// the H/W revision #
#endif
#if PROAS200				// Media Vision Pro Audio Spectrum Plus
#define HWREVISION	0x01		// the H/W revision #
#endif
#if PROAS300				// Media Vision Pro Audio Spectrum 16
#define HWREVISION	0x01		// the H/W revision #
#endif
#if CDPC				// Media Vision CDPC
#define HWREVISION	0x01		// the H/W revision #
#endif

#if (PRODUCTDEFINED & bMVA508)
#define VOLUMEMAX     MVVOLUMEMAX
#else
#define VOLUMEMAX     NSVOLUMEMAX
#endif

