
1 REM FILE: MOT_1042.BAS,  WRITTEN IN QBASIC
2 REM
3 REM Printer port control  of stepping motor using CLOCK/DIRECTION code logic
7 REM
100   T = 300: REM  time delay, dependent on your computer's clock speed
110 Clk = 1: REM  clock pulse data bit, D0
120 Dir = 2: REM  direction data bit, D1
137 REM
138 REM   %%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%%%%%%%%
140 REM
142 REM  Semicolens at end of LPRINT statement tells BASIC to not add
145 REM  carrage return and line feed to transmitted data.
147 REM
150 FOR E = 1 TO 40: REM  step 40 full steps in clockwise direction using
160 LPRINT CHR$(Clk); : GOSUB 500
170 LPRINT CHR$(0); : GOSUB 500
180 NEXT E
210 FOR E = 40 TO 1 STEP -1: REM step motor 40 steps in CCW direction
230 LPRINT CHR$(Clk + Dir); : GOSUB 500
240 LPRINT CHR$(Dir); : GOSUB 500
250 NEXT E
270 REM
280 REM  %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%%%%
282 REM
283 REM   This method permits sending control signals to LPT1, LPT2, and LPT3
290 REM
300 GOSUB 600: REM   get port's base address
310 FOR E = 1 TO 40: REM  step motor clockwise through 40 steps
340 OUT LptPortAddress, Clk: GOSUB 500
350 OUT LptPortAddress, 0: GOSUB 500
370 NEXT E
380 FOR E = 40 TO 1 STEP -1: REM step motor counterclockwise through 40 steps
400 OUT LptPortAddress, Clk + Dir: GOSUB 500
410 OUT LptPortAddress, Dir: GOSUB 500
420 NEXT E
499 END
500 REM  -=[ delay ]=-
510 FOR V = 1 TO T: NEXT V
520 RETURN
600 REM
605 PRINT
610 PRINT " Which printer port do you want to use? "
620 PRINT "             1) LPT1"
630 PRINT "             2) LPT1"
640 PRINT "             3) LPT3"
650 n = VAL(INPUT$(1))
670 IF (n < 1) OR (n > 3) THEN GOTO 605
675 DEF SEG = 0
680 OffSet = (n * 2) + 6: Address = 1024 + OffSet
690 LptPortAddress = PEEK(Address) + (PEEK(Address + 1) * 256)
700 RETURN







