
1   REM  FILE: MOT_3.BAS,  WRITTEN IN QBASIC
2   REM
3   REM  Printer port control of 5-wire stepping motor via LPRINT command.
4   REM  Efficient code, but stepping motor must be conntcted to LPT1.
7   REM
100 D0 = 1
110 D1 = 2
120 D2 = 4
130 D3 = 8
135  T = 300
137 REM
138 REM   %%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%%%%%%%%
140 REM
142 REM  Semicolens at end of LPRINT statement tells BASIC to not add
145 REM  carrage return and line feed to transmitted data.
147 REM
150 FOR e = 1 TO 10: REM  step motor 40 steps in clockwise direction
160 LPRINT CHR$(D0); : GOSUB 500
170 LPRINT CHR$(D1); : GOSUB 500
180 LPRINT CHR$(D2); : GOSUB 500
190 LPRINT CHR$(D3); : GOSUB 500
200 NEXT e
210 FOR e = 1 TO 10: REM step motor 40 steps in counter-clockwise direction
220 LPRINT CHR$(D3); : GOSUB 500
230 LPRINT CHR$(D2); : GOSUB 500
240 LPRINT CHR$(D1); : GOSUB 500
250 LPRINT CHR$(D0); : GOSUB 500
260 NEXT e
270 REM
280 REM  %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%%%%
282 REM
283 REM   This method permits sending control signals to LPT1, LPT2, and LPT3
290 REM
300 GOSUB 600: REM   get port's base address
310 FOR e = 1 TO 10: REM  step motor clockwise through 40 steps
320 OUT LptPortAddress, D0: GOSUB 500
340 OUT LptPortAddress, D1: GOSUB 500
350 OUT LptPortAddress, D2: GOSUB 500
360 OUT LptPortAddress, D3: GOSUB 500
370 NEXT e
380 FOR e = 1 TO 10: REM step motor counterclockwise through 40 steps
390 OUT LptPortAddress, D3: GOSUB 500
400 OUT LptPortAddress, D2: GOSUB 500
410 OUT LptPortAddress, D1: GOSUB 500
420 OUT LptPortAddress, D0: GOSUB 500
430 NEXT e
499 END
500 REM  -=[ delay ]=-
510 FOR V = 1 TO T: NEXT V
520 RETURN
600 REM
605 PRINT
610 PRINT " Which printer port do you want to use? "
620 PRINT "             1) LPT1"
630 PRINT "             2) LPT1"
640 PRINT "             3) LPT3"
650 n = VAL(INPUT$(1))
670 IF (n < 1) OR (n > 3) THEN GOTO 605
675 DEF SEG = 0
680 OffSet = (n * 2) + 6: Address = 1024 + OffSet
690 LptPortAddress = PEEK(Address) + (PEEK(Address + 1) * 256)
700 RETURN







