/*                       PROGRAM AD_SER
		    Code conversion by Eugene Klein
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

/*
  Input 8-bit analog conversion from T.I.'s TLC548 serial A/D Converter
  via your IBM / IBM clone parallel printer port.
*/


float Volts;
const int T = 30;          // Time delay in milliseconds.
unsigned char Chip_Select; //D1 = Base Address, Printer Port Pin 3; inactive high signal.
unsigned char Clock;       // D0 = Base Address, Printer Port Pin 2, active high signal.
unsigned char Data_In;     // D7 of Base Address + 1 = BUSY line; Pin 11 on printer card,
			   //   used to input serial data.
unsigned char Output_Data, Lpt_Num;

int Input_Data_Byte;
unsigned int Temp, LPTx;

unsigned int Input_Data_Bit( unsigned int Temp,int  Bit_Value)
{
 unsigned char T;
 // input data bit
 outport(LPTx,0);        // Chip_Select and Clock set to 0.
 delay(T);
 // set Chip Select, D1, LOW,  and Clock, D0, high.
 delay(T);
 outport(LPTx,1);        // Chip_Select and Clock set to 0.
 // Read data bit.
 delay(T);
 Temp = inport(LPTx + 1);
 Temp &= Bit_Value;
 // Set Clock, D0, low.
 outport(LPTx,0);        //  Clock set to 0.
 delay(T);
 return(Temp);
}

void main()
{
 // Select the printer port that the A/D converter is connected to.
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 // Initialize A/D converter I/O pins: Chip_Select = HIGH, Clock = Low.
 clrscr();
 do
 {
  Chip_Select = 2; // 00000010; set CS to inactive high.
  Clock = 0;
  Output_Data = Clock + Chip_Select;  // Default settings for clock and CS.
  outport(LPTx,Output_Data);          // Set default settings on printer port.
  delay(T);                           // Let A/C chip digest that information.
  // Set Chip_Select to Active Low, still keeping Clock low.
  // Data conversion is placed in tri-state buffer.
  // MSB of previous conversion is placed on output data line.
  Clock = 0; Chip_Select = 0;
  Output_Data = Clock + Chip_Select;
  outport(LPTx,Output_Data);
  delay(T);
  // Read MSB from data line.
  Temp = inport(LPTx + 1) & 128 ;   // Value now in Temp is 0 or 128.
  Input_Data_Byte = Temp;
  gotoxy(5,8); printf("%4i",Temp);
  // Read D6.
  Temp = Input_Data_Bit( Temp, 64);
  Input_Data_Byte = Input_Data_Byte | Temp;
  printf("%4i",Temp);
  // Read D5.
  Temp = Input_Data_Bit( Temp, 32);
  Input_Data_Byte = Input_Data_Byte | Temp;
  printf("%4i",Temp);
  // Read D4,
  // with this clock pulse, the TLC548 starts another conversion.
  // Current value remains in tri-state buffer.
  Temp = Input_Data_Bit( Temp, 16);
  Input_Data_Byte = Input_Data_Byte | Temp;
  printf("%4i",Temp);
  // Read D3.
  Temp = Input_Data_Bit( Temp, 8);
  Input_Data_Byte = Input_Data_Byte | Temp;
  printf("%4i",Temp);
  // Read D2.
  Temp = Input_Data_Bit( Temp, 4);
  Input_Data_Byte = Input_Data_Byte | Temp;
  printf("%4i",Temp);
  // Read D1.
  Temp = Input_Data_Bit( Temp, 2);
  Input_Data_Byte = Input_Data_Byte | Temp;
  printf("%4i",Temp);
  // Read D0.
  Temp = Input_Data_Bit( Temp, 1);
  Input_Data_Byte = Input_Data_Byte | Temp;
  printf("%4i",Temp);
  // Display Result.
  gotoxy(5,10);
  printf("Input_Data_Byte = %5i",Input_Data_Byte);
  Volts = ((float)Input_Data_Byte * 5) / 256;
  printf(";     Voltage = %5.2f",Volts);
 }while(!kbhit());
}




