/*                     PROGRAM AT_Game
		   Code conversion by Eugene Klein

  Read joystick status.  Uses Bios calls added to AT bios.  This routine
  will not work on XT machines.

  REF: PC System Programming for Developers, Abacus Pub. 1989, Page 753

  INTERRUPT 15H, FUNCTION 84H, SUB-FUNCTION 0
  Reads status of joystick switches interfaced to a PC ( AT and higher ) IF
    a game port and switches are present.

  Read joystick info.  Uses BIOS Interrupt 15H
  INPUT:    AH = 84H
            DX = 0
  OUTPUT:   IF Carry Flag = 1 then no game port is installed
            IF Carry Flag = 0 then game port is installed
            AL = switch settings
              If bit 7 = 0 then first joystick's button 'A' is enabled
              If bit 6 = 0 then first joystick's button 'B' is enabled
              If bit 5 = 0 then second joystick's button 'A' is enabled
              If bit 4 = 0 then second joystick's button 'B' is enabled
  NOTES:    Sub Function 1 reads joystick positions

  INTERRUPT 15H, FUNCTION 84H, SUB-FUNCTION 1
  Reads position of joysticks interfaced to a PC ( AT and higher ) if game
  port and joysticks are present.

  INPUT:    AH = 84H
            DX = 1
  OUTPUT:   IF Carry Flag = 1 then no game port is installed
            IF Carry Flag = 0 then game port is installed
            AX contains X-Position of first joystick
            BX contains Y-Position of first Joystick
            CX contains X-Position of second Joystick
            DX contains Y-Position of second Joystick

            FLAGS Register =
                  BIT: 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
             FUNCTION:  -  -  -  -  O  D  I  T  S  Z  -  A  -  P  -  C
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"


union REGS Regs;
unsigned char Ch;
unsigned int Bit;
unsigned char ESC = 0x1B;

void Process_Joysticks(void)
{
 Ch = 32;
 do
 {
  Regs.h.ah = 0x84;     // Get joystick positions.
  Regs.x.dx = 0x01;
  int86(0x15,&Regs,&Regs);
  gotoxy(1,5);        // Display stick position.
  printf("%7x%9x%16x%10x",Regs.x.ax, Regs.x.bx, Regs.x.cx, Regs.x.dx);

  Regs.h.ah = 0x84;     // Get joystick button values.
  Regs.x.dx = 0x00;
  int86(0x15,&Regs,&Regs);
  gotoxy(1,8);
		       // Display button position.
  if((Regs.h.al & 16) != 16)
   printf("    ON");
  else
   printf("   OFF");
  if((Regs.h.al & 32) != 32)
   printf("           ON");
  else
   printf("          OFF");
  if((Regs.h.al & 64) != 64)
   printf("             ON");
  else
   printf("            OFF");
  if((Regs.h.al & 128) != 128)
   printf("           ON");
  else
   printf("          OFF");

  if(kbhit())
   Ch = getch();
 }while(Ch != ESC);
}

void main()
{
 clrscr(); Ch = 32;
 Regs.h.ah = 0x84;
 Regs.x.dx = 0x00;
 int86(0x15,&Regs,&Regs);
 Bit = Regs.x.flags & 0x0001;
 if(Bit != 0)
 {        // Is game board installed?
  printf("\n\nNO GAME CARD IS INSTALLED ON THIS MACHINE\n\n");
  printf("PRESS ANY KEY TO CONTINUE ");
  getch();
  exit(0);
 }
 else
 {
  gotoxy(1,3);
  printf("       JOYSTICK A               JOYSTICK B \n");
  printf("    x-pos    y-pos           x-pos     y-pos");
  gotoxy(1,7); printf(" Button-A     Button-B       Button-A     Button-B");
  gotoxy(5,24); printf(" Press ESC to exit");
 }
 Process_Joysticks();
}




