 /*                    PROGRAM GamePort
		  Code conversion by Eugene Klein

  Relatively fast input of joystick port info for your application.
  Originally written for IBM XT / XT clone machines.  With the AT and
  higher machines, you can use BIOS interrupts to read the joysticks.
  However, I find this version more than adequate for my needs.
  Written in Borland's Turbo Pascal 6.0.

  REF: IBM PC Joystick Control Using Turbo Pascal by James P. McAdems,
	  BYTE Mag., October 1985, Page 143-144.
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int ESC = 0x1b;
int Joy_Port_Address = 0x201; // game port base address
int I;
unsigned char Temp;
char Ch;
int   Max_Count = 2000;     // Delay time needed for my AT clone machine
			    // Adjust this value for your machine.


int Button_Pressed(char Which_One)
{
 // return true if selected button is pressed
 unsigned char Mask;
 if(Which_One  < 'A' && Which_One > 'D')
  Which_One = 'A';
 switch (Which_One)
 {
  case 'A':
   Mask = 16;
   break;
  case 'B':
   Mask = 32;
   break;
  case 'C':
   Mask = 64;
   break;
  case 'D':
   Mask = 128;
   break;
  default:
   Mask = 0;
 }
 return(inport(Joy_Port_Address) & Mask);
}

int Joystick_Position(char Which_One)
{
 /*
  Returns a number based on a joystick's position.  Values will
  vary depending on your joystick.  You can 'tweak' the program's
  performance by:


  Function returns 0 for out of range or uninstalled joystick polling.

      1) Changing value of Max_Count,
      2) Using larger capacitors on game card
 */

 int Counter;
 unsigned char Mask;


 if(Which_One <'A'& Which_One > 'D')
  Which_One = 'A';
 switch(Which_One)
 {
  case 'A':
   Mask = 1;
   break;
  case 'B':
   Mask = 2;
   break;
  case 'C':
   Mask = 4;
   break;
  case 'D':
   Mask = 8;
  default:
   Mask = 0;
 }

/*
  The Inline Code below causes the CX register to count down from Max_Count
  toward zero.  When CX reaches zero, or when the one-shot on the game
  adapter times out, the looping stops and counter is loaded with the
  active count.  Max_Count should be chosen so that CX never reaches 0,
  then the usable range ofthe joystick is not compromised.
*/
       asm {
	      MOV CX,Max_Count     //  Init down counter
	      MOV DX,Joy_Port_Address
				   //  load joystick port address
	      MOV AH,Mask          // [BP]
	                           //  Mask of selected one_shot
	      OUT DX,AL            //  Start the one shots
	   }
       READ:
       asm {
	      IN AL,DX             //  Read the one shots
	      TEST AL,AH           //  Check selected one-shot
	      LOOPNZ READ          //  Repeat until timed out
	      MOV Counter,CX //  Make CX available to Turbo Pascal
	    }
 if(Counter == 0)
  return(0);
 else
  return(Max_Count - Counter);
}

char Process_Key_Press(void)
{
 Ch = getch();
 if(Ch=='J'|| Ch=='j')
 {
  gotoxy(1,20); printf("Count now reads: %i;  Enter new value: ",Max_Count);
  scanf("%i",&Max_Count);
  gotoxy(1,20);
  printf("Count now reads: %i                              ",Max_Count);
 }
 return(Ch);
}

void main()   // main, GamePort
{
 clrscr(); Ch = ' ';
 do
 {
  gotoxy(1,24); printf("Max_Count = %i:   Press \"J\" to change'",Max_Count);
  gotoxy(1,5);   // get joystick #1 info
  printf("%5i  %5i",Joystick_Position('A'), Joystick_Position('B'));
  if(Button_Pressed('A'))
   printf(" PRES");
  else
   printf("   UP");
  if(Button_Pressed('B'))
   printf(" PRES");
  else
   printf("   UP");
  gotoxy(1,7);   // get joystick #2 info
  printf("%5i  %5i",Joystick_Position('C'), Joystick_Position('D'));
  if(Button_Pressed('C'))
   printf(" PRES");
  else
   printf("   UP");
  if(Button_Pressed('D'))
   printf(" PRES");
  else
   printf("   UP");
  if(kbhit())
    Ch = Process_Key_Press();
 }while(Ch != ESC);
}