/*                            PROGRAM HalfStep2

   HALF STEP opteration of a six wire stepping motor.

   This method will also work with 8-wire stepping motors configured for
   6-wire operation.
 */


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const t = 300;
int A, E;
unsigned char  Motor_Step[8];
unsigned int Lpt_Port_Address, Lpt_Num;
void main()
{
 Motor_Step[1] = 3;           // 00000011
 Motor_Step[2] = 2;           // 00000010
 Motor_Step[3] = 6;           // 00000110
 Motor_Step[4] = 4;           // 00000100
 Motor_Step[5] = 12;          // 00001100
 Motor_Step[6] = 8;           // 00001000
 Motor_Step[7] = 9;           // 00001001
 Motor_Step[8] = 1;           // 00000001

 /*    * %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD ONE ]=-  %%%%%%%%%%%%%%%%% *

   Dual Phase operation of 6-wire stepping motor.  Uses Pascal's
   WRITE command to transmit data through computer's LPT1 printer port.
   The WRITE commands sends data WITHOUT generating printer Line Feed, or
   Carriage Return instructions.

   Note that to move through 40 steps, the counter is set to 80. The
   purpose of Half Stepping is to smooth out the snap action of Dual Step.
   Normally, you only count the full-step positions as actual steps.
   In other words, using Half Step logic, will not turn your 200 step / rev.
   stepping motor into a 400 step / rev. stepping motor. ( unless your
   load is VERY, VERY LIGHT! )
 */
 for(A=1;A<=10;A++)      // step motor clockwise through 40 steps
 {
  for(E=1;E<=8;E++)
  {
   putc(Motor_Step[E],stdprn);
   delay(t);
  }
  for(A=1;A<=10;A++)     // step motor counter-clockwise through 40 steps
  {
   for(E=8;E>=1;E--)
   {
    putc(Motor_Step[E],stdprn);
    delay(t);
   }
  }
 }

  /* * %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=-  %%%%%%%%%%%%%%%%% *

   Dual Phase 6-wire stepping motor. Uses Pascal's PORT command to "poke"
   port address with data.  Allows use of LPT1, LPT2, or LPT3.

   From users keyboard input of the number 1, 2, or 3,
   port's address is computed, and used to route data.

   Since the printer port latches data sent to it, data sent to a printer
   port will remain on the output pins until new data replaces it.  That
   means stepping motors, directly driven by printer port logic, will hold
   there position between transmitted instructions.
 */

 Lpt_Num = Select_Printer_Port();
 Lpt_Port_Address = Init_Printer_Port(Lpt_Num);

 for(A=1;A<=10;A++)      // step motor clockwise through 40 steps } FOR E := 1 TO 8 DO
 {
  outport(Lpt_Port_Address,Motor_Step[E]);
  delay(t);
 }
 for(A=1;A<=10;A++)       // step motor counter-clockwise through 40 steps
 {
  for(E=8;E>=1;E--)
  {
   outport(Lpt_Port_Address,Motor_Step[E]);
   delay(t);
  }
 }
}
