/*                            PROGRAM MOT_BIN
			Code conversion by Eugene Klein

  Stepping motor control via BINARY code. Written in Turbo Pascal 6.0
 
  Since the printer port latches data sent to it, data sent to a printer
  port will remain on the output pins until  new data replaces it.  That
  means stepping motors, directly driven by printer port logic, will hold
  there position between transmitted instructions.
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int t = 300;
int D, E;
unsigned int Lpt_Num, Lpt_Port_Address;

void main()
{
/*   * %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD ONE ]=-  %%%%%%%%%%%%%%%%% *

   Uses Pascal's WRITE command to transmit data through computer's LPT1
   printer port.  The WRITE command sends data WITHOUT generating printer
   Line Feed, or Carriage Return, instructions.
 */
for(E=1;E<=40;E++)     // Step motor clockwise through 40 steps
  for(D=0;D<=3;D++)
  {
   putc(D,stdprn);     // Transmit binary value
   delay(t);
  }
 for(E=1;E<=40;E++)
 {     // Step motor counter-clockwise through 40 steps
  for(D=3;D>=0;D--)
  {
   putc(D,stdprn);     // Transmit binary value
   delay(t);
  }
 }

/*   (* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=-  %%%%%%%%%%%%%%%%% *)

   Stepping Motor control via binary logic is sent to printer port LPT1, LPT2,
   or LPT3.  From users keyboard input of the number 1, 2, or 3, port's
   address is computed, and used to route control code.
 */

 Lpt_Num = Select_Printer_Port();
 Lpt_Port_Address = Init_Printer_Port(Lpt_Num);
 clrscr();

 for(E=1;E<=40;E++)     // Step motor clockwise through 40 steps
  for(D=1;D<=3;D++)
  {
   outport(Lpt_Port_Address,D);   // Transmit binary value
   delay(t);
  }
 for(E=1;E<=40;E++)
 {     // Step motor counter-clockwise through 40 steps
  for(D=3;D>=0;D--)
  {
   outport(Lpt_Port_Address,D);   // Transmit binary value
   delay(t);
  }
 }
}
