/*                            PROGRAM Mot_Bi_A
			Code conversion by Eugene Klein

  Bidirectional stepping motor control from parallel printer port using
  CLOCK PULSES. ClockWise on D0, CounterClockWise on D1.
*/


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int CW  = 1;   // clockwise data bit, D0
const int CCW = 2;   // counterclockwise data bit, D1
const int t   = 100; // time delay dependent on your computer's clock speed
int E;
unsigned int Lpt_Num, Lpt_Port_Address;

void main()
{
/*   * %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%% *

   Advance stepper motor shaft 40 steps in clockwise direction.
   Strobe the ClockWise clock line, D0, 40 times.
   This method only works with LPT1.
*/

 putc(0,stdprn); // intitilize all control bits
 for(E=1;E<=10;E++)
 {
  putc(CW,stdprn);    // 00000001
  delay(t);
  putc(0,stdprn);     // 00000000
  delay(t);
 }

/*
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   Strobe the counterclockwise clock line, D1, 40 times.
*/
 for(E=1;E<=40;E++)
 {
  putc(CCW,stdprn);   // 00000010
  delay(t);
  putc(0,stdprn);     // 00000000
  delay(t);
 }

  // (* %%%%%%%%%%%%%%%%%%%%%%% -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%% *)

 Lpt_Num = Select_Printer_Port();
 Lpt_Port_Address = Init_Printer_Port(Lpt_Num);

/*
   Advance stepper motor shaft 40 steps in clockwise direction.
   Strobe the Clockwise clock line, D0, 40 times.
   This method permits selection of LPT1, LPT2 or LPT3.
*/

 for(E=1;E<=40;E++)
 {
  outport(Lpt_Port_Address,CW);      // 00000001
  delay(t);
  outport(Lpt_Port_Address,0);       // 00000000
  delay(t);
 }
/*
   Advance stepper motor shaft 40 steps in counter-clockwise direction.
   Strobe the counterclockwise clock line, D1, 40 times.
*/
 for(E=1;E<=40;E++)
 {
  outport(Lpt_Port_Address,CCW);     // 00000010
  delay(t);
  outport(Lpt_Port_Address,0);       // 00000000
  delay(t);
 }
}