 /*              PROGRAM Music; { Signetics PCD3311 }
		   Code conversion by Eugene Klein

  FILE: Music.PAS, by Paul Bergsman 11/10/199

  Play Dill Pickle Rag via PCD331 Tone Generator
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"



  // define musical tone values
const int  T[]=
      {0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x29, 0x3B,
       0x3C, 0x3D, 0x0E, 0x3E, 0x2C, 0x3F, 0x04, 0x05, 0x25, 0x2F, 0x06, 0x07, 0x00};

/* Define music to be played.  Byte[0] contains number of bytes in array
   smallest note is a 16th, so all notes are defined as 16th notes.
   Music was transcribed by listing the ordinal value of T[n] over sheet
   music notes,  then recording values into constant arrays below.
   First number in array = number of active elements in array
*/

int Intro[] = {6,9,9,10,10,11,11};
int Line_1[] = {32,12,14,17,12,14,17,12,14,
   17,12,14,17,17,14,12,12,5,7,9,5,7,9,5,7,9,5,7,9,9,7,5,5};
int End_A1[] = {32,0,2,4,0,2,4,0,2,4,0,2,4,
   4,2,0,0,5,4,5,2,2,4,5,6,7,6,7,12,12,9,10,11};
int End_A2[] = {32,0,2,4,0,2,4,0,2,4,0,2,4,
   4,2,0,0,7,6,7,12,12,9,7,7,5,5,5,5,5,7,3,2};
int Line_2[] = {32,0,0,1,1,2,2,4,4,
   5,5,14,12,12,14,12,12,4,4,14,12,12,14,12,12,5,5,14,12,12,14,12,12};
int End_B1[] = {32,0,7,2,7,3,7,4,7,
   5,5,14,12,12,14,12,12,7,9,11,7,9,11,11,11,12,12,12,12,12,5,3,2};
int End_B2[] = {32,0,7,2,7,3,7,4,7,
   5,5,14,12,12,14,12,12,13,14,16, 12,14,16,16,16,17,17,17,17,17,17,17,17};
int Line_3[] = {32,10,7,5,10,7,5,2,3,
   5,2,5,7,7,5,2,2,0,-1,0,5,5,2,0,0, -2,-2,-2,-2,7,7,9,9};
int Line_4[] = {32,10,7,5,10,7,5,2,3,
   5,2,5,7,7,5,2,2,7,6,7,12,12,9,7,7,5,5,5,5,7,7,9,9};
int Line_5[] = {32,10,7,5,10,7,5,2,3,
   5,2,5,7,7,5,2,2,0,-1,0,5,5,2,0,0,-2,-2,-2,-2,10,10,9,9};
int Line_6[] = {32,7,5,7,9,10,9,10,12,
  14,13,14,19,19,17,14,14,12,11,12,17,17,14,12,12,10,10,10,10,10,10,7,9};
int Line_7[] = {32,7,5,7,9,10,9,10,12,
  14,13,14,19,19,17,14,14,12,11,12,17,17,14,12,12,10,10,10,10,5,5,5,5};

int A, C, E,Lpt_Num, LPTx;

void Play_Note(int Note)
{
// all notes transposed up three tones because chip starts at D# not C       }
 outport(LPTx,T[Note + 3]);
 delay(150);
 if(kbhit())
  exit(0);                     // exit program when key pressed
}

void Display_Music(void)
{

 clrscr();
 gotoxy(10,2); printf("-=[ DILL PICKLE RAG ]=-  by Charles L. Johnson ");
 gotoxy(10,4); printf("    transcribed by Paul Bergsman, 11/10/1992 ");
 gotoxy(75,7);
 printf
 ("O\n");
 printf
 ("#\n");
 printf
 ("                                                             O           \n");
 printf
 ("#\n");
 printf
 ("                                             O  #O\n");
 printf
 ("\n");
 printf
 ("			            O  #O\n");
 printf
 ("#\n");
 printf
 ("                    O #O\n");
 printf
 ("\n");
 printf
 ("          O  #O\n");
 printf
 ("-- #--\n\n");
 printf
 ("-3   -2  -1   1   2  3  4  5   6  7   8   9  10  11  12  13  14  15  16  17\n");
}

void main()
// my third party printer card used for development work is at LPT2
{
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 Display_Music();

 do
 {
  gotoxy(5,24); printf("PLAYING PART A");
  for (E=1;E<=Intro[0];E++)
   Play_Note(Intro[E]);
  for(E=1;E<=Line_1[0];E++)
   Play_Note(Line_1[E]);
  for(E=1;E<=End_A1[0];E++)
   Play_Note(End_A1[E]);
  for(E=1;E<=Line_1[0];E++)
   Play_Note(Line_1[E]);
  for(E=1;E<=End_A2[0];E++)
   Play_Note(End_A2[E]);
  gotoxy(5,24); printf("                 PLAYING PART B     ");
  for(E=1;E<=Line_2[0];E++)
   Play_Note(Line_2[E]);
  for(E=1;E<=End_B1[0];E++)
   Play_Note(End_B1[E]);
  for(E=1;E<=Line_2[0];E++)
   Play_Note(Line_2[E]);
  for(E=1;E<=End_B2[0];E++)
   Play_Note(End_B2[E]);
  gotoxy(5,24); printf("                 PLAYING PART C");
  for(A=1;A<=2;A++)
  {
   for(E=1;E<=Line_3[0];E++)
    Play_Note(Line_3[E]);
   for(E=1;E<=Line_4[0];E++)
    Play_Note(Line_4[E]);
   for(E=1;E<=Line_5[0];E++)
    Play_Note(Line_5[E]);
   if(A==1)
   {
    for(E=1;E<=Line_6[0];E++)
     Play_Note(Line_6[E]);
   }
   else
   {
    for(E=1;E<=Line_7[0];E++)
    Play_Note(Line_7[E]);
   }                           //just keep playing the song
  }
 }while(!kbhit);
}