 /*                      PROGRAM PWM_8253
		  Code conversion by Eugene Klein
    Generate Pulse Width Modulation from Intel's 8253 Interval Timer IC
 */


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int ESC = 0x1B;

const int A0 = 1;   // D0, Bit 1, = Strobe at Base-Address + 2
const int A1 = 2;   // D1, Bit 2, = Auto-Feed at Base-Address + 2
const int WR = 4;   // D2, Bit 3, = Initialize at Base-Address + 2
const int CS = 8;   // D3, Bit 4, = Select-Input at Base-Address + 2

unsigned char  Data, Counter_Number, Control_Lines,Control_Word[2],Lpt_Num;
unsigned int LPTx, Data_Word;
int Initial_Word, Num, E;
char Ch;

void Set_Control_Words(void)
{
/* Computer Control Word Values to set Counter 0  for squarewave output.
   Counter 1 for pulse generator, and Counter 2 as a software triggered
    one-shot pulse generator.

   -=[ COUNTER 0 Control Word  ]=- }
   Set Control-Word for Counter 0 to Mode 3, "Square Wave Rate Gen."
   Mode 3 allows the counter to output a continuous square wave.
   For example if the counter is programmed with a 10, the
   output will be low for five clock counts, and high for five clock
   counts.  The gate is used to start ( logic 1 ) and stop ( logic 0 )
   the count.

	 Base + 2 pin labels =        D7  D6  D5  D4    D3  D2  D1  D0
	 8253's pin labels   =       Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD
		  select counter       0   0
	       Load LSB then MSB               1   1
		   Select Mode 3                         0   1   1
	 No Binary Coded Decimal                                     0
				   -----------------------------------  */
 Control_Word[0] = 0x36;         //    0   0   1   1     0   1   1   0

/*-=[ COUNTER 1 Control Word ]=- }
   Set Control Word for counter 1, to Mode 2, "Rate Generator"
   Mode 2 allows the counter to generate a series of continuous
   pulses that are one clock pulse in width.  The separation between
   pulses is determined by the count.  For example,  if the count is a
   10, the output will be a logic 1 for nine clock pulses and low
   ( logic 0 ) for one.  This cycle is repeated until the counter is
   reprogrammed with a new count.  The gate input is used to start
   ( logic 1 ) and stop ( Logic 0 ) the count.

    // Base + 2 pin labels =        D7  D6  D5  D4    D3  D2  D1  D0
    //
    // 8253's pin labels   =       Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD
    //          select counter       0   1
    //       Load LSB then MSB               1   1
    //           Select Mode 2                         0   1   0
    // No Binary Coded Decimal                                     0
    //                           -----------------------------------   */
 Control_Word[1] = 0x74;     //       0   1   1   1     0   1   0   0

/*   =[ COUNTER 2 Control Word ]=- }
      Set Counter 2 to Mode 5, "Hardware Triggered Strobe"
      Mode 5 allows the counter to generate a single pulse after it is
      triggered by a gate input.   For example, if a count of 5 is
      programmed, the output will remain high until five clock  counts
      after the gate trigger pulse ( logic 1 ) and then go low for an
      additional clock count.  The output is a, one shot, pulse.                           }

       Base + 2 pin labels =        D7  D6  D5  D4    D3  D2  D1  D0
       8253's pin labels   =       Sc1 Sc0 RL1 RL0    M2  M1  M0 BCD
		select counter       1   0
	     Load LSB then MSB               1   1
		 Select Mode 5                         1   0   1
       No Binary Coded Decimal                                     0
				 -----------------------------------   */
 Control_Word[2] = 0xBA; //           1   0   1   1     1   0   1   0
}

void Send_Control(unsigned char Counter_Num)
{
 outport(LPTx,Control_Word[Counter_Num]);
				    //   INTEL 8253 PINS:  CS   WR   A1   A0  }
				    //                     __        __   __  }
				    // PRINTER PORT PINS:  D3   D2   D1   D0  }
 outport(LPTx + 2,0x4); // Set ALL  control lines HIGH;     0    1    0    0  }
 outport(LPTx + 2,0xC); // set CS line to active LOW        1    1    0    0  }
 outport(LPTx + 2,0x8); // set WR line to active LOW        1    0    0    0  }
 outport(LPTx + 2,0xC); // set WR line to inactive HIGH     1    1    0    0  }
 outport(LPTx + 2,0x4); // set CS line to inactive HIGH     0    1    0    0  }
}

void Send_Data(unsigned char Counter_Num, unsigned char Data)
// The procedure demonstrates how to send data to an 8253 counter.           }
// YES, I know this code can be compressed, BUT then it would loose          }
// it's clarity.                                                             }
{
 outport(LPTx,Data);     // load the data onto the data lines                   }
 switch(Counter_Num)
 {
  case 0 :
			   //                INTEL 8253 PINS:  CS   WR   A1   A0  }
			   //                                  __        __   __  }
			   //              PRINTER PORT PINS:  D3   D2   D1   D0  }
   outport(LPTx + 2,0x4); // turn ALL lines to inactive HIGHs  0    1    0    0  }
   outport(LPTx + 2,0x7); // Set A0 and A1 to binary zero      0    1    1    1  }
   outport(LPTx + 2,0xF); // set CS line to active LOW         1    1    1    1  }
   outport(LPTx + 2,0xB); // set WR line to active LOW         1    0    1    1  }
   outport(LPTx + 2,0xF); // set WR line to inactive HIGH      1    1    1    1  }
   outport(LPTx + 2,0x7); // set CS line to inactive HIGH      0    1    1    1  }
   printf("case = %i\n", Counter_Num);
   break;

  case 1 :
			 //                INTEL 8253 PINS:  CS   WR   A1   A0  }
			 //                                  __        __   __  }
			 //              PRINTER PORT PINS:  D3   D2   D1   D0  }
   outport(LPTx +2,0x4); // turn ALL lines to inactive HIGHs  0    1    0    0  }
   outport(LPTx +2,0x7); // Set A0 and A1 to binary one       0    1    1    0  }
   outport(LPTx +2,0xF); // set CS line to active LOW         1    1    1    0  }
   outport(LPTx +2,0xB); // set WR line to active LOW         1    0    1    0  }
   outport(LPTx +2,0xF); // set WR line to inactive HIGH      1    1    1    0  }
   outport(LPTx +2,0x7); // set CS line to inactive HIGH      0    1    1    0  }
   printf("case = %i\n", Counter_Num);
   break;

  case 2 :
			 //                INTEL 8253 PINS:  CS   WR   A1   A0  }
			 //                                  __        __   __  }
			 //              PRINTER PORT PINS:  D3   D2   D1   D0  }
   outport(LPTx +2,0x4); // turn ALL lines to inactive HIGHs  0    1    0    0  }
   outport(LPTx +2,0x7); // Set A0 and A1 to binary two       0    1    0    1  }
   outport(LPTx +2,0xF); // set CS line to active LOW         1    1    0    1  }
   outport(LPTx +2,0xB); // set WR line to active LOW         1    0    0    1  }
   outport(LPTx +2,0xF); // set WR line to inactive HIGH      1    1    0    1  }
   outport(LPTx +2,0x7); // set CS line to inactive HIGH      0    1    0    1  }
   printf("case = %i\n", Counter_Num);
 }
}

void Adjust_Frequency(unsigned char Counter_Number)
{
 if(Counter_Number==0 | Counter_Number==1)
 {
  switch(Counter_Number)
  {
   case 0 :  // set up counter 1 as a square wave generator }
    printf("Setting up COUNTER 1 as a square wave generator \n");
    do
    {
     do
     {
      Ch  = getch();
     }while(Ch != 73 & Ch != 81 & Ch != 27);
      switch(Ch)
     {
      case 73 :
       if(Data_Word < 0xE000)
	Data_Word  = Data_Word + 0x0FFF;
	break;
      case 81 :
       if(Data_Word > 0x100F)
	Data_Word  = Data_Word - 0x0FFF;
	break;
      //case 27 :
       //exit(0);      // pressing ESC key exits program }
     }
     printf(" DATA WORD = %u\n\n",Data_Word);
     Counter_Number  = 0;
     Send_Control(Counter_Number);
     Send_Data(Counter_Number, (Data_Word & 0xff));
     Send_Data(Counter_Number, Data_Word >>8);
     // pressing ESC key exits program }
    }while(Ch != ESC);
   break;

   case 1 :
    printf("Set up counters 1 and 2 for Pulse Width Modulation \n");
// set Counter 1 as a software triggered, pulse generator                     }
    Counter_Number  = 1;
    Send_Control(Counter_Number);
    Data_Word  = 0xFFFF;            // set to longest time period possible     }
    Send_Data(Counter_Number, Data_Word & 0xff);
    Send_Data(Counter_Number, Data_Word >> 8);
    do
    {
      do
      {
       Ch  = getch();
      }while(Ch != 73 & Ch != 81 & Ch != 27);
      switch(Ch)
      {
       case 73 :
	if(Data_Word < 0xE000)
	  Data_Word  = Data_Word + 0x0FFF;
	  break;
       case  81 :
	if(Data_Word > 0x100F)
	 Data_Word  = Data_Word - 0x0FFF;
	 break;
       //case 27:
	//exit(0);      // pressing ESC key exits program }
       }
     printf(" DATA WORD = %u\n\n",Data_Word);
       // set counter 2 as a hardware triggered, one shot, pulse generator           }
     Counter_Number  = 2;
     Send_Control(Counter_Number);
     Send_Data(Counter_Number, Data_Word & 0xff);
     Send_Data(Counter_Number, Data_Word >> 8);
    }while(Ch != ESC);
  } // pressing ESC key exits program }
 }
}

void main()
{
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 clrscr(); 
 Set_Control_Words();
 outport(LPTx + 2,0x04);  // = 0000 0100 Binary,   Initialize the control lines  }
 // start counter 0, as a square wave generator }
 Initial_Word  = 0x7FFF; // set initial frequency a about the middle of range   }
 //         -=[ SET UP COUNTER 0 AS A SQUARE WAVE GENERATOR ]=-                }
 Counter_Number  = 0;
 Send_Control(Counter_Number);
 Send_Data(Counter_Number, Initial_Word & 0xff);
 Send_Data(Counter_Number, Initial_Word >> 8);
 Adjust_Frequency(Counter_Number);
 //         -=[ SET UP COUNTERS 1 and 2 AS A PULSE WIDTH GENERATOR             }
 Counter_Number  = 1;
 Send_Control(Counter_Number);
 Send_Data(Counter_Number, Initial_Word & 0xff);
 Send_Data(Counter_Number, Initial_Word >> 8);
 Adjust_Frequency(Counter_Number);

}

