 PROGRAM Adc_0804;
  { Uses the parallel printer port to input analog data converted to         }
  {  8 bit binary by an ADC-0804 Analog / Digital, ( A/D ), converter IC     }

USES DOS, CRT;

CONST   Wr = $01;               { D0, at Base Address = Write line           }

VAR  Lpt_Num, Lpt_Port_Address : WORD;
      RD, New_Value, Old_Value : INTEGER;
                         Volts : REAL;
          Lo_Nibble, Hi_Nibble : BYTE;

PROCEDURE Read_Data( VAR Lo_Nibble, Hi_Nibble : BYTE);
BEGIN
{ pull-up all Base + 2, open collector output pins, BEFORE read instruction }
PORT[Lpt_Port_Address + 2] := $04; { 00000100 since D1, 2, & 3 are inverted }
Lo_Nibble := PORT[Lpt_Port_Address + 2];
Hi_Nibble := PORT[Lpt_Port_Address + 1];
END; { read data }

PROCEDURE Start_Conversion;
{ ADC-0804 will start new conversion each time  WR line is strobed          }
BEGIN
Port[Lpt_Port_Address] := WR; { while software digest the current data      }
Port[Lpt_Port_Address] := 0;  { Strobe 0804 WR line to start new conversion }
Port[Lpt_Port_Address] := WR; { while software digests the current data     }
END; { start next conversion }

PROCEDURE Digest_Data(VAR Lo_Nibble, Hi_Nibble : BYTE);
BEGIN
Lo_Nibble := Lo_Nibble AND $0F;
Hi_Nibble := Hi_Nibble AND $F0;
RD := Hi_Nibble OR Lo_Nibble;
New_Value := RD;
END; { digest data }

PROCEDURE Print_Results;
{ display the hi nibble, lo nibble, raw data, and scaled voltage value }
BEGIN
GoToXY(1,10); { go to first position of the tenth line                      }
Writeln('High Nibble = ',Hi_Nibble:3, ';       Low Nibble = ',Lo_Nibble:3);
Volts := RD * 5 / 255;
Writeln; write('Raw Value = ',RD:3,';          Volts = ',Volts:5:2);
Old_Value := New_Value;
END; { print results }

BEGIN { main }
Lpt_Port_Address := 632;  { MGA = 956, CGA = 888, and 3ed port = 632 }
New_Value := 0; Old_Value := 1;
Start_Conversion;
ClrScr;
  REPEAT
  Read_Data(Lo_Nibble, Hi_Nibble);
  Start_Conversion;
  Digest_Data(Lo_Nibble, Hi_Nibble);
    { only waist time going to the screen if reading has changed }
  IF New_Value <> Old_Value THEN  Print_Results;
  UNTIL KEYPRESSED;
END. { main, ADC_0804 }

