
PROGRAM AD_SER;   { -=[ input analog data from a serial A/D, the TLC548  }
USES CRT, DOS;
VAR              Lpt_Num : INTEGER;
        Lpt_Port_Address : WORD;

PROCEDURE Select_Printer_Port(VAR Num : INTEGER; VAR Lpt_Port_Address : WORD);
 {  Ask user which printer port to use.  Check to make sure                 }
 {  that printer port is available.  Function returns port                  }
 {  address of selected printer port.                                       }
 { The Programmer's PC Sourcebook, MicroSoft Press, 1991, Page 7-75,        }
 { Compute's Mapping the IBM PC, Compute Books, 1985, page 234              }
CONST Base_Address = 1024;  { base address for IBM printer ports }
VAR              Temp, Offset : INTEGER;
                           Ch : CHAR;
BEGIN
REPEAT
ClrScr; WRITELN; WRITELN; WRITELN;
WRITELN; WRITE('Do you want to use LPT 1, 2, or 3: ');
  REPEAT
  Read(Num);
  IF Num IN [1..3] THEN BEGIN END
    ELSE BEGIN
         WRITE(CHAR(7)); WRITELN;
         WRITE('You must enter a number; 1, 2, or 3: ');
         END;
   UNTIL Num IN [1..3];

Offset := (2 * Num) + 6; { 8 = LPT1, 10 = LPT2, and 12 = LPT3 }
  IF Offset = 0 THEN
    BEGIN
    WRITELN;
    WRITELN('Port selected is not installed on this machine.');
    WRITELN; WRITELN('PRESS ANY KEY TO CONTINUE:');
    REPEAT UNTIL KEYPRESSED; Ch := Readkey;
    END
  ELSE Lpt_Port_Address := MemW[0: Base_Address + Offset];
UNTIL Offset <> 0;
END; { find lpt1 }

PROCEDURE Run_TLC548(Lpt_Port_Address : WORD);
CONST t = 1;         { value for time delay, will vary with computer model }
{
  Use printer port, base address, bit D0, for Clock, CLK.
  Use printer port, base address, bit D1, for Chip Select, CS.
  Use printer port, base address + 1, bit D7, for serial data input.
}
   (* sub *) PROCEDURE Init_Port;

              { -Set CLK, at printer port D0, LOW, and Set CS,
                   at printer port D1, to INACTIVE HIGH.
                -Delay, so chip can digest the instruction
              }
             BEGIN
             PORT[Lpt_Port_Address] := 2;   { 00000010 }
             DELAY(t);
             PORT[Lpt_Port_Address] := 0;  { set CS and CLK low  }
             DELAY(T);
             END; { sub, init port }

   (* sub *) PROCEDURE Start_up;
             {
               chip counts two clock ticks before outputing data
             }
             BEGIN
             PORT[Lpt_Port_Address] := 0;  { set CS and CLK low  }
             DELAY(t);
             PORT[Lpt_Port_Address] := 1;  { set CLK high }
             DELAY(t);
             PORT[Lpt_Port_Address] := 0;  { set CLK low  }
             DELAY(t);
             END;

   (* sub *) PROCEDURE Strobe_CLK;
             {
               each clock strobe puts next data bit on D_out, pin 6
             }
             BEGIN
             PORT[Lpt_Port_Address] := 0;  { set CLK low  }
             DELAY(t);
             PORT[Lpt_Port_Address] := 1;  { set CLK high }
             DELAY(t);
             PORT[Lpt_Port_Address] := 0;  { set CLK low  }
             DELAY(t);
             END;

   (* sub *) PROCEDURE Input_Data;
             {
               input serial data bits and display value as they are read in
             }
             VAR Data, Mask, Bite : BYTE;
                               Ch : CHAR;
             BEGIN { input data }
             Mask := 128;  { bit value for printer port, base + 1, D7 }
               REPEAT
               Start_up;
               GOTOXY(1,5);
               WRITELN('BIT  VALUE'); WRITELN;

{ input D7 }   PORT[Lpt_Port_Address] := 0;  { set CS LOW, CLK LOW }
               DELAY(t); Bite := ( PORT[Lpt_Port_Address + 1]);
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := 128 ELSE Data := 0;
{ display  }   WRITELN('D7:  ', ((data AND 128) ):3);

{ input D6 }   Strobe_CLK; Bite :=  ( PORT[Lpt_Port_Address + 1] );
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := Data OR 64;
{ display  }   WRITELN('D6:  ', ((data AND 64) ):3);
               Strobe_CLK;

{ input D5 }   Strobe_CLK; Bite :=  ( PORT[Lpt_Port_Address + 1] );
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := Data OR 32;
{ display  }   WRITELN('D5:  ', ((data AND 32) ):3);

{ input D4 }   Strobe_CLK; Bite :=  ( PORT[Lpt_Port_Address + 1] );
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := Data OR 16;
{ display  }   WRITELN('D4:  ', ((data AND 16) ):3);

{ input D3 }   Strobe_CLK; Bite :=  ( PORT[Lpt_Port_Address + 1] );
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := Data OR 8;
{ display  }   WRITELN('D3:  ', ((data AND 8) ):3);

{ input D2 }   Strobe_CLK; Bite :=  ( PORT[Lpt_Port_Address + 1] );
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := Data OR 4;
{ display  }   WRITELN('D2:  ', ((data AND 4) ):3);

{ input D1 }   Strobe_CLK; Bite :=  ( PORT[Lpt_Port_Address + 1] );
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := Data OR 2;
{ display  }   WRITELN('D1:  ', ((data AND 2) ):3);

{ input D0 }   Strobe_CLK; Bite :=  ( PORT[Lpt_Port_Address + 1] ) ;
{ process  }   IF (Bite AND Mask ) <> Mask THEN Data := Data OR 1;
{ display  }   WRITELN('D0:  ', ((data AND 1) ):3);

               WRITELN; WRITELN; WRITELN('Data = ',Data:3);
               IF KeyPressed THEN Ch := ReadKey;
               UNTIL ORD(Ch) = 27;                 { press ESC to end program }
             END; { input data }

BEGIN { run TLC548 }
Init_Port;
Input_Data;
END; {  run TLC548 }

BEGIN { main }
Select_Printer_Port(Lpt_Num, Lpt_Port_Address);
ClrScr;
Run_TLC548(Lpt_Port_Address);
END. { main }
