
PROGRAM Batch_Sw;  { written in Turbo Pascal, 5.5 }
{
  This program is run at the start of an Autoexec.BAT file. It will read
  switches connected to a parallel printer port. It leave the value,
  (0 - 255 ), as an ERROR CODE for the remaining AUTOEXEC.BAT code.
  Using Autoexec.bat's GOTO command, I can branch to different system
  configurations at boot up.

  I mounted my eight switches on an unused disk drive bay panel.

  If switches are concealed, this setup cam provide a security padlock.

  All IBM / IBM clone computers support three printer port locations:
    BASE = 3BC HEX = 956 DECIMAL = MGA Graphics Card's printer port
    BASE = 378 HEX = 888 DECIMAL = CGA Graphics Card's printer port
    BASE = 278 HEX = 632 DECIMAL = PS/2 printer port,  XT & AT's 3ed PRN port

  The high nibble is read from Base + 1, the low nibble from Base + 2.
}

VAR Exit_Save         : POINTER;
    Base, Error_Code  : INTEGER;
    B, Lo_Bit, Hi_Bit : BYTE;

{$F+}
PROCEDURE My_Exit;
{ Based on procedure  in Turbo Pascal 5.5 Reference Manual, page 229         }
BEGIN { my exit }
ExitProc := Exit_Save;
WRITELN; WRITELN( 'ErrorCode being left = ',Error_Code); WRITELN;
ExitCode := Error_Code;
ErrorAddr := NIL;
END; { my exit }
{$F-}

BEGIN { batch_sw }
Base := 632;             { Address setting on my third party printer card }
B := PORT[base + 2];
PORT[base + 2] := B or 32;  { set port's BASE + 2 address to input data   }
Lo_Bit := Port[Base] + 2;   { D0 - D3 connected to DB-25 pins  1,14,16,17 }
Hi_Bit := Port[base] + 1;   { D4 - D7 connected to DB-25 pins 13,12,10,11 }
   { leave error code byte for autoexc.bat }
Error_Code := (Hi_Bit AND $F0) + (Lo_Bit AND $0F);
Exit_Save := ExitProc;
ExitProc := @My_Exit;
END. {  batch_sw }

