PROGRAM Sort_Demo;
{
  Fastest internal memory sort method I know of.  The theory is simple.
  THEORY: A big list is easier to sort if you "divide and conquer".
  Quick_Sort repeatedly cuts the file in half until a section has 10 or
  less elements.  The program then uses Sifting_Sort to sort the short list.

  By simply changing a global variable, you can sort various variable types!

  Based on a main frame program in "Sorting and Sort Systems", by Harold
  Lorin, Addison and Wesley Pub., 1975, A-68 to A-70.
 }
USES CRT;

TYPE Element_Type = INTEGER;
        List_Type = Array[0..10000] OF Element_Type;

CONST  Number_of_Elements = 7322;

VAR        List : List_Type;
    E, X, count : INTEGER;
             Ch : CHAR;

PROCEDURE Bullet_Sort(Elements_In_Array : INTEGER;
                               VAR List : List_Type);
VAR Piv, Temp : Element_Type;
    Bot, Top, N, Ey, Ld, Med, Pt, Num : INTEGER;
    Tp, Bt : ARRAY [0..31] OF INTEGER;

{ sub } PROCEDURE Quick_Sort;
BEGIN
Med := (Pt + N) DIV 2; Piv := List[Med]; Top := Pt; Bot := N;
If List[Pt] > Piv THEN
  BEGIN List[Med] := List[Pt]; List[Pt] := Piv; Piv := List[Med] END;
If List[N] < Piv THEN
  BEGIN
  List[Med] := List[N]; List[N] := Piv; Piv := List[Med];
  If List[Pt] > Piv THEN
    BEGIN List[Med] := List[Pt]; List[Pt] := Piv; Piv := List[Med] END;
  END;
  REPEAT
  Ey := 0; Bot := Bot - 1;
  WHILE List[Bot] > Piv DO Bot := Bot -1;
  Temp := List[Bot];
  Top := Top + 1;           (* find the largest value in segment *)
  WHILE List[Top] < Piv DO Top := Top + 1;
  If Top <= Bot THEN
    BEGIN LIST[Bot] := List[Top]; List[Top] := Temp; Ey := 1; END
  ELSE
    BEGIN { else }
    IF Bot - Pt < N - Top THEN
      BEGIN Tp[Ld] := Pt; Bt[Ld] := Bot; Pt := Top END
    ELSE BEGIN Tp[Ld] := Top; Bt[Ld] := N; N := Bot END;
    END; { else }
  UNTIL Ey = 0;
END; { quicksort }

{ sub } PROCEDURE Sifting_Sort;
VAR I : INTEGER;
BEGIN
IF (( N - Pt) <= 10 ) AND ((Pt <> 0) AND (Pt >= N)) THEN
  BEGIN
  FOR I := Pt + 1 TO N DO
    BEGIN { for }
    Piv := List[I];  Top := I - 1;
    WHILE List[Top] > Piv DO
      BEGIN List[Top + 1] := List[Top]; Top := Top - 1; END;
    List[Top + 1] := Piv;
    END; { for }
  Ld := Ld - 1;
  IF Ld >= 1 THEN BEGIN Pt := Tp[Ld]; N := Bt[Ld]; Sifting_Sort END;
  END; { if }
END; { sifting sort }

BEGIN { my bullet sort }
Pt := 1; Ld := 1; Num := Elements_In_Array; N := Num;
Sifting_Sort;
WHILE Ld > 0 DO BEGIN Quick_Sort; Ld := Ld + 1; Sifting_Sort END;
END; { my bullet sort }

PROCEDURE Display_Array;
BEGIN
FOR E := 1 TO Number_of_Elements DO
  BEGIN
  WRITE(List[E]:7,':');
  IF E MOD 8 = 0 THEN WRITELN;
  END;
end; { display array }

BEGIN { sort demo }
{ generate a list of 5000 numbers
  display the list
  sort the list using my fast sort
  display the sorted list
}
ClrScr;
RANDOMIZE;
FOR E := 1 TO Number_of_Elements DO
  BEGIN X := RANDOM(5000); count := 0; List[E] := X; END;
Display_Array; readln(Ch);
Bullet_Sort(Number_of_Elements , List);
WRITELN; Display_Array; Readln(Ch);
END. { sort demo }





