PROGRAM Optos;
USES CRT, Printer;
{
   Repeatedly turn each opto-coupler high and low until any key is pressed.
   Uses LPT1 for interfacing.
}
CONST  D0_High = 1;  { photo-transistor opto-coupler }
       D0_Low  = 0;
       D1_High = 2;  { SCR opto-coupler              }
       D1_Low  = 0;
       D3_High = 8;  { triac opto-coupler            }
       D3_Low  = 0;
       D5_High = 0;  { SSR, solid state relay        }
       D5_Low  = 32;
       Time = 500;
VAR E : INTEGER;

PROCEDURE Transmit_Data(High_Bit_Value, Low_Bit_Value : BYTE);
{
Send data out LPT1, parallel printer port.
Sequence:
  set bit to active high
  delay
  set bit ti active low
  delay
}

BEGIN
WRITE(LST, CHAR(High_Bit_Value));
DELAY(Time);
WRITE(LST, CHAR(Low_Bit_Value));
DELAY(Time);
END; { transmit data }

BEGIN { main, opto }
  REPEAT
  Transmit_Data(D0_High, D0_Low);  { photo-transistor opto-coupler }
  Transmit_Data(D1_High, D1_Low);  { SCR opto-coupler              }
  Transmit_Data(D3_High, D3_Low);  { triac opto-coupler            }
  Transmit_Data(D5_High, D5_Low);  { SSR opto-coupler              }
  UNTIL KEYPRESSED
END. { main, optos }
