;testcom.asm
code      segment para 'CODE'     ;Definition of CODE-segments

          org 100h                ;starts at Address 100(h)
                                  ;directly behind the PSP

          assume cs:code, ds:code, es:code, ss:code

                                  ;all  segments point to the CODE 
                                  ;segment

start:    jmp  init               ;Call of the Initialization Routine

;== Data  =============================================================

          ;-- Data, Buffers and ----------
          ;-- Variables can be stored here 

;== Program ===========================================================

prog      proc near               ;this Procedure is the actual
                                  ;Main program and is executed after
                                  ;the Initialization 


          mov  ax,4C00h           ;Terminate Program through calling a
          int  21h                ;DOS function on error code 0

prog      endp                    ;End of the PROG procedure 

;-- Initialization ----------------------------------------------------

init:     mov  ah,4Ah             ;Change Function number for memory size
          mov  bx,offset endp     ;Calculate number of paragraphs (16 byte
          mov  cl,4               ;each) available to the program 
          shr  bx,cl              
          inc  bx
          int  21h                ;Call function through DOS-Interrupt 
          mov  sp,offset endp     ;Set new stack-Pointer
          jmp  prog

init_end label near

;== stack =============================================================


          dw (256-((init_end-init) shr 1)) dup (?)

                                  ;the stack has 256 Words, but includes
                                  ;the code of the INIT-Routine which
                                  ;after its execution is no longer needed

endp      equ this byte           ;End of memory used by this
                                  ;program

;== End ===============================================================

code      ends                    ;End of the CODE-segment
          end  start              ;End of the Assembler-Program. For
                                  ;execution use START command
