; testexe.asm
;== stack =============================================================

stack     segment para stack      ;Definition of the stack-segment

          dw 256 dup (?)          ;the stack has 256 Words 

stack     ends                    ;End of the stack-segment

;== Data ==============================================================

data      segment para 'DATA'     ;Definition of the Data-segment

          ;all data, buffers and variables can be stored here

data      ends                    ;End of the Data segment

;== Code ===============================================================

code      segment para 'CODE'     ;Definition of the CODE-segment

          assume cs:code, ds:data, ss:stack

                                  ;CS defines the Code, DS
                                  ;the Data and SS the stack
                                  ;segment

prog      proc far                ;this procedure is the actual 
                                  ;Main program and is executed after  
                                  ;the program start 

          mov  ax,data            ;Load segment address of the Data segment into
          mov  ds,ax              ;the DS-Register 
          call setfree            ;release memory not needed 

          ;store application program here  ----------------------

          mov  ax,4C00h           ;terminate with call of DOS function
          int  21h                ;on return of error code 0
                                  ;terminate 

prog      endp                    ;End of PROG Procedure

;-- SETFREE  : release memory storage not occupied  ----------------
;-- Inputt   : ES = Address of PSP
;-- Output   : none 
;-- Register : AX, BX, CL and FLAGS are changed 
;-- Info     : Since the stack-segment is always the last segment in an 
;              EXE file, ES:0000 points to the beginning and SS:SP
;              to the end of the program in storage. Because of this the
;              length of the program can be calculated. 

setfree   proc near

          mov  bx,ss              ;subtract the two segment addresses 
          mov  ax,es              ;from each other. The result is the 
          sub  bx,ax              ;number of paragraphs from PSP to 
                                  ;the beginning of the stack
          mov  ax,sp              ;since the stackpointer is a the end 
          mov  cl,4               ;of the stack segment, its content 
          shr  ax,cl              ;gives the length of the stacks 
          add  bx,ax              ;add to the present length 
          inc  bx                 ;one more paragraph as a precaution 
          mov  ah,4ah             ;pass new size to DOS 
          int  21h

          ret                     ;back to calling program 

setfree   endp

;== End ===============================================================

code      ends                    ;End of the CODE-segment
          end  prog               ;End of the Assembler program. 
                                  ;Start execution with the PROG procedure
