{*********************************************************************}
{*                             C O N F I G P                PASCAL   *}
{*-------------------------------------------------------------------*}
{*    Task        : Outputs the Configuration of the PC on the       *}
{*                  Display Screen                                   *}
{*-------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                               *}
{*    developed on   : 7/7/87                                        *}
{*    last Update    : 5/18/89                                       *}
{*********************************************************************}

program CONFIGP;


Uses Crt, Dos;                                      { Add DOS and Crt }

{*********************************************************************}
{* PRINTCONFIG: Display PC's configuration                           *}
{* Input : none                                                      *}
{* Output : none                                                     *}
{* Info    : The configuration output depends on the PC type         *}
{*********************************************************************}

procedure PrintConfig;

var AT   : boolean;                                { is the PC an AT? }
    Regs : Registers;          { Register variable for interrupt call }

begin
 clrscr;                                               { Clear screen }
 if mem[$F000:$FFFE] = $FC then AT := true            { test if AT or }
                           else AT := false;               { PC or XT }
 writeln('Configuration of this PC');
 writeln('----------------------------------------------------');
 write('PC-Type                : ');
 case mem[$F000:$FFFE] of                        { Read PC type again }
  $FF : writeln('PC');                                  { $FF is a PC }
  $FE : writeln('XT');                                 { $FE is an XT }
  $FC : writeln('AT')                                  { $FC is an AT }
  else writeln('Unknown');
 end;
 write('Processor              : INTEL ');
 if AT then writeln('80286')                   { the AT has an 80286, }
       else writeln('8088');       { PC and XT have an 8088 processor }
 intr($12, Regs);
 writeln('RAM-Memory             : ',Regs.ax,' KB');
 if AT then                                        { is the PC an AT? }
  begin                                                         { YES }
   Regs.ah := $88;          { Function number for additional RAM size }
   Intr($15, Regs);                    { Call BIOS cassette interrupt }
   writeln('additional RAM    : ',Regs.ax,' KB beyond 1 MB');
  end;
Intr($11, Regs);                   { Call BIOS configuration interrupt}
 write('Video mode after start : ');
 case Regs.al and 48 of                        { Determine video mode }
   0 : writeln('undefined');
  16 : writeln('40x25 character color card');
  32 : writeln('80x25 character color card');
  48 : writeln('80x25 character mono card')
 end;
 writeln('Disk  drives           : ', succ(Regs.al shr 6 and 3));
 writeln('RS-232  cards          : ', Regs.ah shr 1 and 3);
 writeln('Printer cards          : ', Regs.ah shr 6)
end;

{*********************************************************************}
{*                            MAIN PROGRAM                           *}
{*********************************************************************}

begin
 PrintConfig;                                 { Display configuration }
end.
