
{*********************************************************************}
{*                             K E Y P                               *}
{*-------------------------------------------------------------------*}
{*    Task           : makes a function available for reading a      *}
{*                     character from the keyboard and outputting    *}
{*                     the Status of the control keys (INSERT,       *}
{*                     CAPS, NUM) on the display.                    *}
{*-------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                               *}
{*    developed on   :  07/08/87                                     *}
{*    last Update    :  06/10/89                                     *}
{*********************************************************************}

program KEYP;


Uses  Crt,Dos;                                   { Add Crt, Dos units }

{$V-}                                { Suppresses string length check }

type FlagText = string[6];           { used for passing the Flag-Name }


const FZ       = 1;              { Line in which the Flags are output }
      FS       = 65;             { Column from which Flags are output }
      FlagFore = 0;                       { Foreground color of Flags }
      FlagBck  = 7;                       { Background color of Flags }

       {** BIOS keyboard status bits *********************************}
       SCRL = 16;                                    { ScrollLock bit }
       NUML = 32;                                       { NumLock bit }
       CAPL = 64;                                      { CapsLock bit }
       INS = 128;                                         { Insert bit}
       {** Codes of some keys as presented by GETKEY *****************}
      BEL     = 7;                          { Code for bell character }
      BS      = 8;                     { Code for Backspace character }
      TAB     = 9;                           { Code for Tab character }
      LF      = 10;                               { Code for Linefeed }
      CR      = 13;                                 { Code for Return }
      ESC     = 27;                       { Code for Escape character }
      F1      = 315;                                { Code for F1 key }
      F2      = 316;                                { Code for F2 key }
      F3      = 317;                                { Code for F3 key }
      F4      = 318;                                { Code for F4 key }
      F5      = 319;                                { Code for F5 key }
      F6      = 320;                                { Code for F6 key }
      F7      = 321;                                { Code for F7 key }
      F8      = 322;                                { Code for F8 key }
      F9      = 323;                                { Code for F9 key }
      F10     = 324;                               { Code for F10 key }
      CUP     = 328;                             { Code for Cursor up }
      CLEFT   = 331;                          { Code for Cursor left  }
      CRIGHT  = 333;                          { Code for Cursor right }
      CDOWN   = 328;                           { Code for Cursor down }

var Insert,                                   { Status of INSERT flag }
    Num,                                         { Status of NUM flag }
    Caps     : boolean;                         { Status of CAPS flag }
    ForeColor,                             { current foreground color }
    BckColor,                              { current background color }
    key    : integer;                              { Code of key read }

{*********************************************************************}
{* NEGFLAG: negate Flag and output Text                              *}
{* Input : s.u.                                                      *}
{* Output : the new Status of the Flags (true = on, false = off)     *}
{*********************************************************************}

function NegFlag(Flag   : boolean;     { the last Status of the Flags }
                 FlagReg,      { current Status of the Flag (0 = off) }
                 Column,           { Column for the name of the Flags }
                 Cline  : integer;  { Line for the Names of the Flags }
                 Text   : FlagText) : boolean;    { Name of the Flags }

var CurCline,                                          { current Line }
    CurColumn : integer;                             { current Column }

begin
 if (Flag and (FlagReg = 0)) or                      { test if Status }
    (not(Flag) and (FlagReg <> 0)) then    { of the Flags has changed }
  begin                                                         { YES }
   CurCline := WhereY;                          { record current Line }
   CurColumn := WhereX;                       { record current Column }
   gotoxy(Column, Cline);          { Cursor to Position for Flag-Name }
   if FlagReg = 0 then                               { is Flag reset? }
    begin                                                       { YES }
     NegFlag := false;            { Result of the function : Flag off }
     textcolor(0);                        { Foreground color is black }
     textbackground(0);                   { Background color is black }
    end
   else
    begin                                            { Flag is now on }
     NegFlag:=true;                { Result of the function : flag on }
     textcolor(FlagFore);               { Foreground color is FLAGFORE}
     textbackground(FlagBck)            { Background color is FLAGBCK }
    end;
   write(Text);                             { Output name of the flag }
   gotoxy(CurColumn, CurCline);         { restore old cursor position }
   textcolor(ForeColor);               { restore old foreground color }
   textbackground(BckColor)            { restore old background color }
  end
  else
   NegFlag := Flag                  { Status of flags has not changed }
end;

{*********************************************************************}
{* GETKEY: Read a character and output the flag status               *}
{* Input : none                                                      *}
{* Output : Code of the key < 256 : normal key                       *}
{*                                     >= 256 : extended key         *}
{*********************************************************************}

function Getkey : integer;

var Regs : Registers;          { Register variable for interrupt call }
    keyRec :  boolean;            { indicates if key already received }

begin
 keyRec := false;                                   { no key received }
 repeat
  Regs.ah := $2;           { read function number for keyboard status }
  intr($16, Regs);                     { call BIOS keyboard interrupt }

  {** Adjust flags to new status *************************************}
  Insert := NegFlag(Insert, Regs.al and INS, FS+9, FZ, 'INSERT');
  Caps := NegFlag(Caps, Regs.al and CAPL, FS+3, FZ, ' CAPS ');
  Num := NegFlag(Num, Regs.al and NUML, FS, FZ, 'NUM');
  Regs.ah := $1;               { function number for character ready? }
  intr($16, Regs);                     { call BIOS keyboard interrupt }
  if (Regs.flags and FZero = 0) then
   begin
    KeyRec := true;
    Regs.ah := 0;
    intr($16, Regs);
    if (Regs.al = 0)                             { is zero flag set ? }
     then Getkey := Regs.ah or $100                             { YES }
     else Getkey := Regs.al;                                     { NO }
   end;
 until keyRec;                       { repeat until a key is received }
end;

{*********************************************************************}
{* INIKEY: initialize keyboard flags                                 *}
{* Input : none                                                      *}
{* Output : none                                                     *}
{* Info    : the keyboard flags are inverted from the current        *}
{*           status. This outputs their current                      *}
{*           status during the next call of the GETKEY function.     *}
{*********************************************************************}

procedure Inikey;

var Regs : Registers;          { Register variable for interrupt call }

begin
 Regs.ah := $2;            { Read function number for keyboard status }
 intr($16, Regs);                      { call BIOS keyboard interrupt }
 if (Regs.al and INS <> 0) then Insert := false        { INSERT flag  }
                               else Insert := true;             { set }
 if (Regs.al and CAPL <> 0) then Caps   := false          { CAPS flag }
                               else Caps   := true;             { set }
 if (Regs.al and NUML <> 0) then Num    := false           { NUM flag }
                               else Num    := true              { set }
end;

{*********************************************************************}
{* SCOLOR: sets foreground and background colors for display         *}
{* Input : see below                                                 *}
{* Output : none                                                     *}
{* Var.    : the color is stored in the global variables FORECOLOR   *}
{*           and BCKCOLOR                                            *}
{* Info    : this procedure must be called for setting the color     *}
{*           so that after the output of the keyboard flag status,   *}
{*           the current text color can be restored                  *}
{*           since in TURBO no functions exist for sensing           *}
{*           this color                                              *}
{*********************************************************************}

procedure Scolor(Foreground, Background : integer);

begin
 ForeColor := Foreground;                   { Record foreground color }
 BckColor := Background;                    { Record background color }
 textcolor(Foreground);                        { Set foreground color }
 textbackground(Background)                    { Set background color }
end;

{*********************************************************************}
{*                            MAIN PROGRAM                           *}
{*********************************************************************}

begin
 Inikey;                                  { Initialize keyboard flags }
 Scolor(7,0);                               { Color is white on black }
 clrscr;                                               { Clear screen }
 writeln(#13#10'KEYP (c) 1987 by Michael Tischer');
 writeln(#13#10'A few characters can be input now and switch '+
         'INSERT-, CAPS- or NUM-');
 writeln('mode on or off. The status of the three '+
         'modes is always displayed in');
 writeln('the upper right corner of the screen.');
 writeln('Pressing the <RETURN> or the <F1>-key terminates the '+
         'program...');
 write(#13#10'Your Input: ');
 repeat                                                  { Input loop }
  key := Getkey;                                            { Get key }
  if (key < 256) then write(chr(key))            { Output (if normal) }
 until (key = 13) or (key = F1);              { Repeat until F1 or CR }
 writeln;
end.
