{*********************************************************************}
{*                             V I D E O P                   PASCAL  *}
{*-------------------------------------------------------------------*}
{*    Task        : makes functions available which are              *}
{*                  based on the BIOS-Video-Interrupt but are not    *}
{*                  provided by PASCAL                               *}
{*-------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                               *}
{*    developed on   : 07/10/87                                      *}
{*    last Update    : 05/14/89                                      *}
{*********************************************************************}

program VIDEOP;


Uses Crt, Dos;                      { Adds DOS and CRT units to Turbo }

const NORMAL        = $07;        { Definition of character-attribute }
      BOLD          = $0f;        { in relation to a monochrome       }
      INVERS        = $70;        { Display card                      }
      UNDERLINE     = $01;
      BLINK         = $80;

type  TextTyp = string[80];

var  i,                          { Loop variable for the Main program }
     j,
     k,
     l       : integer;
     IString : string[2];                  { accepts number of Arrows }

{*********************************************************************}
{* GETVIDEOMODE: Read current Video mode and Parameters              *}
{* Input       : none                                                *}
{* Output      : The Variables listed below get the values after the *}
{*               call of the Procedure                               *}
{*********************************************************************}

procedure GetVideoMode(var VideoMode,  { Number of current Video mode }
                           Number,       { Number of Columns per Line }
                           Page   : integer);  { current display page }

var Regs : Registers;       { Register-Variable for call of Interrupt }

begin
 Regs.ah := $0F;                                    { Function number }
 intr($10, Regs);                         { Call BIOS-Video-Interrupt }
 VideoMode := Regs.al;                 { Number of Video mode }
 Number := Regs.ah;           { Number of characters per line }
 Page := Regs.bh;        { Number of the current display page }
end;

{*********************************************************************}
{* SETCURSORTYPE: defines the appearance of the blinking             *}
{*                Display cursor                                     *}
{* Input        : see below                                          *}
{* Output       : none                                               *}
{* Info         : for a monochrome display card the parameters       *}
{*                can be between 0 and 13, for a color display       *}
{*                card between 0 and 7                               *}
{*********************************************************************}

procedure SetCursorType(Beginline,     { Beginning line of the cursor }
                        Endl    : integer);  { End line of the cursor }

var Regs : Registers;      { Register variable for the interrupt call }

begin
 Regs.ah := 1;                                      { Function number }
 Regs.ch := Beginline;                                { Beginning and }
 Regs.cl := Endl;                                          { End line }
 intr($10, Regs);                         { Call BIOS-Video-Interrupt }
end;

{*********************************************************************}
{* SETCURSORPOS: defines the position of the cursor in the           *}
{*               display page output                                 *}
{* Input       : see below                                           *}
{* Output      : none                                                *}
{* Info        : The position of the blinking display cursor changes *}
{*               only through the call of this procedure, if the     *}
{*               indicated display page is the current display page  *}
{*********************************************************************}

procedure SetCursorPos(Page,           { display whose Cursor is set  }
                       Column,             { new Column of the Cursor }
                       Line   : integer);    { new Line of the Cursor }

var Regs : Registers;           { Register variable for the interrupt }

begin
 Regs.ah := 2;                                      { Function number }
 Regs.bh := Page;                                      { display page }
 Regs.dh := Line;                               { Display coordinates }
 Regs.dl := Column;
 intr($10, Regs);                         { Call BIOS-Video-Interrupt }
end;

{*********************************************************************}
{* GETCURSORPOS: senses the position of the cursor in a display      *}
{*               page and its start and end line                     *}
{* Input       : see below                                           *}
{* Output      : The variables listed below contain the values after *}
{*               the call of the procedure                           *}
{* Info        : the start and end line of the cursor is independent *}
{*               of the indicated display page                       *}
{*********************************************************************}

procedure GetCursorPos(Page : integer;             { the display page }
                       var Column,             { Column of the cursor }
                           Line,                 { Line of the cursor }
                           Beginline,      { Start line of the cursor }
                           Endl  : integer); { End line of the cursor }

var Regs : Registers;          { Register variable for the interrupt }

begin
 Regs.ah := 3;                                     { Function number }
 Regs.bh := Page;                                     { Display page }
 intr($10, Regs);                        { Call BIOS-Video-Interrupt }
 Column := Regs.dl;                         { Result of the Function }
 Line := Regs.dh;                           { read from the Register }
 Beginline := Regs.ch;                         { and store in proper }
 Endl := Regs.cl;                                        { Variables }
end;

{*********************************************************************}
{* SETDISPLAYPAGE: set the display page                              *}
{*                 for output on the monitor                         *}
{* Input         : see below                                         *}
{* Output        : none                                              *}
{*********************************************************************}

procedure SetDisplayPage(Page : integer);      { the new display page }

var Regs : Registers;          { Register variable for the interrupt }

begin
 Regs.ah := 5;                     { Function number and display page }
 Regs.al := Page;                                       { Screen page }
 intr($10, Regs);                         { Call BIOS-Video-Interrupt }
end;

{*********************************************************************}
{* SCROLLUP: scrolls a display area by one or more                   *}
{*           lines up or erases it                                   *}
{* Input   : see below                                               *}
{* Output  : none                                                    *}
{* Info    : If Number 0 is passed, the display area                 *}
{*           is filled with blanks                                   *}
{*********************************************************************}

procedure ScrollUp(Number,           { Number of lines to be scrolled }
                   COLOR,     { Attribute for the blank lines created }
                   ColumnUL,   { Column in the upper left hand corner }
                   LineUL,            { line in the upper left corner }
                   ColumnLR,       { Column in the lower right corner }
                   LineLR : integer);{ line in the lower right corner }

var Regs : Registers;       { Register variable for calling Interrupt }

begin
 Regs.ah := 6;                           { Function number and number }
 Regs.al := Number;
 Regs.bh := COLOR;                           { Color of empty line(s) }
 Regs.ch := LineUL;                                      { Upper left }
 Regs.cl := ColumnUL;                                   { coordinates }
 Regs.dh := LineLR;                                     { Lower right }
 Regs.dl := ColumnLR;                                   { coordinates }
 Intr($10,Regs);                          { Call BIOS-Video-Interrupt }
end;

{*********************************************************************}
{* SCROLLDOWN: Scrolls a display area by one or more                 *}
{*             lines down or erases it                               *}
{* Input     : see below                                             *}
{* Output    : none                                                  *}
{* Info      : If Number 0 is passed, the display area               *}
{*             is filled with blanks                                 *}
{*********************************************************************}

procedure ScrollDown(Number,         { Number of lines to be scrolled }
                     COLOR, { Attribute for the blank line(s) created }
                     ColumnUL,      { Column in the upper left corner }
                     LineUL,          { line in the upper left corner }
                     ColumnLR,     { Column in the lower right corner }
                     LineLR : integer);  { Line in lower right corner }

var Regs : Registers;       { Register-Variable for call of Interrupt }

begin
 Regs.ah := 7;                           { Function number and number }
 Regs.al := Number;
 Regs.bh := COLOR;                           { Color of blank line(s) }
 Regs.ch := LineUL;                                      { upper left }
 Regs.cl := ColumnUL;                                   { coordinates }
 Regs.dh := LineLR;                                     { Lower right }
 Regs.dl := ColumnLR;                                   { coordinates }
 Intr($10, Regs);                         { Call BIOS-Video-Interrupt }
end;

{*********************************************************************}
{* GETCHAR: Read a character including Attribute from an indicated   *}
{*          position in a display page                               *}
{* Input  : see below                                                *}
{* Output : see below                                                *}
{*********************************************************************}

procedure GetChar(Page,                      { display page accessed  }
                  Column,                            { Display Column }
                  Line       : integer;                { Display line }
                  var Character : char;               { the character }
                  var COLOR   : integer);             { its Attribute }

var Regs : Registers;           { Register-Variable for the Interrupt }
    CurColumn,                               { current display Column }
    CurLine,                                   { current display line }
    CurPage,                                   { current display page }
    Dummy    : integer;      { stores Variables which are not needed  }

begin
 GetVideoMode(Dummy, Dummy, CurPage);    { sense current display page }
 GetCursorPos(CurPage, CurColumn, CurLine,      { Get cursor position }
              Dummy, Dummy);            { in the current display page }
 SetCursorPos(Page, Column, Line); { cursor on the position indicated }

 Regs.ah := 8;          { Get Function number for char. and Attribute }
 Regs.bh := Page;                                      { display page }
 Intr($10,Regs);                               { Invoke DOS registers }
 Character := chr(Regs.al);                 { ASCII-Code of character }
 COLOR := Regs.ah;                       { Attribute of the character }
  SetCursorPos(CurPage, CurColumn, CurLine);{ Set cursor old position }
end;

{*********************************************************************}
{* WRITECHAR: Writes a character with indicated color to the         *}
{*            current cursor position in the display page            *}
{*            indicated                                              *}
{* Input    : see below                                              *}
{* Output   : none                                                   *}
{* Info     : during the Output of characters, the control codes     *}
{*            such as Carriage-Return are treated as ASCII codes     *}
{*********************************************************************}

procedure WriteChar(Page   : integer;      { Display page for writing }
                    Character : char;   { ASCII-Code of the character }
                    COLOR   : integer);               { its Attribute }

var Regs : Registers;            { Register variable for the interrupt }

begin
 Regs.ah := 9;
 Regs.al := ord(Character);       { Function number and character code }
 Regs.bh := Page;                                       { Display page }
 Regs.bl := COLOR;                                     { Display color }
 Regs.cx := 1;                            { output character only once }
 Intr($10,Regs);                           { Call BIOS-Video-Interrupt }
end;

{*********************************************************************}
{* WRITETEXT: Writes a String starting at an indicated position in   *}
{*            a display page.                                        *}
{* Input    : see below                                              *}
{* Output   : none                                                   *}
{* Info     : During output of characters the control characters     *}
{*            such as Carriage-Return are treated as such.           *}
{*            If writing continues beyond the End of the display,    *}
{*            will be scrolled up one line                           *}
{*********************************************************************}

procedure WriteText(Page,                   { Display page for output }
                    Column,        { Column, from which output starts }
                    Line,            { Line, from which output starts }
                    COLOR  : integer;      { Color for all characters }
                    Text   : TextTyp);              { Text for output }

var Regs : Registers;      { Register variable for call of Interrupt }
    Counter  : integer;                                { Loop Counter }

begin
 SetCursorPos(Page, Column, Line);                       { Set cursor }

 for Counter := 1 to length(Text) do             { process characters }
  begin                                                 { in sequence }
   WriteChar(Page, ' ', COLOR);       { Color at the current position }
   Regs.ah := 14;
   Regs.al := ord(Text[Counter]);     { Function number and character }
   Regs.bh := Page;                                    { Display page }
   Intr($10,Regs);                        { Call BIOS-Video-Interrupt }
  end;
end;

{*********************************************************************}
{**                           MAIN PROGRAM                          **}
{*********************************************************************}

begin
 clrscr;                                              { Erase display }
 for i := 1 to 24 do                           { Perform line 1 to 24 }
  for j := 0 to 79 do                                { do all Columns }
   begin
    SetCursorPos(0, j, i);                          { position cursor }
    WriteChar(0, chr(i*80+j and 255), NORMAL);    { Write a character }
   end;
 ScrollDown(0, NORMAL, 5, 8, 19, 22);                { Erase Window 1 }
 WriteText(0, 5, 8, INVERS, '   Window 1    ');
 ScrollDown(0, NORMAL, 60, 2, 74, 16);               { Erase Window 2 }
 WriteText(0, 60, 2, INVERS, '   Window 2    ');
 WriteText(0, 24, 12, INVERS or BLINK, ' >>> PC SYSTEM PROGRAMMING <<< ');
 WriteText(0, 0, 0, INVERS, '                Still have to draw      '+
                            ' arrows on the screen                   ');
 for i := 49 downto 0 do                  { draw a total of 50 Arrows }
  begin
   str(i:2, IString);                     { convert i in ASCII-String }
   WriteText(0, 37, 0, INVERS, IString);
   j := 1;                         { every Arrow consists of 16 lines }
   while j <= 15 do
    begin
      k := 0;
      while k < j do                     { create a line of the Arrow }
       begin
        SetCursorPos(0, 12-(j shr 1)+k, 9);          { Arrow Window 1 }
        WriteChar(0, '*', BOLD);
        SetCursorPos(0, 67-(j shr 1)+k, 16);         { Arrow Window 2 }
        WriteChar(0, '*', BOLD);
        k := succ(k);
       end;
      ScrollDown(1, NORMAL, 5, 9, 19, 22);          { scroll Window 1 }
      ScrollUp(1, NORMAL, 60, 3, 74, 16);           { scroll Window 2 }
      for l := 0 to 8000 do                               { Wait Loop }
       ;
      j := j+2;
    end;
  end;
 clrscr;                                              { Erase display }
end.

