100 '*****************************************************************'
110 '*                              R T C                            *'
120 '*---------------------------------------------------------------*'
130 '*  Task           : makes two Subroutines available             *'
140 '*                   for reading and writing data                *'
150 '*                   from the RTC of the AT                      *'
160 '*  Author         : MICHAEL TISCHER                             *'
170 '*  developed on   : 7.24.87                                     *'
180 '*  last Update    : 9.21.87                                     *'
190 '*****************************************************************'
200 '
210 CLS                                  'Clear Screen
230 PRINT"RTC (c) 1987 by Michael Tischer" : PRINT
240 PRINT"Information from the battery buffered real time clock "
250 PRINT"====================================================="
260 PRINT
270 ADR% = 14 : GOSUB 50000             'read diagnostic-byte from the RTC 
280 IF (CON% AND 128) =  0 THEN 310     'bit 8 = 1 --> battery o.k.
290 PRINT"       WARNING! The battery of the clock is low!"
300 END
310 ADR% = 11 : GOSUB 50000             'read status-register B of the RTC 
320 PRINT"- the clock is operated in ";(CON% AND 2) * 6 + 12;"hour-mode "
330 PRINT"- the time: ";
340 ADR% = 4 : GOSUB 52000        'read the hour and convert to decimal 
350 PRINT USING "##:";CON%;
360 ADR% = 2 : GOSUB 52000        'read the minutes and convert to decimal 
370 PRINT USING "##:";CON%;
380 ADR% = 0 : GOSUB 52000        'read the seconds and convert to decimal 
390 PRINT USING "##";CON%
400 PRINT"- the date: ";
410 ADR% = 6 : GOSUB 52000        'read day of week and convert to decimal 
420 RESTORE 540
430 FOR I% = 1 TO CON% : READ DAY$ : NEXT       'read name of the day 
440 PRINT DAY$;", the ";
450 ADR% = 7 : GOSUB 52000       'read day of month and convert to decimal 
460 PRINT USING "##.";CON%;
470 ADR% = 8 : GOSUB 52000       'read month and convert to decimal 
480 PRINT USING "##.";CON%;
490 ADR% = 9 : GOSUB 52000       'read year and convert to decimal 
500 PRINT USING "####";CON%+1900
510 PRINT
520 END
530 '
540 DATA "Sunday","Monday","Tuesday","Wednesday"
550 DATA "Thursday","Friday","Saturday"
560 '
50000 '***************************************************************'
50010 '* read the content of a memory location of the RTC            *'
50020 '*-------------------------------------------------------------*'
50030 '* Input:  ADR% = the number of the memory location (0 to 63)  *'
50040 '* Output: CON% = the content of this storage location         *'
50050 '***************************************************************'
50060 '
50070 OUT &H70,ADR%     'number of memory location to RTC-address-register
50080 CON% = INP(&H71)  'read Content from RTC-data-register 
50090 RETURN            'back to caller 
50100 '
51000 '***************************************************************'
51010 '* write a memory location in the RTC                          *'
51020 '*-------------------------------------------------------------*'
51030 '* Input:   ADR% = the number of the memory location (0 to 63) *'
51040 '*          CON% = the new content of this memory location     *'
51050 '* Output: none                                                *'
51060 '***************************************************************'
51070 '
51080 OUT &H70,ADR%    'number of memory location to RTC-address-register
51090 OUT &H71,CON%    'write new content into RTC-data-register 
51100 RETURN           'back to the caller 
51110 '
52000 '***************************************************************'
52010 '* read the content of a date or time memory location          *'
52020 '* from the RTC and convert to decimal                         *'
52030 '*-------------------------------------------------------------*'
52040 '* Input : ADR% = the number of the memory location (0 to 63)  *'
52050 '* Output: CON% = the new content of this memory location      *'
52060 '* Info  : ADR% is changed by this subroutine                  *'
52070 '***************************************************************'
52080 '
52090 GOSUB 50000            'read content of the memory location 
52100 BCD% = CON%            'record content of the memory location 
52110 ADR% = 11              'Address of the Status registers B of the RTC
52120 GOSUB 50000            'read its content 
52130 IF (CON% AND 2) = 0 THEN 52150               'test if BCD-mode 
52140 BCD% = (BCD% AND 15) + INT(BCD% / 16) * 10   'convert BCD to decimal 
52150 CON% = BCD%                                  'set return value 
52160 RETURN                                       'back to caller 

