100 '*****************************************************************'
110 '*                          V I D E O B                     BAS  *'
120 '*---------------------------------------------------------------*'
130 '*  Task         : Makes some Subroutines available for access   *'
140 '*                 to the Display using the BIOS-Video-Interrupt *'
150 '*                                                               *'
160 '*  Author       : MICHAEL TISCHER                               *'
170 '*  developed on : 07/18/87                                      *'
180 '*  last Update  : 05/14/89                                      *'
190 '*****************************************************************'
200 '
210 CLS : KEY OFF
220 PRINT"WARNING: This Program should only be started if GWBASIC was "
230 PRINT"started from the DOS level with <GWBASIC  /m60000>. "
240 PRINT : PRINT"If this was not the case enter <s> for Stop."
250 PRINT"Otherwise press any key...";
260 A$ = INKEY$ : IF A$ = "s" THEN END
270 IF A$ = "" THEN 260
280 CLS
290 GOSUB 60000                    'Install function for interrupt call
300 PAGE%=0                      'Display page for the output is Page 0
310 COLRR%=7                       'light characters on dark background
320 FOR DISPROW%=1 TO 24                     'process all display lines
330   FOR DISPCOL%=0 TO 79                 'process all display columns
340     CHARACTER$=CHR$((DISPCOL%+DISPROW%*80) AND 255)'continuous code
350     GOSUB 52000                                'Set cursor position
360     GOSUB 57000                                   'Output character
370   NEXT                                                 'next column
380 NEXT                                                     'next line
390 VALUE%=0                                              'Erase Window
400 ULC%=5 : ULR%=8 : LRC%=19 : LLR%=22   'Coordinates of the 1. Window
410 GOSUB 55000                                           'Erase Window
420 ULC%=60 : ULR%=2 : LRC%=74 : LLR%=16  'Coordinates of the 2. Window
430 GOSUB 55000                                           'Erase Window
440 COLRR%=&H70             'dark letters on light background (inverse)
450 DISPCOL%=5 : DISPROW%=8                'Coordinates for Text output
460 T$="   Window 1   "                                'Text for output
470 GOSUB 58000                                            'Output Text
480 DISPCOL%=60 : DISPROW%=2               'Coordinates for text output
490 T$="   Window 2   "                                'Text for output
500 GOSUB 58000                                            'Output Text
510 DISPROW%=0 : DISPCOL%=0                  'upper left Display corner
520 T$=STRING$(23," ")+"Arrow number__ is being drawn "+STRING$(23," ")
530 GOSUB 58000                                            'Output Text
540 COLRR%=&HF0      'dark chars on light background (inverse) blinking
550 DISPCOL%=24 : DISPROW%=12              'Coordinates for Text output
560 T$=" >>> PC SYSTEM PROGRAMMING <<< "               'Text for output
570 GOSUB 58000                                            'Output Text
580 VALUE%=1                                    'always scroll one line
590 FOR ARROWS%=4 TO 0 STEP -1               'Output total of 10 Arrows
600 DISPCOL%=35: DISPROW%=0              'Position for number of Arrows
610 COLRR%=&H70          'dark characters on light background (inverse)
620 T$=STR$(ARROWS%)        'Convert number of Arrows into ASCII-String
630   GOSUB 58000                                          'Output Text
640   COLRR%=7                     'light characters on dark background
650   FOR COUNTL%=1 TO 8                  'an Arrow consists of 8 Lines
660     DISPCOL%=5 : DISPROW%=9            'Coordinates in first Window
670     T$=STRING$(8-COUNTL%," ")+STRING$(2*COUNTL%-1,"*")+STRING$(8-COUNTL%," ")
680     GOSUB 58000                                  'Output Arrow line
690     DISPCOL%=60 : DISPROW%=16         'Coordinates in second Window
700     GOSUB 58000                                  'Output arrow line
710     ULC%=5 : ULR%=9 : LRC%=19: LLR%=22    'Coordinates of 1. Window
720     VALUE%=1                                    'scroll one DISPROW
730     GOSUB 56000                                 'Scroll Window down
740     ULC%=60 : ULR%=3 : LRC%=74: LLR%=16   'Coordinates of 2. Window
750     VALUE%=1                                       'Scroll one Line
760     GOSUB 55000                                   'Scroll Window up
770   NEXT                                             'next Arrow Line
780 NEXT                                                    'next Arrow
790 CLS
800 KEY ON
810 END
820 '
50000 '***************************************************************'
50010 '* Sense Video mode and other Parameters                       *'
50020 '*-------------------------------------------------------------*'
50030 '* Input  : none                                               *'
50040 '* Output : VMODE%   = the current Video mode                  *'
50050 '*          PAGE%    = the current Display page                *'
50060 '*          DISPCOL% = the number of Columns per Line          *'
50070 '* Info   : the Variable Z% is used as Dummy                   *'
50080 '***************************************************************'
50090 '
50100 DISPCOL%=15                   'Get Function number for Video mode
50110 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
50120 CALL IA(INR%,DISPCOL%,VMODE%,PAGE%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%)
50130 RETURN                                            'back to caller
50140 '
51000 '***************************************************************'
51010 '* Define appearance of blinking Text-Cursor                   *'
51020 '*-------------------------------------------------------------*'
51030 '* Input : BEGLIN% = is the beginning Line of the Text-Cursor  *'
51040 '*         ENDL%   = is the End Line of the Text-Cursor        *'
51050 '* Output: none                                                *'
51060 '* Info  : the Variable Z% is used as Dummy                    *'
51070 '***************************************************************'
51080 '
51090 FKT%=1              'Set Function number for appearance of Cursor
51100 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
51110 CALL IA(INR%,FKT%,Z%,Z%,Z%,BEGLIN%,ENDL%,Z%,Z%,Z%,Z%,Z%,Z%)
51120 RETURN                                            'back to caller
51130 '
52000 '***************************************************************'
52010 '* Set Cursor Position                                         *'
52020 '*-------------------------------------------------------------*'
52030 '* Input  : PAGE%    = is the Number of the Display page       *'
52040 '*          DISPCOL% = is the new Column of the Cursor         *'
52050 '*          DISPROW% = is the new Row of the Cursor            *'
52060 '* Output : none                                               *'
52070 '* Info   : The position of the blinking Text-Cursor is only   *'
52080 '*          influenced by the call of this subroutine if the   *'
52090 '*          Display page indicated is the current Display page *'
52100 '*                                                             *'
52110 '*          the Variable Z% is used as Dummy                   *'
52120 '***************************************************************'
52130 '
52140 FKT%=2                   'Set Function number for Cursor position
52150 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
52160 CALL IA(INR%,FKT%,Z%,PAGE%,Z%,Z%,Z%,DISPROW%,DISPCOL%,Z%,Z%,Z%,Z%)
52170 RETURN                                            'back to caller
52180 '
53000 '***************************************************************'
53010 '* Read Cursor Position and Beginning and End Row              *'
53020 '* of the blinking Text-Cursor                                 *'
53030 '*-------------------------------------------------------------*'
53040 '* Input : PAGE%    = is the Number of the Display page        *'
53050 '* Output: DISPCOL% = Column of the Cursor in the Display page *'
53060 '*         DISPROW% = Row of the Cursor in the Display page    *'
53070 '*         BEGLIN%  = beginning Line of the Text-Cursor        *'
53080 '*         ENDL%    = is the End Line of the Text-Cursor       *'
53090 '* Info  : the Variable Z% is used as Dummy                    *'
53100 '***************************************************************'
53110 FKT%=3                  'Read Function number for Cursor position
53120 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
53130 CALL IA(INR%,FKT%,Z%,PAGE%,Z%,BEGLIN%,ENDL%,DISPROW%, DISPCOL%,Z%,Z%,Z%,Z%)
53140 RETURN                                            'back to caller
53150 '
54000 '***************************************************************'
54010 '* Set the current display page on the                         *'
54020 '* screen                                                      *'
54030 '*-------------------------------------------------------------*'
54040 '* Input : PAGE% = is the Number of the Display page           *'
54050 '* Output: none                                                *'
54060 '* Info  : the Variable Z% is used as Dummy                    *'
54070 '***************************************************************'
54080 FKT%=5                      'Set Function number for Display page
54090 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
54100 CALL IA(INR%,FKT%,PAGE%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%)
54110 RETURN                                            'back to caller
54120 '
55000 '***************************************************************'
55010 '* Scroll current Display page up or erase                     *'
55020 '*-------------------------------------------------------------*'
55030 '* Input : VALUE%  = how many Lines to scroll                  *'
55040 '*         ULC%    = Column upper left                         *'
55050 '*         ULR%    = Row upper left                            *'
55060 '*         LRC%    = Column lower right                        *'
55070 '*         LLR%    = Row lower right                           *'
55080 '*         COLRR%  = COLRR of erased Lines                     *'
55090 '* Output: none                                                *'
55100 '* Info  : If VALUE% 0 is indicated, the                       *'
55110 '*         Display area is erased                              *'
55120 '*         the Variable Z% is used as Dummy                    *'
55130 '***************************************************************'
55140 '
55150 FKT%=6                          'Function number for scrolling up
55160 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
55170 CALL IA(INR%,FKT%,VALUE%,COLRR%,Z%,ULR%,ULC%,LLR%,LRC%, Z%,Z%,Z%,Z%)
55180 RETURN                                            'back to caller
55190 '
56000 '***************************************************************'
56010 '* Scroll current Display Page down or erase                   *'
56020 '*-------------------------------------------------------------*'
56030 '* Input : VALUE%  = how many Lines to scroll                  *'
56040 '*         ULC%    = Column upper left                         *'
56050 '*         ULR%    = Row upper left                            *'
56060 '*         LRC%    = Column lower right                        *'
56070 '*         LLR%    = Row lower right                           *'
56080 '*         COLRR%  = COLRR of erased Lines                     *'
56090 '* Output: none                                                *'
56100 '* Info  : If VALUE% 0 is indicated, the                       *'
56110 '*         Display area is erased                              *'
56120 '*         The Variable Z% is used as Dummy                    *'
56130 '***************************************************************'
56140 '
56150 FKT%=7                        'Function number for scrolling down
56160 GOTO 55160                   'Call is identical with scrolling up
56170 '
57000 '***************************************************************'
57010 '* Write a character of a designated COLRR to the current      *'
57020 '* Cursor position in the designated Display Page              *'
57030 '*-------------------------------------------------------------*'
57040 '* Input : CHARACTER$ = the character for output               *'
57050 '*         COLRR%     = COLRR of the character for output      *'
57060 '*         PAGE%      = is the Number of the Display page      *'
57070 '* Output: none                                                *'
57080 '* Info  : the Variables ZL%, ZH% and ZE% are Dummies          *'
57090 '***************************************************************'
57100 '
57110 FKT%=9       'Output function numbers for character and Attribute 
57120 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
57130 ZL%=1                       'Output character only once (LO-Byte)
57140 ZH%=0                       'Output character only once (HI-Byte)
57150 ZE%=ASC(CHARACTER$)     'Get ASCII-Code of character to be output 
57160 CALL IA(INR%,FKT%,ZE%,PAGE%,COLRR%,ZH%,ZL%,ZL%, ZL%,ZL%,ZL%,ZL%,ZL%)
57170 RETURN                                            'back to caller
57180 '
58000 '***************************************************************'
58010 '* Output a String starting at a certain Position within a     *'
58020 '* Display page with a constant Attribute                      *'
58030 '*-------------------------------------------------------------*'
58040 '* Input : T$       = the String for output                    *'
58050 '*         COLRR%   = COLRR of the String (Attribute)          *'
58060 '*         PAGE%    = is the number of the Display page        *'
58070 '*         DISPCOL% = Column - start of String                 *'
58080 '*         DISPROW% = Row - start of String                    *'
58090 '* Output: none                                                *'
58100 '* Info  : the Variables ZC% and ZE% are Dummies               *'
58110 '***************************************************************'
58120 '
58130 GOSUB 52000                       'Set Cursor position for Output
58140 FOR ZC%=1 TO LEN(T$)   'process all chars or strings individually
58150   CHARACTER$=" "                            'output a blank first
58160   GOSUB 57000
58170   ZE%=ASC(MID$(T$,ZC%,1))        'Get a character from the String
58180   FKT%=14                    'Function number for Teletype-Output
58190   CALL IA(INR%,FKT%,ZE%,PAGE%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%)
58200 NEXT                                       'Output next character
58210 RETURN                                            'back to caller
58220 '
60000 '***************************************************************'
60010 '*  initialize the Routine for the Interrupt call              *'
60020 '*-------------------------------------------------------------*'
60030 '* Input : none                                                *'
60040 '* Output: IA is the Start address of the Interrupt-Routine    *'
60050 '***************************************************************'
60060 '
60070 IA=60000!      'Start address of the Routine in the BASIC-Segment
60080 DEF SEG                                        'Set BASIC Segment
60090 RESTORE 60130
60100 FOR I% = 0 TO 160 : READ X% : POKE IA+I%,X% : NEXT  'poke Routine 
60110 RETURN                                            'back to caller
60120 '
60130 DATA   85,139,236, 30,  6,139,118, 30,139,  4,232,140,  0,139,118
60140 DATA   12,139, 60,139,118,  8,139,  4, 61,255,255,117,  2,140,216
60150 DATA  142,192,139,118, 28,138, 36,139,118, 26,138,  4,139,118, 24
60160 DATA  138, 60,139,118, 22,138, 28,139,118, 20,138, 44,139,118, 18
60170 DATA  138, 12,139,118, 16,138, 52,139,118, 14,138, 20,139,118, 10
60180 DATA  139, 52, 85,205, 33, 93, 86,156,139,118, 12,137, 60,139,118
60190 DATA   28,136, 36,139,118, 26,136,  4,139,118, 24,136, 60,139,118
60200 DATA   22,136, 28,139,118, 20,136, 44,139,118, 18,136, 12,139,118
60210 DATA   16,136, 52,139,118, 14,136, 20,139,118,  8,140,192,137,  4
60220 DATA   88,139,118,  6,137,  4, 88,139,118, 10,137,  4,  7, 31, 93
60230 DATA  202, 26,  0, 91, 46,136, 71, 66,233,108,255
