/*********************************************************************/
/*                             C O N F I G                           */
/*-------------------------------------------------------------------*/
/*    Task        : Outputs the configuration of the PC on the       */
/*                  Display Screen                                   */
/*-------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                               */
/*    developed on   : 8.13.87                                       */
/*    last Update    : 9.21.87                                       */
/*-------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                  */
/*    Creation     : MSC CONFIGC                                     */
/*                   LINK CONFIGC PEPO;                              */
/*    Call         : CONFIGC                                         */
/*-------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                              */
/*    Creation     : With the RUN command in the Command Line        */
/*********************************************************************/

#include <dos.h>                          /* Include Header-Files */
#include <io.h>

extern short int PeekB();    /* PEEKB must be linked with MicroSoft C */

#define FALSE 0                 /* Constants make reading the  */
#define TRUE 1                  /* Program text easier */

/*********************************************************************/
/* CLS: Clear Screen and Cursor to upper left corner                 */
/* Input : none                                                      */
/* Output : none                                                     */
/*********************************************************************/

void Cls()

{
 union REGS Register;       /* Register-Variable for Interrupt-Call */

 Register.h.ah = 6;         /* Function number for Scroll-UP */
 Register.h.al = 0;         /* 0 for clear  */
 Register.h.bh = 7;         /* white characters on black background */
 Register.x.cx = 0;         /* left upper screen corner  */
 Register.h.dh = 24;        /* Coordinates of the lower */
 Register.h.dl = 79;        /* right screen corner   */
 int86(0x10, &Register, &Register);  /* Call BIOS-Video-Interrupt */

 Register.h.ah = 2;      /* Set Function number for Cursor position */
 Register.h.bh = 0;      /* Screen page 0 */
 Register.x.dx = 0;      /* Coordinates of upper left screen corner  */
 int86(0x10, &Register, &Register);  /* Call BIOS-Video-Interrupt */
}

/*********************************************************************/
/* PRINTCONFIG: Output the PC Configuration                          */
/* Input : none                                                      */
/* Output : none                                                     */
/* Info    : the configuration output is dependent on the PC-Type    */
/*********************************************************************/

void PrintConfig()

{
 union REGS Register;       /* Register-Variable for Interrupt-Call */
 short int AT;              /* is the PC an AT? */

 Cls();                     /* Clear Screen */
 if (PeekB(0xF000, 0xFFFE) == 0xFC) AT = TRUE;  /* Determine if the  */
  else AT = FALSE;                             /* PC is an AT      */
 printf("CONFIG (c) 1987 by Michael Tischer\n\n");
 printf("Configuration of this PC\n");
 printf("---------------------------------------------------------\n");
 printf("PC-Type                 : ");
 switch(PeekB(0xF000, 0xFFFE))           /* Determine PC-Type again */
  {
   case 0xFF : printf("PC\n");           /* 0xFF is a normal PC */
               break;
   case 0xFE : printf("XT\n");           /* 0xFE is an XT */
               break;
   case 0xFC : printf("AT\n");           /* 0xFC is an AT */
               break;
   default   : printf("Unknown\n"); /* Code unknown */
               break;
  }
 printf("Processor               : INTEL 80");
 if (AT) printf("286\n");      /* the AT has an 80286, */
  else printf("88\n");         /* PC and XT have an 8088 Processor */
 printf("RAM-Memory              : ");
 int86(0x12, &Register, &Register);              /* Get RAM size  */
 printf("%d KB\n",Register.x.ax);                /* and output */
 if (AT)                                         /* is the PC an AT? */
  {                                              /* YES */
   Register.h.ah = 0x88;       /* Function number for additional RAM */
   int86(0x15, &Register, &Register);            /* Get RAM size */
   printf("additional RAM        : %d KB beyond 1MB\n", Register.x.ax);
  }
 int86(0x11, &Register, &Register);  /* BIOS-Configuration-Interrupt */
 printf("Video mode after Start  : ");
 switch(Register.x.ax & 48)
  {
   case  0 : printf("undefined\n");
             break;
   case 16 : printf("40*25 Character Color-Card\n");
             break;
   case 32 : printf("80*25 Character Color-Card\n");
             break;
   case 48 : printf("80*25 Character Mono-Card\n");
             break;
  }
 printf("Disk drives             : %d\n", (Register.x.ax >> 6 & 3) + 1);
 printf("RS232-Card              : %d\n", Register.x.ax >> 9 & 0x03);
 printf("Printer-Card            : %d\n\n", Register.x.ax >> 14);
}

/*********************************************************************/
/**                           MAIN PROGRAM                          **/
/*********************************************************************/

void main()

{
 PrintConfig();                        /* Output the Configuration */
}
