
/*********************************************************************/
/*                                D I R C                            */
/*-------------------------------------------------------------------*/
/*    Task           : Displays all files in any Directory,          */
/*                     including Sub-Directories and volume names    */
/*                     on the screen.                                */
/*-------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                               */
/*    developed on   : 08/15/87                                      */
/*    last Update    : 04/08/89                                      */
/*-------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                  */
/*    Creation       : MSC DIRC;                                     */
/*                     LINK DIRC;                                    */
/*    Call           : DIRC                                          */
/*-------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                              */
/*    Creation       : With the RUN command in the command line      */
/*    Info             Arguments can be passed to the program with   */
/*                     the OPTION/ARGS command in the command line   */
/*                     of TURBO C                                    */
/*       or                                                          */
/*                                                                   */
/*    Creation        : TCC DIRC                                     */
/*    Call            : DIRC                                         */
/*********************************************************************/

#include <dos.h>                             /* include Header files */
#include <io.h>
#include <string.h>

#define FALSE 0                        /* Constants make reading of  */
#define TRUE 1                               /* Program text easier  */
#define byte unsigned char
#define ENTRY 14   /* this many directory entries fit on the screen  */
#define EZ (20-ENTRY >> 1)        /* first line of Directory window  */
#define NRM 0x07             /* white characters on black background */
#define INV 0x70  /* black characters on white background (inverted) */

/*-- this is the format of a Directory entry returned by     --------*/
/*-- the functions 4E(h) and 4F(h)                                   */
struct DirStruct {
                  byte          Reservebuf[21];
                  byte          Attribute;
                  unsigned int  Ftime;
                  unsigned int  Fdate;
                  unsigned long Fsize;
                  char          Fname[13];
                 };

/*********************************************************************/
/* GETPAGE : gets the current display page                           */
/* Input   : none                                                    */
/* Output  : see above                                               */
/*********************************************************************/

byte GETPAGE()

{
 union REGS Register;        /* Register-Variable for Interrupt call */

 Register.h.ah = 15;                              /* Function number */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
 return(Register.h.bh);                 /* Number of current display */
}

/*********************************************************************/
/* SCROLLUP: moves a display area one or more lines                  */
/*           upward or erases it                                     */
/* Input   : see above                                               */
/* Output  : none                                                    */
/* Info    : if 0 is passed as number, the display area              */
/*           is filled with blanks                                   */
/*********************************************************************/

void ScrollUp(Number, Color, ColumnUL, LineUL, ColumnLR, LineLR)
int Number;                        /* Number of lines to be scrolled */
int Color;                          /* Color or attribute for blanks */
int ColumnUL;     /* Column in the upper left corner of display area */
int LineUL;         /* Line in the upper left corner of the display  */
int ColumnLR;/* Column in the lower right corner of the display area */
int LineLR;    /* Line in the lower right corner of the display area */

{
 union REGS Register;        /* Register-Variable for Interrupt call */

 Register.h.ah = 6;                               /* Function number */
 Register.h.al = Number;                          /* Number of lines */
 Register.h.bh = Color;                    /* Color of blank line(s) */
 Register.h.ch = LineUL;                /* Coordinates of the scroll */
 Register.h.cl = ColumnUL;                          /* end or erase  */
 Register.h.dh = LineLR;                       /* Set display window */
 Register.h.dl = ColumnLR;
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* SETPOS : sets the position of the cursor in current display page  */
/* Input  : see above                                                */
/* Output : none                                                     */
/* Info   : the position of the blinking display cursor is changed   */
/*          by the call of this function only when the               */
/*          display page indicated is the current display page       */
/*                                                                   */
/*********************************************************************/

void SetPos(Column, Line)
int Column;                                     /* new Cursor column */
int Line;                                         /* new Cursor line */

{
 union REGS Register;        /* Register-Variable for Interrupt call */

 Register.h.ah = 2;                               /* Function number */
 Register.h.bh = GETPAGE();                          /* Display page */
 Register.h.dh = Line;                               /* Display line */
 Register.h.dl = Column;                           /* Display column */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* GETPOS  : Get the position of the Cursor in current display page  */
/* Input   : none                                                    */
/* Output  : see below                                               */
/*********************************************************************/

void GetPos(Column, Line)
int *Column;                   /* Column where the Cursor is located */
int *Line;                       /* Line where the Cursor is located */

{
 union REGS Register;        /* Register-Variable for Interrupt call */

 Register.h.ah = 3;                               /* Function number */
 Register.h.bh = GETPAGE();                          /* Display page */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
 *Column = Register.h.dl;             /* Read result of the Function */
 *Line = Register.h.dh;                        /* from the Registers */
}

/*********************************************************************/
/* WRITECHAR: writes a character with an attribute to the current    */
/*            cursor position on the current display page            */
/* Input    : see below                                              */
/* Output   : none                                                   */
/*********************************************************************/

void WriteChar(Character, Color)
char Character;                             /* Character for output  */
int Color;                                 /* its Attribute or color */

{
 union REGS Register;        /* Register-Variable for Interrupt call */

 Register.h.ah = 9;                               /* Function number */
 Register.h.al = Character;                  /* character for output */
 Register.h.bh = GETPAGE();                          /* Display page */
 Register.h.bl = Color;             /* Color of character for output */
 Register.x.cx = 1;                   /* output character only once  */
 int86(0x10, &Register, &Register);          /* Call Interrupt 10(h) */
}

/*********************************************************************/
/* WT      : writes a character string with constant color starting  */
/*           at a specified position on the current display page.    */
/* Input   : see below                                               */
/* Output  : none                                                    */
/* Info    : Text is a Pointer to a character Vector, which contains */
/*           the text to be output and is terminated with a '\0'     */
/*           character.                                              */
/*********************************************************************/

void WT(Column, Line, Text, Color)
int Column;                            /* Display column for output  */
int Line;                                /* Display line for output  */
char *Text;                                       /* Text for output */
int Color;                            /* Color/Attribute of the Text */

{
 union REGS Register;        /* Register-Variable for Interrupt call */

 SetPos(Column, Line);                                 /* Set Cursor */
 while (*Text)                   /* Output Text up to '\0' character */
  {
   WriteChar(' ', Color);                          /* Indicate color */
   Register.h.ah = 14;                            /* Function number */
   Register.h.bh = GETPAGE();                        /* Display page */
   Register.h.al = *Text++;             /* of character to be output */
   int86(0x10, &Register, &Register);              /* Call Interrupt */
  }
}

/*********************************************************************/
/* CLS    : Clear current display and set Cursor into upper left     */
/*          corner                                                   */
/* Input  : none                                                     */
/* Output : none                                                     */
/*********************************************************************/

void Cls()

{
 ScrollUp(0, NRM, 0, 0, 79, 24);                     /* Clear Screen */
 SetPos(0, 0);                                         /* Set Cursor */
}

/*********************************************************************/
/* BUILDSCREENDISPLAY: prepares the display for the output of the    */
/*                     Directory.                                    */
/* Input             : none                                          */
/* Output            : none                                          */
/*********************************************************************/

void BuildScreenDisplay()

{
 byte i;                                             /* Loop Counter */

 Cls();                                              /* Clear Screen */
 WT(14,EZ,  "ͻ",NRM);
 WT(14,EZ+1," File Name   Size     Date       Time   RHSVD",NRM);
 WT(14,EZ+2,"Ķ",NRM);
 for (i = EZ+3; i < EZ+3+ENTRY; i++)
   WT(14,i, "                                             ",NRM);
WT(14,EZ+ENTRY+3,"ͼ",
    NRM);
}

/*********************************************************************/
/* PRINTDATA: Output information about an entry                      */
/* Input    : see below                                              */
/* Output   : none                                                   */
/*********************************************************************/

void PrintData(DirEntry, Line)
struct DirStruct *DirEntry;                     /* a Directory entry */
byte Line;                                  /* Display line of entry */

{
 byte i;                                             /* Loop Counter */
 static char *Month[] =      /* Vector with Pointer to name of month */
                       {
                        "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
                        "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"
                       };

 SetPos(15, Line);              /* Set Cursor position for file name */
 for (i=0; (*DirEntry).Fname[i] && i<15 ; printf("%c", (*DirEntry).Fname[i++]))
  ;
 SetPos(28, Line);              /* Set Cursor position for file size */
 printf("%7lu", (*DirEntry).Fsize);              /* Output file size */
 SetPos(36, Line);                   /* Set Cursor position for Date */
 printf("%s-%2d-%4d", Month[((*DirEntry).Fdate >> 5 & 15) - 1],
          (*DirEntry).Fdate & 31, ((*DirEntry).Fdate >> 9) + 1980);
 SetPos(49, Line);                   /* Set Cursor position for Time */
 printf("%2d:%2d",(*DirEntry).Ftime >> 11,(*DirEntry).Ftime >> 5 & 63);
 SetPos(59, Line);              /* Set Cursor position for Attribute */
 for (i = 1; i <= 16; i <<= 1)
  if ((*DirEntry).Attribute & i) printf("X");
   else printf(" ");
}

/*********************************************************************/
/* GETNEXT : read the following Directory entry                      */
/* Input   : none                                                    */
/* Output  : TRUE, when an entry was found, otherwise FALSE          */
/* Info    : the entry is read into DTA rem                          */
/*********************************************************************/

byte GetNext()

{
 union REGS Register;       /* Register-Variable for Interrupt call  */

 Register.h.ah = 0x4F;   /* Function number for Search of next entry */
 intdos(&Register, &Register);               /* Call DOS-Intr. 21(h) */
 return(!Register.x.cflag);            /* Carry-Flag = 0: file found */
}

/*********************************************************************/
/* GETFIRST : read the first Directory entry                         */
/* Input    : none                                                   */
/* Output   : TRUE, if entry was found, otherwise FALSE              */
/* Info     : Entry is read into the DTA                             */
/*********************************************************************/

byte GetFirst(Sname, Attribute)
char *Sname;                                     /* file to be found */
unsigned int Attribute;                      /* the Search Attribute */

{
 union REGS Register;        /* Register-Variable for Interrupt call */
 struct SREGS Segmente;                  /* accepts Segment register */

 segread(&Segmente);          /* Read in content of Segment register */
 Register.h.ah = 0x4E;       /* Function number for search of first  */
 Register.x.cx = Attribute;   /* Attribute, for which search is made */
 Register.x.dx = (unsigned int) Sname;  /* Offset address search path*/
 intdosx(&Register, &Register, &Segmente);   /* Call DOS-Intr. 21(h) */
 return(!Register.x.cflag);            /* Carry-Flag = 0: file found */
}

/*********************************************************************/
/* SETDTA  : sets the DTA to a Variable in the Data Segment          */
/* Input   : see below                                               */
/* Output  : none                                                    */
/*********************************************************************/

void SetDTA(Offset)
unsigned int Offset;                /* new Offset address of the DTA */

{
 union REGS Register;        /* Register-Variable for Interrupt call */
 struct SREGS Segment;               /* accepts the Segment register */

 segread(&Segment);           /* Read in content of Segment register */
 Register.h.ah = 0x1A;                /* Set Function number for DTA */
 Register.x.dx = Offset;          /* Offset address into DX-Register */
 intdosx(&Register, &Register, &Segment);    /* Call DOS-Intr. 21(h) */
}

/*********************************************************************/
/* DIR    : controls the input and output of Directories             */
/* Input  : see below                                                */
/* Output : none                                                     */
/*********************************************************************/

void Dir(Sname, Attribute)
char *Sname;  /* Pointer to Character Vector, containing search path */
int Attribute;                     /* Attribute of file to be found  */

{
 int NumEntries,                   /* Total number of entries found  */
     Numwind;                       /* Number of entries in display  */
 struct DirStruct DirEntry;                     /* a Directory entry */

 SetDTA(&DirEntry);                       /* DIRENTRY is the new DTA */
 BuildScreenDisplay(); /* Construct display for new Directory output */

 Numwind = NumEntries = 0;      /* no entry displayed in the window  */
                                                   /* no entry found */
 if (GetFirst(Sname, Attribute))          /* search for first entry  */
  {
   do
    {
     PrintData(&DirEntry, EZ+ENTRY+2);              /* output entry  */
     if (++Numwind == ENTRY )                       /* Window full ? */
      {
       Numwind = 0;                                /* fill a window  */
       WT(14, EZ+4+ENTRY,
          "                 Please press a key                ",INV);
       getch();                                      /* wait for key */
       WT(14, EZ+4+ENTRY,
          "                                                   ",NRM);
      }
     ScrollUp(1, NRM, 15, EZ+3, 63, EZ+2+ENTRY);
     WT(15, EZ+2+ENTRY,
        "                                             ",NRM);
     ++NumEntries;
    }
   while (GetNext());
  }
 SetPos(14, EZ+4+ENTRY);
 switch (NumEntries)
  {
   case 0  : printf("no files found ");
             break;
   case 1  : printf("one file found ");
             break;
   default : printf("%d files found ", NumEntries);
  }
}

/*********************************************************************/
/**                           MAIN PROGRAM                          **/
/*********************************************************************/

void main(Number, Argument)
int Number;                        /* Number of Arguments + 1 passed */
char *Argument[];                /* Vector with pointer to Arguments */
{
 switch (Number)                              /* react according to  */
  {                                              /* Arguments passed */
   case 1 : Dir("*.*", ~0);         /* Display all files in current  */
            break;                                      /* Directory */
   case 2 : Dir(Argument[1], ~0); /* Display all files in indicated  */
            break;                                      /* Directory */
   default : printf("Invalid number of Parameters\n");
  }
}

