
;
;                          PRNASCII
;
;
;   TSR to convert non-ASCII characters to acceptable characters
;   for those printers that cannot print the entire IBM character
;   set.  Works with most programs and Print Screen.
;
;   (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc


cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:tsrstk
    

; This is the resident handler than converts characters to be 
;   printed

int_17h_hook    proc    far
        pushf
        cmp     ah, 0              ; printing a character ?
        jne     skip_change        ; jump if not

        cmp     al, 20h            ; control character ?
        jb      control            ; jump if so
        cmp     al, 7Fh            ; in OK range
        jb      skip_change        ; jump if so
        je      set_space          ; if 7Fh, set to space

        sub     al, 80h            ; convert upper chars
        push    bx                 ;  into new chars
        mov     bx, offset new_chars
        xlat    cs:[bx]
        pop     bx
        jmp     finish_int17

control:
        cmp     al, 1Bh            ; escape ?
        je      skip_change        ; jump if so
        cmp     al, 08h            ; BS, HT, LF, VT, FF, CR ?
        jb      set_space          ; jump if not
        cmp     al, CR
        jbe     skip_change        ; if so, leave as-is
                                   ; all others switch to space
set_space:
        mov     al, ' '            ; switch to space

finish_int17:
skip_change:
        popf
        jmp     cs:old_int_17h     ; process old int_17h
        
int_17h_hook    endp

old_int_17h     dd      0          ; old pointer saved here
        
new_chars       db 'CueaaaaceeeiiiAA'   ;   80-8F
                db 'E AooouuyOU     '   ;   90-9F
                db 'aiounN  ?==  !<>'   ;   A0-AF
                db '###||||  ||     '   ;   B0-BF
                db '  _|__|||  _|_|_'   ;   C0-CF
                db '___    ||  ##**#'   ;   D0-DF
                db '                '   ;   E0-EF
                db '         ...  . '   ; f0-ff             F0-FF

;================================================================
; Start of non-resident installation portion

prnascii        proc    far

start:
        push    cs
        pop     ds

; get the current interrupt 17h vector and save
        
        mov     al, 17h         
        mov     ah, 35h
        int     21h                ; get current int 17h pointer
        mov     word ptr old_int_17h, bx
        mov     word ptr old_int_17h+2, es

; install our new interrupt 17h routine

        mov     dx, offset int_17h_hook
        mov     al, 17h
        mov     ah, 25h
        int     21h                ; install our interrupt 

        OUTMSG  msg1               ; output installed message

; now determine the size to remain resident (paragraphs) 
;   and become a TSR

        mov     dx, (offset start - offset int_17h_hook) SHR 4
        add     dx, 11h            ; add PSP size + 1 paragraph
        mov     ax, 3100h          ; exit to DOS as tsr 
        int     21h
prnascii        endp

msg1    db      CR, LF
        db      'PRNASCII TSR installed'
        db      ' - Print non-ASCII as ASCII.'
        db      CR, LF, '$'
cseg    ends

;===================================================== stack ====

tsrstk  segment para stack
        db      150 dup (0)
tsrstk  ends
        end     start


