
;
;                          TESTCASE
;
;
;    Program used to show how TIMEVENT can monitor the duration
;    of a section of code.  To use, first run TIMEVENT.  Then
;    run TESTCASE.  Now run TIMEVENT again to see the length of
;    time to run the code section.
;
;    (c) Copyright 1994, 1996  Frank van Gilluwe
;    All Rights Reserved.

include undocpc.inc

cseg    segment para public
        assume  cs:cseg, ds:cseg

        org     100h               ; Assemble into a COM file.


testcase proc   far

start:
        OUTMSG  info               ; display information

; to start event timing, activate the counter

        in      al, 61h            ; read the current contents
        or      al, 1              ; set gate bit on
        out     61h, al            ; activate counter

; code to monitor how long it takes to run starts here

        mov     ah, 9
        mov     dx, offset onechar
        int     21h                ; display character

; to stop the event timing, disable the counter

        in      al, 61h            ; read the current contents
        and     al, 0FEh           ; set gate bit off
        out     61h, al            ; disable the counter

; exit to DOS

        mov     ah, 4Ch
        int     21h                ; DOS terminate
testcase endp


info    db      CR, LF
        db      'TESTCASE - Use TIMEVENT before and after'
        db      ' to measure the duration that '
        db      CR, LF
        db      '  DOS takes to output one character "X" to'
        db      ' the screen.'
        db      CR, LF, CR, LF, '$'

onechar db      'X$'

cseg    ends

        end     start


