{$LINESIZE:125, $PAGESIZE:60}
{$TITLE: 'PARAGON SOFTWARE CORPORATION DECIMAL MATH SAMPLE PROGRAM'}
{$DEBUG+, $LINE-, $LIST+, $SYMTAB-}

PROGRAM SAMPLE(INPUT,OUTPUT);

{$INCLUDE: 'DECMATH.INC'}
{AUTHOR: MARVIN E. LUKASIK}

VAR 
	DONE,BL:	BOOLEAN;
	LOOPER:	BOOLEAN;
	A:			STRING(8);
	B:			STRING(6);
	ADEC,BDEC:	INTEGER;		{ THESE ARE NOT USED IN THE PROGRAM,}
									{ ( THEY ARE ALWAYS REFERENCED BY CONSTANTS) }
	INPLST,OUTA,TSTMSK,AMSK:	LSTRING(20);
	N,I,INPINT,INVAL:	INTEGER;
	OUTB,BMSK	:LSTRING(14);

VALUE
	AMSK := '----,---,---,--9.999';
	TSTMSK:='----,---,---,--9.999';
	BMSK := '----,--9.99999';
	
PROCEDURE GETA;
BEGIN
	REPEAT
		WRITE('ENTER VALUE OF A:');
		READLN(INPLST);
		BL := PK(A,3,INPLST);
		IF BL THEN RETURN;
		WRITELN('INVALID DECIMAL # ENTERED ( PACK FAILED ), TRY AGAIN');
	UNTIL BL;
END;

PROCEDURE GETB;
BEGIN
	REPEAT
		WRITE('ENTER VALUE OF B:');
		READLN(INPLST);
		BL := PK(B,5,INPLST);
		IF BL THEN RETURN;
		WRITELN('INVALID DECIMAL # ENTERED ( PACK FAILED ), TRY AGAIN');
	UNTIL BL;
END;

PROCEDURE SHOWA;
BEGIN
	IF UNPK(OUTA,A,3,AMSK) THEN WRITELN('CURRENT VALUE OF A=',OUTA)
								  ELSE WRITELN('A HAS GARBAGE IN IT (UNPK FAILED)');
END;

PROCEDURE SHOWB;
BEGIN
	IF UNPK(OUTB,B,5,BMSK) THEN WRITELN('CURRENT VALUE OF B=        ',OUTB)
								  ELSE WRITELN('B HAS GARBAGE IN IT (UNPK FAILED)');
END;

PROCEDURE ANSWER;
BEGIN
WRITELN;
	IF UNPK(OUTA,A,3,AMSK) THEN WRITELN('THE ANSWER IS=     ',OUTA)
								  ELSE WRITELN('(UNPK OF THE ANSWER FAILED)');
WRITELN;
END;

PROCEDURE TWOOPS(CONST TITL1:LSTRING);
BEGIN
	WRITELN;
	SHOWA;
	SHOWB;
	WRITELN;
	WRITELN('-------MENU SELECTION-----');
	WRITELN('0  --  EXITS BACK TO MAIN MENU');
	WRITELN('1  --  ENTER A NEW VALUE FOR A');
	WRITELN('2  --  ENTER A NEW VALUE FOR B');
	WRITELN('3  --  PERFORM ',TITL1);
	  WRITE('ENTER YOUR SELECTION:');
END;

PROCEDURE ONEOP(CONST TITL1:LSTRING);
BEGIN
	WRITELN;
	SHOWA;
	WRITELN('-------MENU SELECTION-----');
	WRITELN('0  --  EXITS BACK TO MAIN MENU');
	WRITELN('1  --  ENTER A NEW VALUE FOR A');
	WRITELN('2  --  PERFORM ',TITL1);
	  WRITE('ENTER YOUR SELECTION:');
END;
 
PROCEDURE TRYADD;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		TWOOPS('ADDITION: A = A + B');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		GETB;
			3:		BEGIN
						ADDP(A,3,B,5);
						ANSWER;
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 3, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYSUB;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		TWOOPS('SUBTRACTION: A = A - B');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		GETB;
			3:		BEGIN
						SUBP(A,3,B,5);
						ANSWER;
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 3, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYMUL;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		TWOOPS('MULTIPLY: A = A * B');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		GETB;
			3:		BEGIN
						MULP(A,3,B,5);
						ANSWER;
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 3, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYDIV;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		TWOOPS('DIVISION: A = A DIV B');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		GETB;
			3:		BEGIN
						DIVP(A,3,B,5);
						ANSWER;
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 3, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYEQP;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		TWOOPS('COMPARE: IS A = B ?');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		GETB;
			3:		BEGIN
						WRITELN;
						IF EQP(A,3,B,5) THEN WRITELN('THE ANSWER IS YES')
											 ELSE WRITELN('THE ANSWER IS NO');
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 3, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYLTP;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		TWOOPS('COMPARE: IS A < B ?');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		GETB;
			3:		BEGIN
						WRITELN;
						IF LTP(A,3,B,5) THEN WRITELN('THE ANSWER IS YES')
											 ELSE WRITELN('THE ANSWER IS NO');
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 3, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYGTP;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		TWOOPS('COMPARE: IS A > B ?');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		GETB;
			3:		BEGIN
						WRITELN;
						IF GTP(A,3,B,5) THEN WRITELN('THE ANSWER IS YES')
											 ELSE WRITELN('THE ANSWER IS NO');
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 3, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYNEG;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		ONEOP('NEGATE: A = -A');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		BEGIN
						NEGP(A,3);
						ANSWER;
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 2, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYABS;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		ONEOP('ABSOLUTE VALUE OF A ');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		BEGIN
						ABSP(A,3);
						ANSWER;
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 2, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYRND;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		ONEOP('ROUND A ');
		READLN(INPINT);
		CASE INPINT OF
			0:		DONE := TRUE;
			1:		GETA;
			2:		BEGIN
						WRITE('INPUT DECIMAL PLACE TO ROUND TO');
						READLN(N);
						RNDP(A,3,N);
						ANSWER;
					END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 2, TRY AGAIN');
		END;
	UNTIL DONE;
END;

PROCEDURE TRYPK;
BEGIN
 DONE := FALSE;
 FOR I := 1 TO 20 DO WRITELN;
 REPEAT
	WRITELN;
	WRITELN('-------MENU SELECTION-----');
	WRITELN('0  --  EXITS BACK TO MAIN MENU');
	WRITELN('1  --  ENTER A STRING TO PACK INTO A');
   WRITE('ENTER YOUR SELECTION:');
	READLN(INPINT);
	CASE INPINT OF
		0: DONE := TRUE;
		1: BEGIN
				WRITELN;
				WRITE('ENTER STRING TO PACK:');
				READLN(INPLST);
				IF PK(A,3,INPLST) THEN BEGIN
											  	WRITELN('THE STRING WAS VALIDATED OK AND');
												SHOWA;
												END 
										ELSE WRITELN('THE INPUT STRING IS NOT A VALID DECIMAL NUMBER');
			END;
		OTHERWISE WRITELN('THE INPUT VALUE MUST BE 0 OR 1, TRY AGAIN');
	END;
 UNTIL DONE;
END;

PROCEDURE TRYUNPK;
BEGIN
	DONE := FALSE;
	FOR I := 1 TO 20 DO WRITELN;
	REPEAT
		WRITELN;
		SHOWA;
      WRITELN('CURRENT VALUE OF THE MASK= ',TSTMSK);
		WRITELN;
		WRITELN('-------MENU SELECTION-----');
		WRITELN('0  --  EXITS BACK TO MAIN MENU');
		WRITELN('1  --  ENTER A NEW VALUE FOR A');
		WRITELN('2  --  ENTER A NEW VALUE FOR THE UNPK MASK');
		WRITELN('3  --  PERFORM THE UNPK');
	   WRITE('ENTER YOUR SELECTION:');
		READLN(INPINT);
		CASE INPINT OF
			0: DONE := TRUE;
			1:	GETA;
			2:	BEGIN;
					WRITE('ENTER NEW MASK: ');
					READLN(TSTMSK);
				END;
			3: BEGIN;
					IF UNPK(OUTA,A,3,TSTMSK) THEN BEGIN;
																WRITELN;
																WRITELN(' THE UNPK WAS SUCCESSFUL');
																WRITELN(' AND = "',OUTA,'"');
																WRITELN;
															END 
													 ELSE WRITELN('THE UNPK FAILED');
				END;
			OTHERWISE WRITELN('INPUT MUST BE BETWEEN 0 AND 2, TRY AGAIN');
		END;
	UNTIL DONE;
END;

BEGIN
	BL := PK(A,3,'1.0');		{INITIAL VALUES}
	CVTP(B,5,2);				{NOTE A DIFFERENT WAY TO INITIALIZE}
	LOOPER := FALSE;

	REPEAT
		FOR I := 1 TO 8 DO WRITELN;
		WRITELN('-------SELECT FUNCTION TO TEST-------');
		WRITELN('0  --  EXITS BACK TO DOS');
		WRITELN;
		WRITELN('1  --  ADD');
		WRITELN('2  --  SUBTRACT');
		WRITELN('3  --  DIVIDE');
		WRITELN('4  --  MULTIPLY');
		WRITELN;
		WRITELN('5  --  COMPARE A = B');
		WRITELN('6  --  COMPARE A > B');
		WRITELN('7  --  COMPARE A < B');
		WRITELN;
		WRITELN('8  --  ROUND');
		WRITELN('9  --  NEGATE');
		WRITELN('10 --  ABSOLUTE VALUE');
		WRITELN;
		WRITELN('11 --  PK A STRING');
		WRITELN('12 --  UNPK');
		WRITELN;
		WRITE('ENTER YOUR SELECTION');
		READLN(INPINT);
		CASE INPINT OF
			0: LOOPER := TRUE;
			1: TRYADD;
			2: TRYSUB;
			3: TRYDIV;
			4: TRYMUL;
			5: TRYEQP;
			6: TRYGTP;
			7: TRYLTP;
			8: TRYRND;
			9: TRYNEG;
			10: TRYABS;
			11: TRYPK;
			12: TRYUNPK;
			OTHERWISE WRITELN(' RESPONSE MUST BE FROM 0 THRU 12, TRY AGAIN');
		END;
	UNTIL LOOPER;
	
END.
