/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program.: KnowledgeMan/2 Function Library
* Module..: pgRefTb2.IPF
* Version.: 1987-1 Spring
* Function: Maintain your two field reference tables - sub-IPF.
* Author..: William H. Mueller
* Date....: February 2, 1987
* Last Upd: July 23, 1987 - Minor enchancements to working of
*           function and screen appearance.
* Notice..: (C) Copyright 1986, 87  Mueller's PC Consulting
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Called from pgRefTb1.IPF which selects which table to work on.
   Add, Edit, Delete and Print(either one record or listing of all)
   of your Reference Tables.
   Assumes each table has 2 fields = CODE & DESC.
   Five parameter vars that must be set prior to invoking this IPF,
   see pgRefTb1.IPF for details.
   Note: The "Print" in the table edit menu only prints the
         current record.  A opportunity for a total listing is given
         upon exiting.
*/

LOCAL ilMnuCho slTblNam slCodLab slDesLab blInUse
LOCAL ilCurRec slCodeIn slDelAns slPrtAns ilPMar slPEje blSErr
 ilMnuCho = 0
 slTblNam = SUBSTR(#B, 1, LEN(#B))
 slCodLab = #B + ".Code"
 slDesLab = #B + ".Desc"
 ilCurRec = 0
 slCodeIn = "                    "
 slDelAns = " "
 slPrtAns = " "
 ilPMar = E.PMar
 slPEje = E.PEje
 blSErr = E.SErr

E.SErr = TRUE           ! Primarily in case of an empty table.

IF INUSE(#B) THEN blInUse = TRUE
ELSE
  USE #B WITH #C
  blInUse = FALSE
ENDIF
DEFAULT ^slTblNam

LOCAL FORM flBorder
 AT 6,2 PUT "=======================================" WITH "L"
 AT 6,41 PUT "=======================================" WITH "L"
ENDFORM

LOCAL FORM flDspRec
  AT 8,7 PUT #A WITH "RL"
  AT 8,(LEN(#A)+12) PUT "Records in Table:" WITH "L"
  AT 8,(LEN(#A)+31) PUT LASTREC(^slTblNam) USING "ddddd"
  AT 10,5 PUT ^LABEL(^slCodLab) + ":" WITH "L"
  AT 10,(LEN(LABEL(^slCodLab))+7) PUT ^slCodLab USING #D
  AT 12,5 PUT ^LABEL(^slDesLab) + ":" WITH "L"
  AT 12,(LEN(LABEL(^slDesLab))+7) PUT ^slDesLab USING #E
  AT 12,(LEN(LABEL(^slDesLab))+7) GET ^slDesLab USING #E
ENDFORM

LOCAL DIM alEdMnu(8)    !Edit menu array
 alEdMnu(1) = " Print  "
 alEdMnu(2) = " Prior  "
 alEdMnu(3) = "  Next  "
 alEdMnu(4) = "  EXIT  "
 alEdMnu(5) = "  Edit  "
 alEdMnu(6) = "  Find  "
 alEdMnu(7) = "  Add   "
 alEdMnu(8) = " Delete "

LOCAL FORM flBlank1
  AT 1,1 PUT " "
  AT 1,80 PUT " "
ENDFORM

OBTAIN FIRST FROM ^slTblNam
ilCurRec = CURREC(^slTblNam)
PUTFORM flBorder; PUTFORM flDspRec; TALLY flDspRec
WHILE TRUE DO      !Edit Menu loop
  DRAIN(); CLEAR flBlank1 AT 5,1
  ilMnuCho = MENU(alEdMnu, 4, 8, 5, 1, 0, 10, 8)
  IF ilMnuCho = 4 OR ilMnuCho = 0 THEN BREAK; ENDIF    !Function exit
  CLEAR flBlank1 AT 5,1
  AT 5,(1+(((ilMnuCho-1)*10)+1)) ? alEdMnu(ilMnuCho)
  TEST ilMnuCho
    CASE 3:     !Obtain next
      OBTAIN NEXT FROM ^slTblNam FOR #Mark <> TRUE
      IF PASTEND(^slTblNam) THEN
        AT 15,5 ? "At END of table - use PRIOR or FIND options."
        SLEEP(2); CLEAR flBlank1 AT 15,1
      ENDIF
      ilCurRec = CURREC(^slTblNam); TALLY flDspRec
      BREAK
    CASE 2:     !Obtain prior
      OBTAIN PRIOR FROM ^slTblNam FOR #Mark <> TRUE
      IF ilCurRec = CURREC(^slTblNam) THEN
        AT 15,5 ? "At BEGINNING of table - use NEXT or FIND options."
        SLEEP(2); CLEAR flBlank1 AT 15,1
      ENDIF
      ilCurRec = CURREC(^slTblNam); TALLY flDspRec
      BREAK
    CASE 5:     !Edit
      IF LASTREC(^slTblNam) <> 0 THEN DRAIN(); GETFORM flDspRec
      ELSE
        AT 15,10 ? "** No records exist to Edit. **"
        SLEEP(2); CLEAR flBlank1 AT 15,1
      ENDIF
      BREAK
    CASE 6:     !Find
      WHILE TRUE DO DRAIN(); slCodeIn = " "
        AT 15,5 INPUT slCodeIn USING #D WITH\
         "Enter Code to FIND or press <RETURN> to abort: "
        IF slCodeIn = " " THEN BREAK; ENDIF
        PLUCK slCodeIn FROM ^slTblNam
        IF #FOUND THEN BREAK
        ELSE
          AT 18,10 ?\
    "** Exact Code NOT found.  Press <Return> for closest record. **"
          SLEEP(3); CLEAR flBlank1 AT 18,1
        ENDIF
      ENDWHILE
      ilCurRec = CURREC(^slTblNam); TALLY flDspRec
      CLEAR flBlank1 AT 15,1
      BREAK
    CASE 7:     !Add
      WHILE TRUE DO DRAIN(); slCodeIn = " "
        AT 15,5 INPUT slCodeIn USING #D WITH\
         "Enter Code to ADD or press <RETURN> to abort: "
        IF slCodeIn = " " THEN BREAK; ENDIF
        PLUCK slCodeIn FROM ^slTblNam
        IF #FOUND THEN
          AT 18,10 ? "** Code ALREADY exists - use FIND/EDIT. **"
          SLEEP(2); CLEAR flBlank1 AT 18,1
        ELSE
          E.IMrk = FALSE
          PLUCK " " FROM ^slTblNam
          IF NOT #FOUND THEN ATTACH 1 TO ^slTblNam; ENDIF
          #Mark = FALSE
          Code = slCodeIn
          E.IMrk = TRUE
          TALLY flDspRec; GETFORM flDspRec
          BREAK
        ENDIF
      ENDWHILE
      ilCurRec = CURREC(^slTblNam)
      TALLY flDspRec; CLEAR flBlank1 AT 15,1
      BREAK
    CASE 8:     !Delete
      DRAIN(); slDelAns = " "
      WHILE slDelAns <> "Y" AND slDelAns <> "N" DO
        AT 15,5 INPUT slDelAns USING "u" WITH\
         "Please confirm that you wish to DELETE this Code (Y/N): "
      ENDWHILE
      IF slDelAns = "Y" THEN
        Code = ""
        Desc = ""
        #Mark = TRUE
        OBTAIN FIRST FROM ^slTblNam    
      ENDIF
      ilCurRec = CURREC(^slTblNam); TALLY flDspRec
      CLEAR flBlank1 AT 15,1
      BREAK
    CASE 1:     !Print one
      AT 15,5 ?\
       "Insure Printer is ready. Press any key to continue..."
      WAIT
      PRINT flDspRec WITH GET
      CLEAR flBlank1 AT 15,1
      BREAK
  ENDTEST      !TEST ilMnuCho
ENDWHILE      !Edit Menu loop

CLEAR flDspRec
CLEAR flBorder
CLEAR flBlank1 AT 5,1

slPrtAns = " "; DRAIN()
WHILE slPrtAns <> "N" AND slPrtAns <> "Y" DO
  AT 10,5 INPUT slPrtAns USING "u" WITH\
   "Would you like a printout of the  " + #A + "  (Y/N): "
ENDWHILE
IF slPrtAns = "Y" THEN
  LOCAL ilPapLen ilPgCnt ilLnCnt
   ilPapLen = 11                        !Length of paper
   ilPgCnt = 1                          !Page counter
   ilLnCnt = 0                          !Line counter
  DRAIN()
  AT 12,10 INPUT ilPapLen USING "nn" WITH\
   "Please enter your paper length in inches - (11/14): "
  CLEAR flBlank1 AT 12,1
  DRAIN()
  AT 12,10 ? "Insure Printer is ready.  Press any key to continue..."
  WAIT
  CLEAR flBlank1 AT 12,1
  AT 12,25 ? "Printing Report - Please Wait."
  ilPapLen = (ilPapLen * 6) - 6
  E.PMar = 5
  E.PEje = ""                           !Turn off KMan page EJECT
  E.OCon = FALSE; E.OPrn = TRUE
  OBTAIN FIRST FROM ^slTblNam
  WHILE NOT PASTEND(^slTblNam) DO
    ? " "
    ? "                        ", #A
    ? " Print Date: ", #DATE,
    ? "                                   ",
    ? "Page Num: ", ilPgCnt USING "ddd"
    ? "  Code               Description"
    ? "=============================================",
    ? "==========================="
    ? " "
    ilLnCnt = 7
    WHILE ilLnCnt < ilPapLen AND NOT PASTEND(^slTblNam) DO
      ? "  " + Code + "     " + Desc
      ilLnCnt = ilLnCnt + 1
      OBTAIN NEXT FROM ^slTblNam
    ENDWHILE
    IF PASTEND(^slTblNam) THEN
      ? " "
      ? "===================  End of Table",
      ? " Information Report  =================="
      BREAK
    ENDIF
    ilPgCnt = ilPgCnt + 1
    ? CHR(12)
  ENDWHILE
  E.OPrn = FALSE
  E.PEje = slPEje
  E.PMar = ilPMar
  EJECT
  E.OCon = TRUE
  CLEAR flBlank1 AT 12,1
ENDIF
CLEAR flBlank1 AT 10,1
E.SErr = blSErr

IF NOT blInUse THEN FINISH ^slTblNam; ENDIF
