#!/bin/sh

dir="CHANGETHIS"

if [ ! -d $dir ]; then
 logger -i "rc5des client directory doesn't exist. ($dir)."
 exit
fi

if [ ! -f $dir/rc5des ]; then
 logger -i "rc5des client doesn't exist. ($dir/rc5des)."
 exit
fi

if [ ! -f $dir/rc5des.ini ]; then
 logger -i "rc5des client config file doesn't exist. ($dir/rc5des.ini)."
 exit
fi

email=`grep "^id=" $dir/rc5des.ini|cut -d"=" -f2`

if [ $email = "freebsd@distributed.net" ]; then
 logger -i "rc5des client running with default email address. ($email)"
fi

echo -n " rc5des"
su -m nobody -c "$dir/rc5des -quiet" 2>/dev/null >/dev/null &
