-ARCHIVE- $8087.asm 6016
;	floating point routines

finit	macro
	wait
	esc	01ch,bx
	endm

fld	macro	x,y,z
	wait
	ifidn	<&x>,<byte>
	esc	8,x y z
	else
	esc	028h,x y z
	endif
	endm

fwait	macro
	wait
	endm

fistp	macro	x,y,z
	wait
	ifidn	<&x>,<byte>
	esc	01bh,x y z
	else
	esc	03bh,x y z
	endif
	endm

fsub	macro
	wait
	esc	04h,cl
	endm

fstp	macro	x,y,z
	wait
	ifidn	<&x>,<byte>
	esc	0bh,x y z
	else
	esc	02bh,x y z
	endif
	endm

fild	macro	x,y,z
	wait
	ifidn	<&x>,<byte>
	esc	18h,x y z
	else
	esc	38h,x y z
	endif
	endm

fildli	macro	x,y,z
	wait
	esc	3dh,x y z
	endm

fadd	macro
	wait
	esc	0,cl
	endm

fdiv	macro
	wait
	esc	6,cl
	endm

fmul	macro
	wait
	esc	1,cl
	endm

fcompp	macro
	wait
	esc	33h,cl
	endm

fstsw	macro	x,y,z
	wait
	esc	2fh,x y z
	endm

fldcw	macro	x,y,z
	wait
	esc	0dh,x y z
	endm

code	segment	byte public
	assume	cs:code


;	negate a number
	public	$dneg
$dneg:

	mov	bx,sp		;get base address in stack
	test	word ptr 8[bx],07ff0h	;is number zero ?
	jz	dneg01		;yes, don't negate
	xor	byte ptr 9[bx],080h	;and negate it
dneg01:
	ret

;	convert a double to long
;	leaving the double on the stack
;	and the long in ax and dx
;	must not destroy si

	public	$lcvtd
$lcvtd:

	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 4[bp]	;load the value
	mov	ax,7ffh
	push	ax
	push	ax
	fldcw	byte ptr -4[bp]	;no rounding
	fistp	byte ptr -4[bp]
	fwait
	pop	ax
	pop	dx		;thats our result
	pop	bp
	ret			;all done

;	subtract the double float on top of stack from next double

;	entry	two doubles on stack
;	exit	difference on stack
;	must preserv si

	public	$dsub
$dsub:

	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 12[bp]
	fld	word ptr 4[bp]
	fsub
	fstp	word ptr 12[bp]
	fwait
	pop	bp
	ret	8

;	add two double float numbers and return result on stack

;	entry	two doubles on stack
;	exit 	the sum is on the stack
;	must preserv si

	public	$dadd
$dadd:

	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 12[bp]
	fld	word ptr 4[bp]
	fadd
	fstp	word ptr 12[bp]
	fwait
	pop	bp
	ret	8

;	convert signed long to double
;	entry	long on stack

	public	$dcvtl
$dcvtl:

	finit			;precaution for now
	pop	ax
	sub	sp,4
	push	ax
	push	bp
	mov	bp,sp
	fild	byte ptr 8[bp]
	jmp	short dcvti00		;do the rest

;	convert signed integer to double
;	entry	integer on stack

	public	$dcvti
$dcvti:

	finit			;precaution for now
	pop	ax
	sub	sp,6
	push	ax
	push	bp
	mov	bp,sp
	fild	word ptr 10[bp]
dcvti00:
	fstp	word ptr 4[bp]
	pop	bp
	fwait
	ret

;	convert an unsigned long to double
;	entry	number on the stack

	public	$dcvtul
$dcvtul:

	finit			;precaution for now
	pop	cx
	pop	ax
	pop	dx
	jmp	short dcvtui00		;do the rest

;	convert unsigned integer to double
;	entry	integer on stack

	public	$dcvtui
$dcvtui:

	finit			;precaution for now
	pop	cx
	pop	ax
	xor	dx,dx			;sign extend it
dcvtui00:
	xor	bx,bx
	push	bx
	push	bx
	push	dx
	push	ax
	push	cx
	push	bp
	mov	bp,sp
	fildli	word ptr 4[bp]
	fstp	word ptr 4[bp]
	fwait
	pop	bp
	ret

;	multiply two double float numbers and return result on stack

;	entry	two doubles on stack
;	exit 	the product is on the stack
;	must preserv di

	public	$dmul
$dmul:

	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 4[bp]
	fld	word ptr 12[bp]
	fmul
	fstp	word ptr 12[bp]
	fwait
	pop	bp
	ret	8

;	divide two double float numbers and return result on stack

;	entry	two doubles on stack
;	exit 	the result is on the stack
;	must preserv di

	public	$ddiv
$ddiv:

	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 12[bp]
	fld	word ptr 4[bp]
	fdiv
	fstp	word ptr 12[bp]
	pop	bp
	fwait
	ret	8

;	double precision floating point comparison routines

	public	$dceq,$dcne,$dcls,$dcle,$dcge,$dcgr

$dceq:			;return true if equal
	mov	dl,2
	jmp	short dcomp

$dcne:			;return true if not equal
	mov	dl,5
	jmp	short dcomp

$dcls:			;return true if less
	mov	dl,1
	jmp	short dcomp

$dcle:			;return true if less or equal
	mov	dl,3
	jmp	short dcomp

$dcgr:			;return true if greater
	mov	dl,4
	jmp	short dcomp

$dcge:			;return true if greater or equal
	mov	dl,6
;	jmp	short dcomp

;	actual routine to do comparison of two doubles on stack

dcomp:
	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 12[bp]
	fld	word ptr 4[bp]
	fcompp
	fstsw	word ptr 4[bp]
	fwait
	mov	ah,5[bp]
	sahf
	jb	dcomp02
	je	dcomp01
	sar	dl,1
dcomp01:
	sar	dl,1
dcomp02:
	xchg	al,dl
	and	ax,1
	mov	18[bp],ax
	pop	bp
	ret	14

;	load a real to the stack

;	entry	address of real in reg si
;	exit	double on stack
;	must preserv si

	public	$fload
$fload:

	finit			;precaution for now
	fld	byte ptr [si]		;load the value
	jmp	short dload1			;all common processing

;	load a double to the stack

;	entry	address of double in reg si
;	exit	double on stack
;	must preserv si

	public	$dload
$dload:

	finit			;precaution for now
	fld	word ptr [si]		;load the value
dload1:
	pop	ax			;get the return address
	sub	sp,8			;make some space
	push	ax
	push	bp
	mov	bp,sp
	fstp	word ptr 4[bp]	;stack the value
	pop	bp
	fwait				;wait for it
	ret				;all done

;	store a float from the stack

;	entry	di, address to store float
;	exit	float stored and still on stack (as a double)

	public	$fstore
$fstore:

	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 4[bp]	;get the value
	fstp	byte ptr [di]		;and store it
	pop	bp
	fwait
	ret

;	store a double from the stack

;	entry	di, addres to store double
;	exit	stored and also on the stack

	public	$dstore
$dstore:

	finit			;precaution for now
	push	bp
	mov	bp,sp
	fld	word ptr 4[bp]	;get the value
	fstp	word ptr [di]		;and store it
	pop	bp
	fwait
	ret

code	ends
	end
                                               -ARCHIVE- $floatpp.asm 14738
;	floating point routines


code	segment	byte public
	assume	cs:code

	public	$dneg,$lcvtd,$dsub,$dadd,$dcvtl,$dcvti
	public	$dcvtul,$dcvtui,$dmul,$ddiv
	public	$dceq,$dcne,$dcls,$dcle,$dcgr,$dcge

;	negate a number

$dneg:

	mov	bx,sp		;get base address in stack
	test	word ptr 8[bx],07ff0h	;is number zero ?
	jz	dneg01		;yes, don't negate
	xor	byte ptr 9[bx],080h	;and negate it
dneg01:
	ret

;	convert a double to long
;	leaving the double on the stack
;	and the long in ax and dx

$lcvtd:

	push	si		;save si
	push	bp
	mov	bp,sp
	sub	sp,10		;working space
	mov	cx,4		;words
	lea	si,6[bp]	;source
	mov	di,sp		;destination
	call	msw		;perform move string words
	mov	ax,-4[bp]	;get sign of number
	and	ax,8000h
	xor	-4[bp],ax	;make number positive
	mov	-2[bp],ax	;and save for exit
	mov	ax,4330h	;unnormalise number
	push	ax
	xor	ax,ax
	push	ax
	push	ax
	push	ax
	call	$dadd		;do it
	mov	ax,-10[bp]
	mov	dx,-8[bp]
	mov	bx,-2[bp]	;was it negative
	or	bx,bx
	jz	lcd01		;nope
	neg	dx
	neg	ax
	sbb	dx,0
lcd01:
	mov	sp,bp
	pop	bp
	pop	si		;restore si
	ret			;all done


;	subtract the double float on top of stack from next double

;	entry	two doubles on stack
;	exit	difference on stack
;	must preserv si

$dsub:

	mov	bx,sp		;get stack address
	mov	ax,08000h
	xor	16[bx],ax	;invert sign to subtract


;	add two double float numbers and return result on stack

;	entry	two doubles on stack
;	exit 	the sum is on the stack
;	must preserv si

$dadd:

	push	si		;save it for exit
	push	bp
	mov	bp,sp		;establish frame pointer
	mov	ax,07ff0h
	test	ax,12[bp]	;top operand zero ?
	jz	das00		;yes, just exit
	test	ax,20[bp]	;or the other
	jnz	das01		;nope

	mov	cx,4		;words
	lea	si,6[bp]	;source
	lea	di,14[bp]
	call	msw		;perform move string words
das00:
	jmp	das99		;all done
das01:
	sub	sp,24		;room for temps
	lea	si,6[bp]	;unpack the top operand
	mov	di,sp
	call	unpack
	lea	si,14[bp]
	lea	di,-12[bp]
	call	unpack		;second operand

	mov	si,sp		;prepare to scale
	lea	di,-12[bp]
	mov	ax,2[si]
	sub	ax,2[di]
	jz	das10		;no scaling required
	jns	das02		;no reverse reqd
	xchg	di,si		;exchange registers
	neg	ax		;restore exponent in register
das02:
	add	2[di],ax	;adjust exponent
	mov	cl,4		;make exponent an integer
	shr	ax,cl
	mov	cx,ax		;get the shift count
das03:
	mov	bx,6		;offset and count
	clc
das04:
	rcr	word ptr 4[bx+di],1
	dec	bx
	dec	bx
	jns	das04		;shift it down
	loop	das03		;for all bits
das10:
	mov	cx,4		;loop count
	mov	bx,cx		;initialise offset
	mov	ax,[di]		;add or subtract ?
	xor	ax,[si]
	js	das12		;it is subtract
	clc
das11:
	mov	ax,[bx+si]	;get a word
	adc	[bx+di],ax
	inc	bx		;add 2 without changing carry
	inc	bx
	loop	das11
	jmp	das20
das12:
	clc
das13:
	mov	ax,[bx+si]	;get a word
	sbb	[bx+di],ax	;do subtract
	inc	bx		;add 2 without changing carry
	inc	bx
	loop	das13

	mov	ax,10[di]	;is result negative ?
	or	ax,ax
	jns	das20		;nope
	xor	ax,ax
	mov	cx,4
	mov	bx,cx
	stc			;set carry
das14:
	not	word ptr [bx+di];negate word 
	adc	[bx+di],ax	;the hard way
	inc	bx
	inc	bx
	loop	das14
	mov	ah,080h
	xor	[di],ax		;and reverse sign
das20:				;pack the result
	push	di
	call	normalize	;normalize the result
	pop	si
	lea	di,14[bp]	;destination address
	call	repack		;pack the result

das99:
	test	word ptr 20[bp],07ff0h	;is result zero
	jnz	das999		;nope
	mov	word ptr 20[bp],0	;set result to zero
das999:
	mov	sp,bp
	pop	bp
	pop	si		;restore si
	ret	8		;all done

;	convert signed long to double
;	entry	long on stack

$dcvtl:

	pop	si
	pop	ax
	pop	dx
	jmp	short dcvti00		;do the rest

;	convert signed integer to double
;	entry	integer on stack

$dcvti:

	pop	si		;get return address
	pop	ax		;get integer
	cwd			;sign extend it
dcvti00:
	xor	bx,bx
	push	bx
	push	bx
	or	dx,dx		;is it negative
	jns	dcvti01		;nope
	neg	dx
	neg	ax
	sbb	dx,0
	or	bh,080h		;set sign
dcvti01:
	push	dx
	push	ax
	mov	ax,04330h	;basic exponent
	push	ax
	push	bx		;sign
	mov	di,sp
	push	si
	push	di
	call	normalize
	pop	si
	mov	di,si
	add	di,4
	call	repack
	ret	4

;	convert an unsigned long to double
;	entry	number on the stack

$dcvtul:

	pop	si
	pop	ax
	pop	dx
	jmp	short dcvtui00		;do the rest

;	convert unsigned integer to double
;	entry	integer on stack

$dcvtui:

	pop	si		;get return address
	pop	ax		;get integer
	xor	dx,dx
dcvtui00:
	push	dx
	xor	bx,bx
	push	bx
	push	bx
	push	ax
	mov	ax,04330h	;basic exponent
	push	ax
	push	bx		;sign
	mov	di,sp
	push	si
	push	di
	call	normalize
	pop	si
	mov	di,si
	add	di,4
	call	repack
	ret	4


;	subroutine to move a string of words
;	entry	cx, number of words to move
;		si, source address relative to ds
;		di, dest address rel to ds

msw:
	cld			;set the direction flag
	mov	ax,ds
	mov	es,ax		;set the es register
	rep movsw
	ret


;	subroutine to unpack a double
;	entry	si, address of double
;		di, where to unpack it

unpack:
	push	di
	mov	cx,4		;number of words to move
	add	di,cx		;correct offset
	call	msw
	pop	di		;thats the data copied
	mov	ax,10[di]	;get most significant word
	mov	bx,ax		;copy it
	and	ax,07ff0h	;get exponent
	mov	2[di],ax	;save it
	mov	ax,bx
	and	ax,08000h	;get sign
	mov	[di],ax		;save it too
	and	bx,0fh
	or	bx,010h		;set significant bit of mantissa
	mov	10[di],bx
	ret


;	subroutine to repack a double
;	entry	si, source of data
;		di, destination address

repack:

	push	si
	push	di
	mov	cx,4
	add	si,cx
	call	msw
	pop	di
	pop	si
	mov	ax,10[si]
	and	ax,0fh
	or	ax,[si]
	or	ax,2[si]
	mov	6[di],ax
	ret


;	normalize an unpacked double

;	entry	di, address of unpcaked number to be normalised


normalize:

	mov	ax,4[di]	;see if zero
	or	ax,6[di]
	or	ax,8[di]
	or	ax,10[di]
	jnz	norf10
	mov	[di],ax		;set it all to zero
	mov	2[di],ax
	jmp	norf99		;all done
norf10:
	mov	bx,010h		;adjust exponent constant
	mov	ax,0ffe0h	;see if too large
norf11:
	test	ax,10[di]	;get the most significant word
	jz	norf20		;nope
	shr	word ptr 10[di],1	;shift it right
	rcr	word ptr 8[di],1
	rcr	word ptr 6[di],1
	rcr	word ptr 4[di],1
	add	word ptr 2[di],bx
	jmp	norf11
norf20:
	mov	ax,010h
norf21:
	test	ax,10[di]
	jnz	norf99		;all done
	shl	word ptr 4[di],1
	rcl	word ptr 6[di],1
	rcl	word ptr 8[di],1
	rcl	word ptr 10[di],1
	sub	2[di],bx		;adjust exponent
	jmp	norf21
norf99:
	ret



;	multiply two double float numbers and return result on stack

;	entry	two doubles on stack
;	exit 	the product is on the stack
;	must preserv di


$dmul:

	push	di		;save di for posterity
	push	bp
	mov	bp,sp		;establish frame pointer
	mov	ax,07ff0h
	test	ax,20[bp]	;second operand zero ?
	jz	mul00		;yes, just exit
	test	ax,12[bp]	;or the other
	jnz	mul01		;nope

	mov	cx,4		;words
	lea	si,6[bp]	;source
	lea	di,14[bp]
	call	msw		;perform move string words
mul00:
	jmp	mul99		;all done
mul01:
	sub	sp,24		;room for temps
	lea	si,6[bp]	;unpack the top operand
	mov	di,sp
	call	unpack
	lea	si,14[bp]
	lea	di,-12[bp]
	call	unpack		;second operand

	xor	bx,bx		;set up working area for multiply
	push	bx
	push	bx
	push	bx
	push	bx
	push	bx
	push	bx
	mov	si,sp		;create base for operation
	call	mulxx		;calc reloaction address
mulxx:
	pop	di
;WARNING--FOLLOWING TWO INSTRUCTIONS CANNOT BE COMBINED--BUG IN ASM86
	add	di,offset multab
	sub	di,offset mulxx	;address of mult table
;WARNING--SEE ABOVE
	mov	cx,13		;number of entries in table
mul02:
	mov	bl,cs:[di]	;get offset of operand 1
	mov	ax,[bx+si]	;get it
	or	ax,ax		;if zero, fast continue
	jz	mul04
	mov	bl,cs:1[di]	;get offset of other operand
	mul	word ptr [bx+si]	;unsigned multiply
	mov	bl,cs:2[di]	;get result address
	add	[bx+si],ax	;add in result
	inc	bx
	inc	bx
	adc	[bx+si],dx	;upper half
	jae	mul04		;all carry done (carry == 0)
mul03:
	inc	bx
	inc	bx
	inc	word ptr [bx+si]	;do the carry
	jz	mul03		;still more carry
mul04:
	add	di,3		;to next frame
	loop	mul02		;do all words
	mov	ax,-10[bp]	;calc the result exponent
	sub	ax,04030h	;adjust for exponent and shift in mult routine
	add	ax,-22[bp]
	mov	-34[bp],ax	;and store it
	mov	ax,-12[bp]	;get sign of result
	xor	ax,-24[bp]
	mov	-36[bp],ax

	mov	di,sp
	call	normalize	;normalize the result
	mov	si,sp
	lea	di,14[bp]	;destination address
	call	repack		;pack the result

mul99:
	mov	sp,bp
	pop	bp
	pop	di		;restore di
	ret	8		;all done


;	multiplication table required above

multab:
	db	+24+10,+12+10,+10
	db	+24+8,+12+10,+8
	db	+24+10,+12+8,+8
	db	+24+8,+12+8,+6
	db	+24+6,+12+10,+6
	db	+24+6,+12+8,+4
	db	+24+6,+12+6,+2
	db	+24+10,+12+6,+6
	db	+24+8,+12+6,+4
	db	+24+4,+12+10,+4
	db	+24+4,+12+8,+2
	db	+24+10,+12+4,+4
	db	+24+8,+12+4,+2



;	divide two double float numbers and return result on stack

;	entry	two doubles on stack
;	exit 	the result is on the stack
;	must preserv di


$ddiv:

	push	di		;save di for posterity
	push	bp
	mov	bp,sp		;establish frame pointer
	mov	ax,07ff0h
	test	ax,12[bp]	;second operand zero ?
	jnz	div000		;nope, test other operand
	mov	cx,4
	lea	si,6[bp]
	lea	di,14[bp]
	call	msw
	jmp	short div00
div000:
	test	ax,20[bp]	;or the other
	jnz	div01		;nope

	mov	ax,0ffffh	;set overflow with large number
	mov	14[bp],ax
	mov	16[bp],ax
	mov	18[bp],ax
	and	ah,07fh
	or	20[bp],ax	;preserve sign
div00:
	jmp	div99		;all done
div01:
	sub	sp,12
	lea	si,6[bp]	;get operand
	mov	di,sp
	call	unpack
	pop	bx		;save sign
	pop	cx		;and exponent
	xor	ax,ax		;some scratch space
	push	ax
	push	ax
	push	ax
	push	ax
	push	cx
	push	bx		;put it back

	sub	sp,12		;room for other temp
	lea	si,14[bp]	;unpack the top operand
	mov	di,sp
	call	unpack

	mov	cx,53		;number of bits to divide
div02:
	push	cx		;save bit count
	mov	cx,4		;number of words to compare
	lea	si,-22[bp]
	lea	di,-2[bp]
div03:
	mov	ax,[si]		;get divisor word
	cmp	ax,[di]		;compare to dividend
	jb	div04		;yes it divides
	ja	div06		;no it does not
	dec	si		;a solid maybe
	dec	si
	dec	di
	dec	di
	loop	div03
div04:				;yes it does
	mov	cx,4
	lea	si,-28[bp]
	lea	di,-8[bp]
	clc
div05:
	mov	ax,[si]
	sbb	[di],ax
	inc	si
	inc	si
	inc	di
	inc	di
	loop	div05
	stc
div06:
	mov	cx,8		;number of words to shift
	lea	si,-16[bp]
div07:
	rcl	word ptr [si],1
	inc	si
	inc	si
	loop	div07

	pop	cx
	loop	div02		;next bit

	mov	ax,-30[bp]	;calc the result exponent
	sub	ax,03ff0h	;adjust for exponent and shift in div routine
	sub	-18[bp],ax	;store adjusted exponent

	mov	ax,-32[bp]	;get sign of result
	xor	-20[bp],ax	;and save it

	lea	di,-20[bp]
	call	normalize	;normalize the result
	lea	si,-20[bp]
	lea	di,14[bp]	;destination address
	call	repack		;pack the result

div99:
	mov	sp,bp
	pop	bp
	pop	di		;restore di
	ret	8		;all done

;	double precision floating point comparison routines

$dceq:			;return true if equal
	mov	ax,202H
	jmp	short dcomp		;do internal comparison routine

$dcne:			;return true if not equal
	mov	ax,505H
	jmp	short dcomp		;do internal comparison routine

$dcls:			;return true if less
	mov	ax,401H
	jmp	short dcomp		;do internal comparison routine

$dcle:			;return true if less or equal
	mov	ax,603H
	jmp	short dcomp		;do internal comparison routine

$dcgr:			;return true if greater
	mov	ax,104H
	jmp	short dcomp		;do internal comparison routine

$dcge:			;return true if greater or equal
	mov	ax,306H
;	jmp	short dcomp		;do internal comparison routine


;	actual routine to do comparison of two doubles on stack

dcomp:
	mov	bx,sp		;get a stack pointer
	mov	ch,9[bx]
	mov	dh,17[bx]
	mov	cl,ch
	or	cl,dh
	jns	dcomp00		;both positive, continue
	mov	cl,ch
	xor	cl,dh
	jns	dcomp000	;both negative
	cmp	dh,ch
	jge	dcomp031
	jmp	short dcomp04
dcomp000:
	mov	al,ah		;invert test conditions
dcomp00:
	mov	cx,4
dcomp01:
	mov	dx,16[bx]
	cmp	8[bx],dx
	jnz	dcomp03
	dec	bx
	dec	bx
	loop	dcomp01

dcomp02:			;numbers are equal, set result
	and	al,2
	jz	dcomp99		;false
	jmp	short dcomp98		;true
dcomp03:			;numbers are not equal
	ja	dcomp04		;greater
dcomp031:
	and	al,1
	jz	dcomp99
	jmp	short dcomp98		;true
dcomp04:
	and	al,4
	jz	dcomp99
;	jmp	short dcomp98

dcomp98:			;set true
	mov	al,1
dcomp99:
	xor	ah,ah		;clear the top byte
	or	ax,ax		;set the flags
	mov	bx,sp
	mov	16[bx],ax	;result to stack
	ret	14		;dump the rest

;	load a double to the stack

;	entry	address of double in reg si
;	exit	double on stack
;	must preserv si

	public	$dload,$dstore

$dload:
	pop	di			;return address to di
	push	word ptr 6[si]		;put exponent
	push	word ptr 4[si]
	push	word ptr 2[si]
	push	word ptr [si]		;least significant word
	jmp	di			;return

;	store a double from the stack

;	entry	di, addres to store double
;	exit	stored and also on the stack

$dstore:
	pop	si			;get return address
	pop	ax
	pop	dx
	pop	bx
	pop	cx
	mov	[di],ax
	mov	2[di],dx
	mov	4[di],bx
	mov	6[di],cx
	push	cx
	push	bx
	push	dx
	push	ax
	jmp	si			;return

;	load a real to the stack

;	entry	address of real in reg si
;	exit	double on stack
;	must preserv si

	public	$fload,$fstore

$fload:
	pop	di			;get return address
	mov	ax,2[si]		;get exponent
	mov	dx,[si]			;low word
	xor	bx,bx			;zero it
	mov	cx,3			;number of bits to shift
ldr01:	sar	ax,1
	rcr	dx,1
	rcr	bx,1
	loop	ldr01			;three times
	and	ax,08fffh		;clear exponent bits
	jnz	ldr02			;it's real
	push	ax
	push	ax
	push	ax
	jmp	short ldr03		;final and return
ldr02:
	add	ax,3800h		;(3ffh-7fh) shl 4;adjust exponent
	push	ax
	push	dx
	push	bx
	xor	ax,ax
ldr03:
	push	ax
	jmp	di			;return

;	store a float from the stack

;	entry	di, address to store float
;	exit	float stored and still on stack (as a double)


$fstore:
	mov	si,sp			;make pointer to stack
	mov	ax,8[si]		;get exponent part
	and	ax,07ff0h		;only
	sub	ax,3ff0h		;remove bias
	cmp	ax,07f0h
	jg	fst10			;too large to save
	cmp	ax,-07f0h
	jl	fst20			;too small to save
	mov	ax,8[si]		;get exponent part
	sub	ax,3ff0h-7f0h		;reduce exponent range
	jns	fst01			;not negative
	or	ah,10h			;set new sign bit
fst01:
	mov	dx,6[si]
	mov	bx,4[si]
	mov	cx,3			;shift it left
fst02:
	shl	bx,1
	rcl	dx,1
	rcl	ax,1
	loop	fst02
	jmp	short fst99		;and out we go
fst10:
	mov	ax,8[si]		;keep sign
	or	ax,7fffh
	mov	dx,0ffffh		;largest possable number
	jmp	short fst99
fst20:
	xor	ax,ax			;result is zero (really underflow)
	cbw
fst99:
	mov	[di],dx			;low order word
	mov	2[di],ax		;high order word
	ret

code	ends
	end
-ARCHIVE- $ldivmod.asm 1408
;	does division of two signed longs


code	segment	byte public
	assume	cs:code
	public	$lsdiv,$ludiv,$lsmod,$lumod

$lsdiv:
	xor	al,al			;signed div
	jmp	short dm01

$ludiv:
	mov	al,1			;unsigned div
	jmp	short dm01

$lsmod:
	mov	al,2			;signed mod
	jmp	short dm01

$lumod:
	mov	al,3

dm01:

	push	bp
	mov	bp,sp
	push	di			;save for caller
	cbw				;zero top byte
	xchg	ax,bx			;save flags

	mov	ax,4[bp]
	mov	dx,6[bp]
	mov	si,8[bp]
	mov	di,10[bp]

	test	bl,1			;signed ?
	jnz	dm03			;nope
	or	dx,dx
	jns	dm02
	neg	dx
	neg	ax
	sbb	dx,0
	inc	bh
dm02:
	or	di,di
	jns	dm03
	neg	di
	neg	si
	sbb	di,0
	xor	bh,3
dm03:
	push	bx
	mov	cx,32		;loop counter
	xor	bx,bx		;set to zero
	push	bx
dm04:
	xchg	cx,-6[bp]	;get back dividend
	sal	ax,1		;left 1 bit
	rcl	dx,1
	rcl	bx,1
	rcl	cx,1
	cmp	di,cx		;will it go
	ja	dm06		;nope
	jb	dm05		;yes
	cmp	si,bx		;maybe
	ja	dm06
dm05:
	sub	bx,si
	sbb	cx,di
	inc	ax		;bit to result
dm06:
	xchg	cx,-6[bp]	;check loop counter
	loop	dm04
	pop	si		;get remainder
	pop	cx		;get control
	test	cl,2		;if mod, result to ax,dx
	jz	dm07
	xchg	ax,bx
	mov	dx,si
	test	ch,2
	jz	dm07
	xor	ch,1		;invert bit
dm07:
	test	cl,1		;signed ?
	jnz	dm08		;nope
	test	ch,1		;reverse sign ?
	jz	dm08		;nope
	neg	dx
	neg	ax
	sbb	dx,0
dm08:
	mov	8[bp],ax
	mov	10[bp],dx
	pop	di
	pop	bp
	ret	4

code	ends
	end
-ARCHIVE- $main.asm 4055
	title	'c86 basic support package'

;	this is the starting point for all C programs

data	segment	word public
	public	_sysvals,_systype,_exittbc
	extrn	_sysuglo:word

;	the following data structure is created and initialised by the linker
;	it specifies the size and address of uninitialised global storage
;	it is available to various routines as "_sysuglo"

;sysuglo	rw	0	;control structure generated by the linker
gfirst	equ	0	;address of first uninitialised global byte
glen	equ	2	;length of the uninitialised global region
;gclen	equ	4	;length of code segment in paragraphs

;	the following data structure is known as "_sysvals" by various
;	parts of the system, including alloc and $entry?


_sysvals	label	byte	;a control data structure for a C program
sreserv	dw	80h	;minumum stack space above heap before HEAP ERROR
htop	dw	80h	;top of heap (includes reserv) for HEAP ERROR check
savess	dw	0	;place to save entry reg ss during execution
savesp	dw	0	;place to save entry reg sp during execution
hem	db	13,10,'NO CORE$'

;	the following identifies the base operating system

_systype	dw	1	;o/s type (ms-dos)

;	the following symbol controls trace-back at _exit time

_exittbc	db	0	;0=none, 1=error, 0xff=always
		db	0,0,0,0ah,0dh,'$'	;data areas for above


data	ends

code	segment	byte public
	assume	cs:code,ds:data
	public	$main,$entry0,$entry1,$entry2,_exit
	extrn	_main:near

;	$main	entry point for c programs

$main:
	mov	dx,ss			;get data seg base
	mov	ax,ds:2			;get top of core in para units
	sub	ax,dx			;how much available
	cmp	ax,1000h		;thats the most
	jle	dm01			;use what we have
	mov	ax,1000h		;use the limit
dm01:	mov	cx,4			;clear ch at same time
	shl	ax,cl
	mov	si,80h			;command line offset
	mov	cl,[si]			;get command line count
	add	cl,3
	and	cl,0feh			;force count even
	sub	ax,cx			;get stack pointer value
	mov	sp,ax
	mov	di,ax
	mov	es,dx			;set extra segment
	cld				;to go up
	rep	movsb			;move the string
	mov	ds,dx			;set ds also
	mov	bp,cx			;clear bp

;	clear the uninitialized global storage region

	mov	di,_sysuglo+gfirst	;start of static uninitialised area
	mov	cx,_sysuglo+glen	;# of bytes to clear
	add	htop,di			;calc heap top for alloc
	add	htop,cx
	xor	ax,ax			;zero ax
	rep	stosb			;clear the area

;	call the routine _main to do other initialisation

	call	_main			;enter c system at '_main'
	jmp	short _exit

;	a heap error has occured

heap_error:
	mov	ah,9
	mov	dx,offset hem		;address of message
	int	21h			;say buy more core
	mov	ax,8000h		;set error flag
;	jmp	short _exit		;go to the exit mechanism


;	_exit	abort exit point for c programs

_exit:
	mov	bl,_exittbc	;get the trace back control byte
	or	bl,bl
	jz	tb_none		;traceback is off
	js	tb_go		;do it
	or	ax,ax		;any error returned
	jz	tb_none		;nope
tb_go:
	push	ax		;save the exit value
tb_loop:
	mov	dx,2[bp]	;get a call address
	mov	si,4		;hex digits per word
	lea	bx,_exittbc	;get the data address
tb_digit:
	mov	al,dl		;get a digit
	mov	cl,4
	shr	dx,cl		;strip the digit
	and	al,0fh		;keep low nibble
	add	al,090h
	daa
	adc	al,040h
	daa
	dec	si		;count the digit
	mov	[bx+si],al	;store the digit
	jnz	tb_digit
	mov	dx,bx
	mov	ah,9
	int	21h
	cmp	[bp],bp
	jbe	tb_done
	mov	bp,[bp]		;up the stack
	jmp	short tb_loop
tb_done:
	pop	ax		;restore ax
tb_none:
	int	20h		;we are all done

;	set up on entry to a function

$entry0:
	pop	si		;get address we came from
	xor	ax,ax		;no locals in this procedure
	jmp	short entry1
$entry1:
	pop	si		;get address we came from
	cld
	db	2eh		;seg override prefix to cs:
	lodsb			;get offset
	mov	ah,0		;as a word value
entry1:
	push	bp		;save frame pointer
	mov	bp,sp		;get new frame pointer
	sub	sp,ax		;adjust stack
	cmp	sp,htop		;how is heap space
	jbe	heap_error	;crash
	jmp	si		;go to program
$entry2:
	pop	si		;get address we came from
	cld
	db	2eh		;seg override prefix to cs:
	lodsw			;get the offset
	jmp	short entry1

code	ends
	end
-ARCHIVE- dosread.asm 583
;	random record read ( dos function 0x27 )

;	entry	1, address of int containing max # bytes to read
;		2, pointer to fcb

;	exit	1, number of bytes read returned
;		2, al value is return function value

code	segment	byte public
	assume	cs:code
	public	dosread

dosread:
	push	bp
	mov	bp,sp
	mov	bx,4[bp]		;get address of count
	mov	cx,[bx]			;get count
	mov	dx,6[bp]		;address of fcb
	mov	ah,27h			;the function code
	int	21h			;call dos
	mov	bx,4[bp]
	mov	[bx],cx			;put result size
	xor	ah,ah			;reurn al only
	pop	bp
	ret				;all done

code	ends
	end
-ARCHIVE- doswrite.asm 565
;	random record write ( dos function 0x28 )

;	entry	1, address of int containing # bytes to write
;		2, pointer to fcb

;	exit	1, number of bytes written returned
;		2, al value is return function value

code	segment	byte public
	assume	cs:code
	public	doswrite

doswrite:
	push	bp
	mov	bp,sp
	mov	bx,4[bp]		;get address of count
	mov	cx,[bx]			;get count
	mov	dx,6[bp]		;address of fcb
	mov	ah,28h
	int	21h			;call dos
	mov	bx,4[bp]
	mov	[bx],cx			;put result size
	xor	ah,ah			;reurn al only
	pop	bp
	ret				;all done

code	ends
	end
-ARCHIVE- sysint.asm 1995
;	execute an interrupt with registers set up

;	entry	1, pointer to register values for call
;		2, pointer to area to save returned register values

;	exit 	machine status register value returned as func value

;	structure for register values is
;		struct regval{ unsigned ax,bx,cx,dx,si,di,ds,es;};


code	segment	byte public
	assume	cs:code
	public	sysint

sysint:
	push	ds		;save important registers
	push	es
	push	bp
	mov	bp,sp		;set our arg pointer
	mov	ax,12[bp]	;get return address value for MUCH later
	push	ax
	pushf			;push the flags for return
	pop	dx		;make a copy of flags
	push	dx
	push	cs		;and the code segment
	call	dummy		;push the ip
dummy:
	pop	ax		;get ip value
	sub	ax,offset dummy
	add	ax,offset sysint1
	push	ax		;return address
	and	dh,0ch		;clear I and T flag bits
	push	dx
	xor	bx,bx		;clear bx
	mov	es,bx		;and es
	mov	bl,8[bp]	;get int trap number
	shl	bx,1		;*2
	shl	bx,1		;*2 again (thats 4)
	push	es:word ptr 2[bx]
	push	es:word ptr [bx]		;thats the entry data
	mov	bx,10[bp]	;get source registers
	call	$mtor	;set up registers
	iret			;simulate an interrupt
sysint1:
	pushf			;save result flags for return
	call	$rtom	;return the registers to memory
	pop	ax		;result flags for user
	pop	bp		;dump return address
	pop	bp
	pop	es
	pop	ds		;restore segment registers
	ret			;all done



;	transfer memory to registers

;	entry	bx contains memory address
;	exit	values in registers

$mtor:
	mov	cx,8
mtor01:
	push	word ptr [bx]
	inc	bx
	inc	bx
	loop	mtor01		;push all 8 words
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

;	transfer registers to memory

;	entry	registers contain values

$rtom:

	push	es
	push	ds
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
	mov	bp,sp
	mov	bx,20[bp]		;get destination address
	mov	cx,8
rtom01:
	pop	ss:word ptr [bx]
	inc	bx
	inc	bx
	loop	rtom01
	ret			;dump the storage address

code	ends
	end
-ARCHIVE- $bfext.asm 479
;	bit field extract

;	entry	word containing bit field is on the stack

;	exit	extracted value is on the stack


code	segment	byte public
	assume	cs:code
	public	$bfext

$bfext	proc	near

	pop	bx			;get the return address
	pop	ax			;get word containing bits
	mov	cl,cs:[bx]		;get the shift count
	inc	bx
	shr	ax,cl			;do the shift
	and	ax,cs:[bx]		;keep the bits we want
	inc	bx
	inc	bx
	push	ax
	push	bx
	ret				;all done

$bfext	endp
code	ends
	end
-ARCHIVE- $bfinss.asm 805
;	bit field insert and store

;	entry	word containing bit field is on the stack
;		reg si contains the address to store result

;	exit	value stored, reg ax unchanged

code	segment	byte public
	assume	cs:code
	public	$bfinss

$bfinss	proc

	push	ax			;save the field value
	push	bp			;save the frame pointer
	mov	bp,sp			;get frame pointer
	mov	bx,4[bp]		;get the return address
	mov	cl,cs:[bx]		;get the shift count
	inc	bx
	shl	ax,cl			;do the shift
	mov	cx,cs:[bx]		;get the bit mask
	inc	bx
	inc	bx
	mov	4[bp],bx		;restore the return address
	and	ax,cx			;keep the bits we want
	not	cx			;keep the other bits
	and	cx,[si]			;the source data
	or	cx,ax			;the field is back
	mov	[si],cx			;put it back
	pop	bp;
	pop	ax
	ret				;all done

$bfinss	endp
code	ends
	end

-ARCHIVE- $iswitch.asm 635
;	code to process an integer switch statement

;	entry	0, return address
;		1, value to compare

code	segment	byte public
	assume	cs:code
	public	$iswitch

$iswitch:
	pop	di		;get address of data
	pop	ax		;and the value to check
	push	es		;save the register
	mov	bx,cs		;get code seg value
	mov	es,bx		;all set up
	mov	cx,es:[di]	;number of entries
	mov	bx,cx		;for exit
	sal	bx,1
	add	di,bx		;the last shall be first
	inc	cx		;for the default
	std			;set the direction flag
	repne scasw		;compare it
	pop	es		;restore register es
	add	di,4
	add	di,bx
	add	di,cs:[di]
	jmp	di		;go to it

code	ends
	end

-ARCHIVE- $llshift.asm 476
;	long left shift

;	entry	ax and dx contain value to be left shifted
;		cx contains the number of bits to shift

;	exit	shifted value in ax and dx

code	segment	byte public
	assume	cs:code
	public	$llshift

$llshift	proc	near

	jcxz	lls09			;don't shift anything
	cmp	cx,32			;max number of bits
	jbe	lls01			;valid
	mov	cx,32			;set to maximum
lls01:
	shl	ax,1
	rcl	dx,1
	loop	lls01			;do it for all bits
lls09:
	ret

$llshift	endp
code	ends
	end
-ARCHIVE- $lmul.asm 581
;	multiply two longs

;	entry	1,two longs on the stack
;	exit	1,result on stack, other long popped from stack


code	segment	byte public
	assume	cs:code
	public	$lmul

$lmul:
	push	bp
	mov	bp,sp
	mov	ax,10[bp]	;get high
	mul	word ptr 4[bp]	;* low
	mov	10[bp],ax	;partial result
	mov	ax,6[bp]	;other high
	mul	word ptr 8[bp]	;other low
	add	10[bp],ax	;more partial result
	mov	ax,4[bp]	;low
	mul	word ptr 8[bp]	;other low
	mov	8[bp],ax	;result
	add	10[bp],dx	;finish partial result
	pop	bp		;get back frame pointer
	ret	4		;dump one long

code	ends
	end
-ARCHIVE- $lrsshft.asm 477
;	long right signed shift

;	entry	ax and dx contain value to be shifted
;		cx contains the number of bits to shift

;	exit	shifted value in ax and dx

code	segment	byte public
	assume	cs:code
	public	$lrsshift

$lrsshift	proc

	jcxz	lrs09			;don't shift anything
	cmp	cx,32			;max number of bits
	jbe	lrs01			;valid
	mov	cx,32			;set to maximum
lrs01:
	sar	dx,1
	rcr	ax,1
	loop	lrs01			;do it for all bits
lrs09:
	ret

$lrsshift	endp
code	ends
	end
-ARCHIVE- $lrushft.asm 479
;	long right unsigned shift

;	entry	ax and dx contain value to be shifted
;		cx contains the number of bits to shift

;	exit	shifted value in ax and dx

code	segment	byte public
	assume	cs:code
	public	$lrushift

$lrushift	proc

	jcxz	lru09			;don't shift anything
	cmp	cx,32			;max number of bits
	jbe	lru01			;valid
	mov	cx,32			;set to maximum
lru01:
	shr	dx,1
	rcr	ax,1
	loop	lru01			;do it for all bits
lru09:
	ret

$lrushift	endp
code	ends
	end
-ARCHIVE- bdos.asm 199
;	call bdos for simple services


code	segment	byte public
	assume	cs:code
	public	bdos

bdos:
	push	bp
	mov	bp,sp
	mov	ah,4[bp]
	mov	dx,6[bp]
	int	21h
	pop	bp
	ret

code	ends
	end
-ARCHIVE- farcall.asm 1455
;	execute a far call with registers set up

;	entry	1, offset to call with respect to
;		2, cs to call
;		3, pointer to register values for call
;		4, pointer to area to save returned register values

;	exit 	machine status register value returned as func value

;	structure for register values is
;		struct regval{ unsigned ax,bx,cx,dx,si,di,ds,es;};


code	segment	byte public
	assume	cs:code
	public	farcall

farcall:
	push	ds		;save important registers
	push	es
	push	bp
	mov	bp,sp		;set our arg pointer

	mov	bx,12[bp]	;get source registers
	call	$mtor	;set up registers
	call	dword ptr 8[bp]	;execute the function

	pushf			;save result flags for return
	call	$rtom	;return the registers to memory
	pop	ax		;result flags for user
	pop	bp
	pop	es
	pop	ds		;restore segment registers
	ret			;all done


;	transfer memory to registers

;	entry	bx contains memory address
;	exit	values in registers

$mtor:

	mov	cx,8
mtor01:
	push	word ptr [bx]
	inc	bx
	inc	bx
	loop	mtor01		;push all 8 words
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

;	transfer registers to memory

;	entry	registers contain values

$rtom:

	push	es
	push	ds
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
	mov	bx,14[bp]		;get destination address
	mov	cx,8
rtom01:
	pop	ss:word ptr [bx]
	inc	bx
	inc	bx
	loop	rtom01
	ret			;dump the storage address

code	ends
	end
-ARCHIVE- inportb.asm 352
;	read an b bit value from a port

;	input	a port number
;	returns the input byte, zero filled


code	segment	byte public
	assume	cs:code
	public	inportb

inportb:
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,4[bp]	;get the port number
	in	al,dx		;get a byte value
	mov	ah,0		;zero the top byte
	pop	bp
	ret

code	ends
	end
-ARCHIVE- inportw.asm 308
;	read an w bit value from a port

;	input	a port number
;	returns the input word


code	segment	byte public
	assume	cs:code
	public	inportw

inportw:
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,4[bp]	;get the port number
	in	ax,dx		;get a byte value
	pop	bp
	ret

code	ends
	end
-ARCHIVE- intrserv.asm 1491
	title	'interrupt support package'

;	initialisation for this routine provided by intrinit.c


;	when we reach the following entry point
;	we have executed the code created by initintr
;	and the following conditions are true (we hope)

;	cs is set to our cs value
;	the stack contains
;		0, the value we need in register sp
;		2, the value we need in our ds register
;

;	entry point for interrupt service routines

code	segment	byte public
	assume	cs:code
	public	intrserv

intrserv	proc	far
	push	bp
	mov	bp,sp		;so we can see stack
	push	ds
	mov	ds,4[bp]	;sets up ds
	push	bx
	mov	bx,2[bp]	;stack rubbish
	sub	bx,9		;some room yet
	mov	[bx],ss		;save stack seg
	mov	2[bx],sp	;and the stack pointer
	mov	ss,4[bp]	;got ss setup
	mov	sp,bx		;and sp yet
	push	ax		;save other registers
	push	cx
	push	dx
	push	si
	push	di
	push	es
	mov	es,4[bp]
	call	word ptr 10[bx]		;execute the function
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	ax
	mov	bx,sp			;set up to restore stack
	mov	ss,[bx]
	mov	sp,2[bx]		;stack restored
	pop	bx
	pop	ds
	pop	bp
	ret			;all done
intrserv	endp

;	routine to poke a word into memory (somewhere)

;	entry	1, offset of place to poke
;		2, segment of place to poke
;		3, value to poke

pokew:
	push	bp
	mov	bp,sp
	push	es		;save the register
	les	si,dword ptr 4[bp]	;get where
	mov	ax,8[bp]	;get what
	mov	es:[si],ax	;its there
	pop	es		;restore es
	pop	bp
	ret			;all done

code	ends
	end
-ARCHIVE- movblock.asm 1937
;	'move a block of memory'
;	similar to movmem except that
;		1, uses a word move if count, source and dest are all even
;		2, needs segment values for source and dest also
;		3, turns off interrupts for word moves of less than 2 words

;	entry	1, the source address relative to
;		2, the source segment
;		3, the destination address relative to
;		4, the destination segment
;		5, the number of bytes to move (value must not exceed Xffc0)

code	segment	byte public
	assume	cs:code
	public	movblock

movblock:
	push	bp
	mov	bp,sp
	push	ds
	push	es
	pushf			;and the flags

	mov	si,4[bp]	;the source address
	mov	bx,si
	mov	cl,4
	shr	bx,cl
	add	bx,6[bp]	;canonical segment for block move

	mov	di,8[bp]	;the destination address
	mov	dx,di
	mov	cl,4
	shr	dx,cl
	add	dx,10[bp]	;canonical segment for block move

	mov	ax,0fh
	and	si,ax
	and	di,ax		;keep low 4 bits only

	mov	cx,12[bp]	;the number of bytes to move

	mov	ax,1		;see if we can use word move
	test	ax,cx		;odd number of bytes ?
	jnz	mb01		;yes
	test	ax,si		;odd source address
	jnz	mb01		;yes
	test	ax,di		;odd destination address ?
	jnz	mb01
	xor	ax,ax		;yes we can (flag for later)
mb01:

	cmp	bx,dx		;which way to do the move ?
	jb	mb03
	ja	mb02
	cmp	si,di		;which way to do the move ?
	jb	mb03		;do it in reverse order
mb02:
	cld
	jmp	short mb04		;must be this
mb03:
	add	si,cx		;point to other end of string
	dec	si
	add	di,cx
	dec	di
	std			;backwards in memory
	or	ax,ax		;see if a word move
	jnz	mb04		;nope
	dec	si
	dec	di
mb04:
	mov	ds,bx
	mov	es,dx		;seg regs set up
	or	ax,ax		;check for a word move
	jz	mb05		;do a word move
	rep	movsb		;do the move
	jmp	short mb07
mb05:
	shr	cx,1		;counts words
	cmp	cx,2		;if exactly 2 words
	jnz	mb06
	cli			;turn off interrupts
mb06:
	rep	movsw
mb07:
	popf			;restore flags and interrupts
	pop	es
	pop	ds
	pop	bp
	ret

code	ends
	end
-ARCHIVE- movmem.asm 701
;	'move a block of memory'

;	entry	1,the source address
;		2,the destination address
;		3,the number of bytes to move

code	segment	byte public
	assume	cs:code
	public	movmem

movmem:
	push	bp
	mov	bp,sp
	mov	ax,ds		;ensure that extra seg is correct
	mov	es,ax
	mov	si,4[bp];	;the source address
	mov	di,6[bp]	;the destination address
	mov	cx,8[bp]	;the number of bytes to move
	cmp	si,di		;which way to do the move ?
	jb	movmem01	;do it in reverse order
	cld
	jmp	short movmem02	;must be this
movmem01:
	add	si,cx		;point to other end of string
	dec	si
	add	di,cx
	dec	di
	std			;backwards in memory
movmem02:
	rep	movsb		;do the move
	pop	bp
	ret

code	ends
	end
-ARCHIVE- outportb.asm 320
;	write an 8 bit value to port

code	segment	byte public
	assume	cs:code
	public	outportb

outportb:
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,4[bp]	;get the port number
	mov	ax,6[bp]	;get the value to output
	mov	ah,0		;zero the top byte
	out	dx,al		;put it out
	pop	bp
	ret

code	ends
	end
-ARCHIVE- outportw.asm 290
;	write an 16 bit value to port

code	segment	byte public
	assume	cs:code
	public	outportw

outportw:
	push	bp
	mov	bp,sp		;set the frame pointer
	mov	dx,4[bp]	;get the port number
	mov	ax,6[bp]	;get the value to output
	out	dx,ax		;put it out
	pop	bp
	ret

code	ends
	end
-ARCHIVE- peek.asm 420
;	peek at a work in memory somewhere


;	entry	1, offset of place to peek
;		2, segment of place to peek

;	exit	ax contains copy of content of memory location


code	segment	byte public
	assume	cs:code
	public	peek

peek:
	push	bp
	mov	bp,sp
	push	es		;save the register
	les	si,dword ptr 4[bp]	;get where
	mov	ax,es:[si]	;get what
	pop	es		;restore es
	pop	bp
	ret			;all done

code	ends
	end
-ARCHIVE- pokeb.asm 437
;	poke a byte into memory somewhere

;	entry	1, offset of place to poke
;		2, segment of place to poke
;		3, value to poke (as the low byte of a word)


code	segment	byte public
	assume	cs:code
	public	pokeb

pokeb:
	push	bp
	mov	bp,sp
	push	es		;save the register
	les	si,dword ptr 4[bp]	;get where
	mov	ax,8[bp]	;get what
	mov	es:[si],al	;its there
	pop	es		;restore es
	pop	bp
	ret			;all done

code	ends
	end
-ARCHIVE- pokew.asm 409
;	poke a word into memory somewhere

;	entry	1, offset of place to poke
;		2, segment of place to poke
;		3, value to poke


code	segment	byte public
	assume	cs:code
	public	pokew

pokew:
	push	bp
	mov	bp,sp
	push	es		;save the register
	les	si,dword ptr 4[bp]	;get where
	mov	ax,8[bp]	;get what
	mov	es:[si],ax	;its there
	pop	es		;restore es
	pop	bp
	ret			;all done

code	ends
	end
-ARCHIVE- segread.asm 465
;	'read the segment registers'

;	entry	1, the address of a 4 word structure to hold the seg values
;
;	the format of the region is
;	struct regs {
;		unsigned cs;
;		unsigned ss;
;		unsigned ds;
;		unsigned es;
;	};

code	segment	byte public
	assume	cs:code
	public	segread

segread:
	mov	si,sp		;get argument
	mov	si,2[si]	;pointer to data
	mov	[si],cs
	mov	2[si],ss
	mov	4[si],ds
	mov	6[si],es
	ret			;all done you bet

code	ends
	end
-ARCHIVE- setmem.asm 532
;	'set memory to a specified character'

;	entry	1,the address of first character to be set
;		2,the number of bytes to set (unsigned int)
;		3,the desired value

code	segment	byte public
	assume	cs:code
	public	setmem

setmem:
	push	bp
	mov	bp,sp
	mov	ax,ds		;ensure that extra seg is correct
	mov	es,ax
	cld			;and clear the direction flag
	mov	di,4[bp]	;the address to set
	mov	cx,6[bp]	;the number of bytes to set
	mov	al,8[bp]	;the value to set
	rep	stosb		;set the area
	pop	bp
	ret

code	ends
	end

