C
C EXPRESSION EVALUATOR FOR 6800 ASSEMBLER
C UNSIGNED INTEGER ARITHMETIC
C ERROR CONDITIONS
C ERR = 0 => NO ERROR
C       1 => UNRESOLVED LABEL
C       2 => SYNTAX ERROR
C
      SUBROUTINE EXPR
      INTEGER ADR,ACC,LLEN,M,L,R,LVAL(300),BCNT,RANGE
      BYTE CB(80),LTAB(6,300),LTYP(300),ERR,ACCH,ACCL,CP,
     $AM,TAM
      LOGICAL LAB
C
      BYTE OPR(6),LKEY(6)
      BYTE CH,I,IUN,IOP
      BYTE DLLR,L0,L9,LA,LF,LZ,STAR,QUOTE,PLUS,MINUS,NEGA,SPACE
      LOGICAL IFLG,UNARY
      COMMON/OPER/CP,CB,LLEN,LAB,LTAB,LVAL,LTYP,ERR,
     $ACC,ACCH,ACCL,ADR,AM,TAM,BCNT,LSTF,RANGE
      COMMON/UL/LKEY
      DATA DLLR/'$'/,L0/'0'/,L9/'9'/,
     $LA/'A'/,LF/'F'/,LZ/'Z'/,STAR/'*'/,QUOTE/39/,
     $PLUS/'+'/,MINUS/'-'/,NEGA/'!'/,SPACE/' '/
      DATA OPR/'+','-','*','/','&',';'/
C
      ERR=0
      ACCL=0
      ACCH=0
      ACC=0
      IOP=1
      LAB=.FALSE.
      UNARY=.TRUE.
    5 CH=CB(CP)
      IF(CH.EQ.DLLR)GO TO 70
      IF(CH.GE.L0.AND.CH.LE.L9)GO TO 80
      IF(CH.GE.LA.AND.CH.LE.LZ)GO TO 60
      IF(CH.EQ.STAR)GO TO 50
      IF(CH.EQ.QUOTE)GO TO 40
      IF(.NOT.UNARY)GO TO 10
      IF(CH.EQ.PLUS)GO TO 30
      IF(CH.EQ.MINUS)GO TO 30
      IF(CH.EQ.NEGA)GO TO 30
C ERROR EXIT (OPERAND EVALUATION)
   10 ERR=2
      RETURN
C PROCESS UNARY
   30 IUN=CH
      UNARY=.FALSE.
      CP=CP+1
      IF(CP.GT.80)GO TO 10
      GO TO 5
C ASCII CONVERSION ROUTINE
   40 IF(CP.GT.77)GO TO 10
      IF(CB(CP+2).NE.QUOTE)GO TO 10
      IVAL=CB(CP+1).AND.255
      CP=CP+3
      GO TO 100
C LABEL SEARCH AND CONVERSION
   60 DO 61 I=1,6
      CH=CB(CP)
      IF(((CH.LT.LA).OR.(CH.GT.LZ)).AND.
     $((CH.LT.L0).OR.(CH.GT.L9)))GO TO 62
      LKEY(I)=CB(CP)
      CP=CP+1
      IF(CP.GT.80)GO TO 10
   61 CONTINUE
      GO TO 68
   62 DO 63 I=I,6
   63 LKEY(I)=SPACE
C SEARCH FOR LABEL
   68 L=1
      R=LLEN
   64 IF(L.GT.R)GO TO 69
      M=(L+R)/2
      DO 65 I=1,6
      IF(LKEY(I).NE.LTAB(I,M))GO TO 66
   65 CONTINUE
      IF(LTYP(M).AND.Z'80')LAB=.TRUE.
      IVAL=LVAL(M)
      GO TO 100
   66 IF(LKEY(I).LT.LTAB(I,M))GO TO 67
      L=M+1
      GO TO 64
   67 R=M-1
      GO TO 64
   69 ERR=1
      LAB=.TRUE.
      RETURN
C HEXADECIMAL CONVERSION
   70 IVAL=0
      IFLG=.TRUE.
   71 CP=CP+1
      IF(CP.GT.80)GO TO 10
      CH=CB(CP)
      IF(CH.LT.L0)GO TO 73
      IF(CH.GT.LF)GO TO 73
      IF(CH.LE.L9)GO TO 77
      IF(CH.LT.LA)GO TO 73
      CH=CH+9
   77 CH=CH.AND.15
      IVAL=IVAL*16+CH
      IFLG=.FALSE.
      GO TO 71
   73 IF(IFLG)GO TO 10
      GO TO 100
C DECIMAL CONVERSION
   80 IVAL=0
   85 CH=CB(CP)
      IF(CH.LT.L0)GO TO 100
      IF(CH.GT.L9)GO TO 100
      IVAL=IVAL*10+(CH.AND.15)
      CP=CP+1
      IF(CP.GT.80)GO TO 10
      GO TO 85
C CURRENT ADDRESS CONVERSION
   50 IVAL=ADR
      CP=CP+1
      IF(CP.GT.80)GO TO 10
  100 IF(UNARY)GO TO 110
      IF(IUN.EQ.MINUS)IVAL=0-IVAL
      IF(IUN.EQ.NEGA)IVAL=-1-IVAL
  110 UNARY=.TRUE.
      GO TO(130,135,140,145,150,155),IOP
  130 ACC=ACC+IVAL
      GO TO 200
  135 ACC=ACC-IVAL
      GO TO 200
  140 ACC=IUM(ACC,IVAL)
      GO TO 200
  145 IF(IVAL.EQ.0)GO TO 10
      ACC=IUD(ACC,IVAL)
      GO TO 200
  150 ACC=IAND(ACC,IVAL)
      GO TO 200
  155 ACC=IOR(ACC,IVAL)
      GO TO 200
  200 DO 220 I=1,6
      IF(CB(CP).EQ.OPR(I))GO TO 230
  220 CONTINUE
      ACCL=ACC.AND.255
      ACCH=IUD(ACC,256)
      RETURN
  230 IOP=I
      CP=CP+1
      IF(CP.GT.80)GO TO 10
      GO TO 5
      END
C 
C THIS PROGRAM DUMPS A HEX FILE
C TO BINARY OUTPUT FILE
C
      SUBROUTINE BINOT(DATA,DUMP)
      BYTE DATA,SUM,I,J,DFMT(11),DCNT,BIN(22),HEX(44)
      LOGICAL DUMP
      INTEGER BADR,OBJF
      COMMON /BINC/BADR,OBJF,DCNT
      DATA DFMT/'(','2','H',' ',':',',',' ',' ',
     $'A','1',')'/
      IF(DUMP)GO TO 10
      DCNT=DCNT+1
      BIN(DCNT+4)=DATA
      IF(DCNT.EQ.1)GO TO 40
      IF(DCNT.LT.16)RETURN
   10 IF(DCNT.EQ.0)RETURN
      SUM=0
      BIN(1)=DCNT
      DCNT=DCNT+4
      DO 20 I=1,DCNT
   20 SUM=SUM+BIN(I)
      DCNT=DCNT+1
      BIN(DCNT)=(-SUM).AND.255
      J=1
      DO 30 I=1,DCNT
      CALL HEX8(BIN(I),HEX(J),HEX(J+1))
   30 J=J+2
      CALL DEC(J,DFMT(7),DFMT(8))
      J=J-1
      WRITE(OBJF,DFMT)(HEX(I),I=1,J)
      DCNT=0
      RETURN
   40 BIN(2)=IUD(BADR,256)
      BIN(3)=BADR.AND.255
      BIN(4)=0
      RETURN
      END
C
C SUBROUTINE TO CONVERT 2 DIGIT
C BINARY NUMBER TO ASCII REPRESENTATION
C IN DECIMAL
C
      SUBROUTINE DEC(IN,MSD,LSD)
      BYTE IN,MSD,LSD
      MSD=IN/10
      LSD=IN-(MSD*10)
      MSD=MSD+Z'30'
      LSD=LSD+Z'30'
      IF(MSD.EQ.Z'30')MSD=Z'20'
      RETURN
      END
C
C SUBROUTINE TO DUMP SYMBOL TABLE
C
      SUBROUTINE DUMP
      INTEGER ADR,ACC,LLEN,LVAL(300),BCNT,RANGE,BIAS
      BYTE CB(80),LTAB(6,300),ERR,ACCH,ACCL,CP,DPR,PB,AM,
     $TAM,LTYP(300),LSY1(6),LSY2(6),LSY3(6),LTC(6),
     $CD(70),CIF,TTL(40),LNFMT,DCT,CPB,CPE,I
      INTEGER TOKEN,PAGE,BIAS,NLP,NLIN
      LOGICAL LAB,PREB,COND(10),LABF,NOPER,PASS2
      COMMON/OPER/CP,CB,LLEN,LAB,LTAB,LVAL,LTYP,ERR,
     $ACC,ACCH,ACCL,ADR,AM,TAM,BCNT,LSTF,RANGE
      COMMON/PRSE/TOKEN,CD,CIF,COND,TTL,LNFMT,DCT,CPB,
     $CPE,LABF,NOPER,PASS2,PAGE
      DATA LTC/'N','C','E','S','D','R'/
      IF(LLEN.EQ.0)GO TO 200
      LSY1(5)=' '
      LSY2(5)=' '
      LSY3(5)=' '
C NLIN IS NUMBER OF LINES
      NLIN=40
C NLP IS LINES TO PAGE
      NLP=3*NLIN
      BIAS=0
   20 WRITE(LSTF,1005)PAGE,TTL
      PAGE=PAGE+1
      LINE=1
   10 L1=LINE+BIAS
      L2=LINE+NLIN+BIAS
      L3=LINE+(2*NLIN)+BIAS
      IF(L1.GT.LLEN)GO TO 130
      IF(L2.GT.LLEN)GO TO 120
      IF(L3.GT.LLEN)GO TO 110
      CALL HEX16(LVAL(L1),LSY1(1),LSY1(2),LSY1(3),LSY1(4))
      J=LTYP(L1)
      LSY1(6)=LTC(J)
      CALL HEX16(LVAL(L2),LSY2(1),LSY2(2),LSY2(3),LSY2(4))
      J=LTYP(L2)
      LSY2(6)=LTC(J)
      CALL HEX16(LVAL(L3),LSY3(1),LSY3(2),LSY3(3),LSY3(4))
      J=LTYP(L3)
      LSY3(6)=LTC(J)
      WRITE(LSTF,1001)(LTAB(I,L1),I=1,6),LSY1,
     $(LTAB(I,L2),I=1,6),LSY2,(LTAB(I,L3),I=1,6),LSY3
 1001 FORMAT(1X,3(6A1,1X,6A1,5X))
      GO TO 100
  110 CALL HEX16(LVAL(L1),LSY1(1),LSY1(2),LSY1(3),LSY1(4))
      J=LTYP(L1)
      LSY1(6)=LTC(J)
      CALL HEX16(LVAL(L2),LSY2(1),LSY2(2),LSY2(3),LSY2(4))
      J=LTYP(L2)
      LSY2(6)=LTC(J)
      WRITE(LSTF,1002)(LTAB(I,L1),I=1,6),LSY1,
     $(LTAB(I,L2),I=1,6),LSY2
 1002 FORMAT(1X,2(6A1,1X,6A1,5X))
      GO TO 100
  120 CALL HEX16(LVAL(L1),LSY1(1),LSY1(2),LSY1(3),LSY1(4))
      J=LTYP(L1)
      LSY1(6)=LTC(J)
      WRITE(LSTF,1003)(LTAB(I,L1),I=1,6),LSY1
 1003 FORMAT(1X,6A1,1X,6A1)
  100 LINE=LINE+1
      IF(LINE.LE.NLIN)GO TO 10
      BIAS=BIAS+NLP
      IF(BIAS.GE.LLEN)GO TO 130
      GO TO 20
  130 WRITE(LSTF,1006)
 1006 FORMAT(1H1)
      RETURN
 1005 FORMAT('1Page',I5,' Symbol Table ',40A1//)
  200 WRITE(LSTF,1010)
 1010 FORMAT(' No Symbols In Table')
      RETURN
      END
C
C SUBROUTINE TO CONVERT
C 16 BIT BINARY INTEGER TO 
C 4 HEXADECIMAL CHARACTERS
C
      SUBROUTINE HEX16(IN,CH1,CH2,CH3,CH4)
      BYTE CH1,CH2,CH3,CH4
      INTEGER IN
      CH1=IUD(IN,4096).AND.15
      IF(CH1.GT.9)CH1=CH1+7
      CH1=CH1+Z'30'
      CH2=IUD(IN,256).AND.15
      IF(CH2.GT.9)CH2=CH2+7
      CH2=CH2+Z'30'
      CH3=IUD(IN,16).AND.15
      IF(CH3.GT.9)CH3=CH3+7
      CH3=CH3+Z'30'
      CH4=IN.AND.15
      IF(CH4.GT.9)CH4=CH4+7
      CH4=CH4+Z'30'
      RETURN
      END
C
C SUBROUTINE TO CONVERT
C 8 BIT BINARY BYTE TO
C 2 HEXADECIMAL CHARACTERS
C
      SUBROUTINE HEX8(IN,CH1,CH2)
      BYTE IN,CH1,CH2
      CH1=IUD(IN,16).AND.15
      IF(CH1.GT.9)CH1=CH1+7
      CH1=CH1+Z'30'
      CH2=IN.AND.15
      IF(CH2.GT.9)CH2=CH2+7
      CH2=CH2+Z'30'
      RETURN
      END
