NAME
     grep, egrep - print lines matching a regular expression

SYNOPSIS
     grep [ -CVbchilnsvwx ] [ -num ] [ -AB num ] [ [ -e ] expr |
     -f file ] [ files ... ]

DESCRIPTION
     Grep searches the files listed in the arguments (or standard
     input if no files are given) for all lines that contain a
     match for the given expr.  If any lines match, they are
     printed.

     Also, if any matches were found, grep will exit with a
     status of 0, but if no matches were found it will exit with
     a status of 1.  This is useful for building shell scripts
     that use grep as a condition for, for example, the if state-
     ment.

     When invoked as egrep the syntax of the expr is slightly
     different; See below.

REGULAR EXPRESSIONS
          (grep)    (egrep)   (explanation)

          c         c         a single (non-meta) character
                              matches itself.

          .         .         matches any single character except
                              newline.

          \?        ?         postfix operator; preceeding item
                              is optional.

          *         *         postfix operator; preceeding item 0
                              or more times.

          \+        +         postfix operator; preceeding item 1
                              or more times.

          \|        |         infix operator; matches either
                              argument.

          ^         ^         matches the empty string at the
                              beginning of a line.

          $         $         matches the empty string at the end
                              of a line.

          \<        \<        matches the empty string at the
                              beginning of a word.

          \>        \>        matches the empty string at the end
                              of a word.

          [chars]   [chars]   match any character in the given
                              class; if the first character after
                              [ is ^, match any character not in
                              the given class; a range of charac-
                              ters may be specified by
                              first-last; for example, \W (below)
                              is equivalent to the class
                              [^A-Za-z0-9]

          \( \)     ( )       parentheses are used to override
                              operator precedence.

          \digit    \digit    \n matches a repeat of the text
                              matched earlier in the regexp by
                              the subexpression inside the nth
                              opening parenthesis.

          \         \         any special character may be pre-
                              ceded by a backslash to match it
                              literally.

          (the following are for compatibility with GNU Emacs)

          \b        \b        matches the empty string at the
                              edge of a word.

          \B        \B        matches the empty string if not at
                              the edge of a word.

          \w        \w        matches word-constituent characters
                              (letters & digits).

          \W        \W        matches characters that are not
                              word-constituent.

     Operator precedence is (highest to lowest) ?, *, and +, con-
     catenation, and finally |.  All other constructs are syntac-
     tically identical to normal characters.  For the truly
     interested, the file dfa.c describes (and implements) the
     exact grammar understood by the parser.

OPTIONS
     -A num
          print <num> lines of context after every matching line

     -B num
          print num lines of context before every matching line

     -C   print 2 lines of context on each side of every match

     -num print num lines of context on each side of every match

     -V   print the version number on the diagnostic output

     -b   print every match preceded by its byte offset

     -c   print a total count of matching lines only

     -e expr
          search for expr; useful if expr begins with -

     -f file
          search for the expression contained in file

     -h   don't display filenames on matches

     -i   ignore case difference when comparing strings

     -l   list files containing matches only

     -n   print each match preceded by its line number

     -s   run silently producing no output except error messages

     -v   print only lines that contain no matches for the <expr>

     -w   print only lines where the match is a complete word

     -x   print only lines where the match is a whole line

SEE ALSO
     emacs(1), ed(1), sh(1), GNU Emacs Manual

INCOMPATIBILITIES
     The following incompatibilities with UNIX grep exist:

          The context-dependent meaning of * is not quite the
          same (grep only).

          -b prints a byte offset instead of a block offset.

          The {m,n} construct of System V grep is not imple-
          mented.

BUGS
     GNU e?grep has been thoroughly debugged and tested by
     several people over a period of several months; we think
     it's a reliable beast or we wouldn't distribute it.  If by
     some fluke of the universe you discover a bug, send a
     detailed description (including options, regular expres-
     sions, and a copy of an input file that can reproduce it) to
     me, mike@wheaties.ai.mit.edu.

     There is also a newsgroup, gnu.utils.bug, for reporting FSF
     utility programs' bugs and fixes; but before reporting some-
     thing as a bug, please try to be sure that it really is a
     bug, not a misunderstanding or a deliberate feature.  Also,
     include the version number of the utility program you are
     running in every bug report that you send in.  Please do not
     send anything but bug reports to this newsgroup.

AVAILABILITY
     GNU grep is free; anyone may redistribute copies of grep to
     anyone under the terms stated in the GNU General Public
     License, a copy of which may be found in each copy of GNU
     Emacs.  See also the comment at the beginning of the source
     code file grep.c.

     Copies of GNU grep may sometimes be received packaged with
     distributions of Unix systems, but it is never included in
     the scope of any license covering those systems.  Such
     inclusion violates the terms on which distribution is per-
     mitted.  In fact, the primary purpose of the General Public
     License is to prohibit anyone from attaching any other res-
     trictions to redistribution of any of the Free Software
     Foundation programs.

AUTHORS
     Mike Haertel wrote the deterministic regexp code and the
     bulk of the program.

     James A. Woods is responsible for the hybridized search
     strategy of using Boyer-Moore-Gosper fixed-string search as
     a filter before calling the general regexp matcher.

     Arthur David Olson contributed code that finds fixed strings
     for the aforementioned BMG search for a large class of
     regexps.

     Richard Stallman wrote the backtracking regexp matcher that
     is used for \digit backreferences, as well as the getopt
     that is provided for 4.2BSD sites.  The backtracking matcher
     was originally written for GNU Emacs.

     D. A. Gwyn wrote the C alloca emulation that is provided so
     System V machines can run this program.  (Alloca is used
     only by RMS' backtracking matcher, and then only rarely, so
     there is no loss if your machine doesn't have a "real"
     alloca.)

     Scott Anderson and Henry Spencer designed the regression
     tests used in the "regress" script.

     Paul Placeway wrote the original version of this manual
     page.
