% The functions here are used to manipulate the syntax keyword tables

define syntax_strcmp ()
{
   strcmp ((), ()) < 0;
}

define add_keyword_n (table, kw, n)
{
   variable old_list, new_list;
   variable len = strlen (kw);
   variable a, nelems, i, oldkw;
   variable index_array;
   
   !if (len) return;
   
   % get the keyword list for this table
   old_list = define_keywords_n (table, Null_String, len, n);
   
   % create an array to sort
   nelems = 1 + strlen (old_list) / len;
   a = create_array ('s', nelems, 1);
   
   _for (0, nelems - 2, 1)
     {
	i = ();
	a[i] = substr (old_list, 1 + i * len, len);
     }

   a[nelems - 1] = kw;
   index_array = array_sort (a, "syntax_strcmp");
   
   new_list = Null_String;
   _for (0, nelems - 1, 1)
     {
	i = ();
	new_list = strcat (new_list, a[index_array[i]]);
     }
   message (strncat(new_list, "  ", old_list, 3));
   () = define_keywords_n (table, new_list, len, n);
}

   
define add_keyword ()
{
   add_keyword_n (0);
}

